/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelEvent;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartLevelManager
implements EventDispatcher<Object, Object, StartLevelEvent>,
StartLevel {
    protected static EventManager eventManager;
    protected static Map<Object, Object> startLevelListeners;
    protected int initialBundleStartLevel = 1;
    private int activeSL = 0;
    private final Object lock = new Object();
    private final Framework framework;

    protected StartLevelManager(Framework framework) {
        this.framework = framework;
    }

    protected void initialize() {
        this.initialBundleStartLevel = this.framework.adaptor.getInitialBundleStartLevel();
        eventManager = new EventManager("Start Level Event Dispatcher");
        startLevelListeners = new CopyOnWriteIdentityMap<Object, Object>();
        startLevelListeners.put(this, this);
    }

    protected void cleanup() {
        eventManager.close();
        eventManager = null;
        startLevelListeners.clear();
        startLevelListeners = null;
    }

    @Override
    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    @Override
    public void setInitialBundleStartLevel(int n) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "startlevel");
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.initialBundleStartLevel = n;
        this.framework.adaptor.setInitialBundleStartLevel(n);
    }

    @Override
    public int getStartLevel() {
        return this.activeSL;
    }

    public void setStartLevel(int n, Bundle bundle, FrameworkListener[] frameworkListenerArray) {
        if (n <= 0) {
            throw new IllegalArgumentException(NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, new StringBuffer().append(n).toString()));
        }
        this.framework.checkAdminPermission(this.framework.systemBundle, "startlevel");
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println(new StringBuffer("StartLevelImpl: setStartLevel: ").append(n).append("; callerBundle = ").append(bundle.getBundleId()).toString());
        }
        this.issueEvent(new StartLevelEvent(1, n, (AbstractBundle)bundle, frameworkListenerArray));
    }

    @Override
    public void setStartLevel(int n) {
        this.setStartLevel(n, this.framework.systemBundle, new FrameworkListener[0]);
    }

    protected void shutdown() {
        this.doSetStartLevel(0, new FrameworkListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetStartLevel(int n, FrameworkListener[] frameworkListenerArray) {
        Object object = this.lock;
        synchronized (object) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ContextFinder contextFinder = this.framework.getContextFinder();
            if (contextFinder == classLoader) {
                contextFinder = null;
            } else {
                Thread.currentThread().setContextClassLoader(contextFinder);
            }
            try {
                try {
                    int n2 = this.activeSL;
                    if (n > n2) {
                        boolean bl = n2 == 0;
                        int n3 = n2;
                        while (n3 < n) {
                            if (Debug.DEBUG_STARTLEVEL) {
                                Debug.println(new StringBuffer("sync - incrementing Startlevel from ").append(n2).toString());
                            }
                            ++n2;
                            this.incFWSL(n3 + 1, this.getInstalledBundles(this.framework.bundles, false));
                            ++n3;
                        }
                        if (bl) {
                            this.framework.systemBundle.state = 32;
                            this.framework.publishBundleEvent(2, this.framework.systemBundle);
                            this.framework.publishFrameworkEvent(1, this.framework.systemBundle, null);
                        }
                    } else {
                        AbstractBundle[] abstractBundleArray = this.getInstalledBundles(this.framework.bundles, true);
                        int n4 = n2;
                        while (n4 > n) {
                            if (Debug.DEBUG_STARTLEVEL) {
                                Debug.println(new StringBuffer("sync - decrementing Startlevel from ").append(n2).toString());
                            }
                            --n2;
                            this.decFWSL(n4 - 1, abstractBundleArray);
                            --n4;
                        }
                        if (n == 0) {
                            this.suspendAllBundles(this.framework.bundles);
                            this.unloadAllBundles(this.framework.bundles);
                        }
                    }
                    this.framework.publishFrameworkEvent(8, this.framework.systemBundle, null, frameworkListenerArray);
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("StartLevelImpl: doSetStartLevel: STARTLEVEL_CHANGED event published");
                    }
                }
                catch (Error error) {
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, error, frameworkListenerArray);
                    throw error;
                }
                catch (RuntimeException runtimeException) {
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, runtimeException, frameworkListenerArray);
                    throw runtimeException;
                }
            }
            finally {
                if (contextFinder != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveActiveStartLevel(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.activeSL = n;
        }
    }

    @Override
    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        return ((AbstractBundle)bundle).isPersistentlyStarted();
    }

    @Override
    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        return ((AbstractBundle)bundle).isActivationPolicyUsed();
    }

    @Override
    public int getBundleStartLevel(Bundle bundle) {
        return ((AbstractBundle)bundle).getStartLevel();
    }

    @Override
    public void setBundleStartLevel(Bundle bundle, int n) {
        block11: {
            String string = null;
            if (bundle.getBundleId() == 0L) {
                string = Msg.STARTLEVEL_CANT_CHANGE_SYSTEMBUNDLE_STARTLEVEL;
            } else if (bundle.getState() == 1) {
                string = NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation());
            } else if (n <= 0) {
                string = NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, new StringBuffer().append(n).toString());
            }
            if (string != null) {
                throw new IllegalArgumentException(string);
            }
            this.framework.checkAdminPermission(bundle, "execute");
            try {
                if (n == ((AbstractBundle)bundle).getInternalStartLevel()) break block11;
                final AbstractBundle abstractBundle = (AbstractBundle)bundle;
                abstractBundle.getBundleData().setStartLevel(n);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            abstractBundle.getBundleData().save();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getException() instanceof IOException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    throw (RuntimeException)privilegedActionException.getException();
                }
                this.issueEvent(new StartLevelEvent(0, n, (AbstractBundle)bundle, new FrameworkListener[0]));
            }
            catch (IOException iOException) {
                this.framework.publishFrameworkEvent(2, bundle, iOException);
            }
        }
    }

    private void issueEvent(StartLevelEvent startLevelEvent) {
        ListenerQueue<Object, Object, StartLevelEvent> listenerQueue = new ListenerQueue<Object, Object, StartLevelEvent>(eventManager);
        listenerQueue.queueListeners(startLevelListeners.entrySet(), this);
        listenerQueue.dispatchEventAsynchronous(startLevelEvent.getType(), startLevelEvent);
    }

    @Override
    public void dispatchEvent(Object object, Object object2, int n, StartLevelEvent startLevelEvent) {
        try {
            switch (n) {
                case 0: {
                    this.setBundleSL(startLevelEvent);
                    break;
                }
                case 1: {
                    this.doSetStartLevel(startLevelEvent.getNewSL(), startLevelEvent.getListeners());
                }
            }
        }
        catch (Throwable throwable) {
            this.framework.adaptor.handleRuntimeError(throwable);
        }
    }

    protected void incFWSL(int n, AbstractBundle[] abstractBundleArray) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println(new StringBuffer("SLL: incFWSL: saving activeSL of ").append(n).toString());
        }
        this.saveActiveStartLevel(n);
        this.resumeBundles(abstractBundleArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBundle[] getInstalledBundles(BundleRepository bundleRepository, boolean bl) {
        Object[] objectArray;
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List<AbstractBundle> list = bundleRepository.getBundles();
            objectArray = new AbstractBundle[list.size()];
            list.toArray(objectArray);
            Util.sort(objectArray, 0, objectArray.length);
            if (bl) {
                this.sortByDependency((AbstractBundle[])objectArray);
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortByDependency(AbstractBundle[] abstractBundleArray) {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            if (abstractBundleArray.length <= 1) {
                return;
            }
            int n = abstractBundleArray[0].getInternalStartLevel();
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 < abstractBundleArray.length) {
                if (n != abstractBundleArray[n3].getInternalStartLevel()) {
                    if (bl) {
                        this.sortByDependencies(abstractBundleArray, n2, n3);
                    }
                    n = abstractBundleArray[n3].getInternalStartLevel();
                    n2 = n3;
                    bl = false;
                }
                bl |= (abstractBundleArray[n3].getBundleData().getStatus() & 2) != 0;
                ++n3;
            }
            if (bl) {
                this.sortByDependencies(abstractBundleArray, n2, abstractBundleArray.length);
            }
        }
    }

    private void sortByDependencies(AbstractBundle[] abstractBundleArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(n2 - n);
        ArrayList<AbstractBundle> arrayList2 = new ArrayList<AbstractBundle>(0);
        int n3 = n;
        while (n3 < n2) {
            BundleDescription bundleDescription = abstractBundleArray[n3].getBundleDescription();
            if (bundleDescription != null) {
                arrayList.add(bundleDescription);
            } else {
                arrayList2.add(abstractBundleArray[n3]);
            }
            ++n3;
        }
        if (arrayList.size() <= 1) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = arrayList.toArray(new BundleDescription[arrayList.size()]);
        this.framework.adaptor.getPlatformAdmin().getStateHelper().sortBundles(bundleDescriptionArray);
        int n4 = n;
        while (n4 < bundleDescriptionArray.length + n) {
            abstractBundleArray[n4] = this.framework.bundles.getBundle(bundleDescriptionArray[n4 - n].getBundleId());
            ++n4;
        }
        if (arrayList2.size() > 0) {
            Iterator iterator = arrayList2.iterator();
            int n5 = n + bundleDescriptionArray.length;
            while (n5 < n2 && iterator.hasNext()) {
                abstractBundleArray[n5] = (AbstractBundle)iterator.next();
                ++n5;
            }
        }
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, int n) {
        this.resumeBundles(abstractBundleArray, true, n);
        this.resumeBundles(abstractBundleArray, false, n);
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl, int n) {
        int n2 = 0;
        while (n2 < abstractBundleArray.length && !this.framework.isForcedRestart()) {
            int n3 = abstractBundleArray[n2].getInternalStartLevel();
            if (n3 >= n) {
                if (n3 != n) break;
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println(new StringBuffer("SLL: Active sl = ").append(n).append("; Bundle ").append(abstractBundleArray[n2].getBundleId()).append(" sl = ").append(n3).toString());
                }
                boolean bl2 = abstractBundleArray[n2].isLazyStart();
                if (bl ? bl2 : !bl2) {
                    this.framework.resumeBundle(abstractBundleArray[n2]);
                }
            }
            ++n2;
        }
    }

    protected void decFWSL(int n, AbstractBundle[] abstractBundleArray) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println(new StringBuffer("SLL: decFWSL: saving activeSL of ").append(n).toString());
        }
        this.saveActiveStartLevel(n);
        if (n == 0) {
            return;
        }
        int n2 = abstractBundleArray.length - 1;
        while (n2 >= 0) {
            int n3 = abstractBundleArray[n2].getInternalStartLevel();
            if (n3 <= n + 1) {
                if (n3 <= n) break;
                if (abstractBundleArray[n2].isActive()) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println(new StringBuffer("SLL: stopping bundle ").append(abstractBundleArray[n2].getBundleId()).toString());
                    }
                    this.framework.suspendBundle(abstractBundleArray[n2], false);
                }
            }
            --n2;
        }
    }

    private void suspendAllBundles(BundleRepository bundleRepository) {
        boolean bl;
        do {
            bl = false;
            AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository, false);
            int n = abstractBundleArray.length - 1;
            while (n >= 0) {
                AbstractBundle abstractBundle = abstractBundleArray[n];
                if (this.framework.suspendBundle(abstractBundle, false)) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println(new StringBuffer("SLL: stopped bundle ").append(abstractBundle.getBundleId()).toString());
                    }
                    bl = true;
                }
                --n;
            }
        } while (bl);
        try {
            this.framework.systemBundle.context.stop();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println(new StringBuffer("SLL: Bundle suspend exception: ").append(bundleException.getMessage()).toString());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
        }
        this.framework.systemBundle.state = 4;
        this.framework.publishBundleEvent(4, this.framework.systemBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllBundles(BundleRepository bundleRepository) {
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List<AbstractBundle> list = bundleRepository.getBundles();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = list.get(n2);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println(new StringBuffer("SLL: Trying to unload bundle ").append(abstractBundle).toString());
                }
                abstractBundle.refresh();
                try {
                    abstractBundle.getBundleData().close();
                }
                catch (IOException iOException) {}
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSL(StartLevelEvent startLevelEvent) {
        Object object = this.lock;
        synchronized (object) {
            int n = this.getStartLevel();
            int n2 = startLevelEvent.getNewSL();
            AbstractBundle abstractBundle = startLevelEvent.getBundle();
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.print(new StringBuffer("SLL: bundle active=").append(abstractBundle.isActive()).toString());
                Debug.print(new StringBuffer("; newSL = ").append(n2).toString());
                Debug.println(new StringBuffer("; activeSL = ").append(n).toString());
            }
            if (abstractBundle.isActive() && n2 > n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println(new StringBuffer("SLL: stopping bundle ").append(abstractBundle.getBundleId()).toString());
                }
                this.framework.suspendBundle(abstractBundle, false);
            } else if (!abstractBundle.isActive() && n2 <= n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println(new StringBuffer("SLL: starting bundle ").append(abstractBundle.getBundleId()).toString());
                }
                this.framework.resumeBundle(abstractBundle);
            }
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println(new StringBuffer("SLL: Bundle Startlevel set to ").append(n2).toString());
            }
        }
    }
}

