/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkConsole;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkCommandInterpreter
implements CommandInterpreter {
    private static final String WS_DELIM = " \t\n\r\f";
    private StringTokenizer tok;
    private CommandProvider[] commandProviders;
    private FrameworkConsole con;
    private PrintWriter out;
    private String tab = "\t";
    private String newline = "\r\n";
    private boolean firstCommand = true;
    protected static int maxLineCount;
    protected int currentLineCount;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FrameworkCommandInterpreter(String string, CommandProvider[] commandProviderArray, FrameworkConsole frameworkConsole) {
        this.tok = new StringTokenizer(string);
        this.commandProviders = commandProviderArray;
        this.con = frameworkConsole;
        this.out = frameworkConsole.getWriter();
    }

    @Override
    public String nextArgument() {
        if (this.tok == null || !this.tok.hasMoreElements()) {
            return null;
        }
        return this.consumeQuotes(this.tok.nextToken());
    }

    private String consumeQuotes(String string) {
        if (!string.startsWith("\"") && !string.startsWith("'")) {
            return string;
        }
        String string2 = string.substring(0, 1);
        if (string.endsWith(string2)) {
            if (string.length() >= 2) {
                return string.substring(1, string.length() - 1);
            }
            return "";
        }
        try {
            string = new StringBuffer(String.valueOf(string.substring(1))).append(this.tok.nextToken(string2)).toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.printStackTrace(noSuchElementException);
            return "";
        }
        try {
            this.tok.nextToken(WS_DELIM);
        }
        catch (NoSuchElementException noSuchElementException) {}
        return string;
    }

    @Override
    public Object execute(String string) {
        if (!this.firstCommand) {
            return this.innerExecute(string);
        }
        this.firstCommand = false;
        this.resetLineCount();
        Object object = null;
        if (string.equalsIgnoreCase("more")) {
            try {
                this._more();
            }
            catch (Exception exception) {
                this.printStackTrace(exception);
            }
            return object;
        }
        if (string.equalsIgnoreCase("disconnect")) {
            try {
                this._disconnect();
            }
            catch (Exception exception) {
                this.printStackTrace(exception);
            }
            return object;
        }
        if (string.equalsIgnoreCase("help") && !this.tok.hasMoreElements()) {
            this.displayAllHelp();
            return object;
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandInterpreter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        Object[] objectArray = new Object[]{this};
        boolean bl = false;
        int n = this.commandProviders.length;
        if (string.equalsIgnoreCase("help") && this.tok.hasMoreElements()) {
            String string2 = this.nextArgument();
            String string3 = this.getHelp(string2);
            if (string3 != null) {
                this.print(string3);
                return string3;
            }
            int n2 = 0;
            while (n2 < n) {
                this.tok = new StringTokenizer(string2);
                boolean bl2 = false;
                CommandProvider commandProvider = this.commandProviders[n2];
                Method method = null;
                try {
                    method = commandProvider.getClass().getMethod(new StringBuffer("_").append(string).toString(), classArray2);
                    object = method.invoke((Object)commandProvider, objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl2 = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.printStackTrace(invocationTargetException.getTargetException());
                    bl2 = true;
                }
                catch (Exception exception) {
                    this.printStackTrace(exception);
                }
                if (object != null) {
                    if (object instanceof Boolean) {
                        bl = bl || (Boolean)object != false;
                    } else {
                        if (object instanceof String) {
                            this.print(object);
                            return object;
                        }
                        bl = true;
                    }
                } else {
                    bl = bl || !bl2;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (!bl && n3 < n) {
                try {
                    CommandProvider commandProvider = this.commandProviders[n3];
                    Method method = commandProvider.getClass().getMethod(new StringBuffer("_").append(string).toString(), classArray2);
                    object = method.invoke((Object)commandProvider, objectArray);
                    bl = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    bl = true;
                    this.printStackTrace(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    bl = true;
                    this.printStackTrace(exception);
                }
                ++n3;
            }
        }
        if (!bl) {
            this.displayAllHelp();
        }
        return object;
    }

    private void displayAllHelp() {
        int n = this.commandProviders.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                CommandProvider commandProvider = this.commandProviders[n2];
                this.out.print(commandProvider.getHelp());
                this.out.flush();
            }
            catch (Exception exception) {
                this.printStackTrace(exception);
            }
            ++n2;
        }
        this.out.print(this.getHelp(null));
        this.out.flush();
    }

    private Object innerExecute(String string) {
        FrameworkCommandInterpreter frameworkCommandInterpreter;
        String string2;
        if (string != null && string.length() > 0 && (string2 = (frameworkCommandInterpreter = new FrameworkCommandInterpreter(string, this.commandProviders, this.con)).nextArgument()) != null) {
            return frameworkCommandInterpreter.execute(string2);
        }
        return null;
    }

    private int getMaximumLinesToScroll() {
        return maxLineCount;
    }

    private void setMaximumLinesToScroll(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(ConsoleMsg.CONSOLE_LINES_TO_SCROLL_NEGATIVE_ERROR);
        }
        maxLineCount = n;
    }

    private void resetLineCount() {
        this.currentLineCount = 0;
    }

    private void printline(Object object) {
        this.print(new StringBuffer().append(object).append(this.newline).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Object object) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.check4More();
            this.out.print(object);
            this.out.flush();
        }
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.out);
        Method[] methodArray = throwable.getClass().getMethods();
        int n = methodArray.length;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && clazz2.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0) {
                try {
                    Throwable throwable2 = (Throwable)method.invoke((Object)throwable, null);
                    if (throwable2 != null && throwable2 != throwable) {
                        this.out.println(ConsoleMsg.CONSOLE_NESTED_EXCEPTION);
                        this.printStackTrace(throwable2);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object object) {
        if (object == null) {
            return;
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.check4More();
            this.printline(object);
            ++this.currentLineCount;
            this.currentLineCount += object.toString().length() / 80;
        }
    }

    @Override
    public void printDictionary(Dictionary<?, ?> dictionary, String string) {
        if (dictionary == null) {
            return;
        }
        int n = dictionary.size();
        Object[] objectArray = new String[n];
        Enumeration<?> enumeration = dictionary.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n2++] = (String)enumeration.nextElement();
        }
        Util.sortByString(objectArray);
        if (string != null) {
            this.println(string);
        }
        n2 = 0;
        while (n2 < n) {
            this.println(new StringBuffer(" ").append((String)objectArray[n2]).append(" = ").append(dictionary.get(objectArray[n2])).toString());
            ++n2;
        }
        this.println();
    }

    @Override
    public void printBundleResource(Bundle bundle, String string) {
        block12: {
            URL uRL = null;
            uRL = bundle.getEntry(string);
            if (uRL != null) {
                try {
                    this.println(string);
                    InputStream inputStream = uRL.openStream();
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    try {
                        while ((n = inputStream.read(byArray)) != -1) {
                            this.print(new String(byArray, 0, n));
                        }
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (inputStream == null) break block12;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception exception) {
                    System.err.println(NLS.bind(ConsoleMsg.CONSOLE_ERROR_READING_RESOURCE, string));
                }
            } else {
                this.println(NLS.bind(ConsoleMsg.CONSOLE_RESOURCE_NOT_IN_BUNDLE, string, bundle.toString()));
            }
        }
    }

    private void check4More() {
        int n = this.getMaximumLinesToScroll();
        if (n > 0 && this.currentLineCount >= n) {
            this.out.print(ConsoleMsg.CONSOLE_MORE);
            this.out.flush();
            this.con.getInput();
            this.resetLineCount();
        }
    }

    public String getHelp(String string) {
        boolean bl = string == null;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (bl) {
            stringBuffer.append(ConsoleMsg.CONSOLE_HELP_CONTROLLING_CONSOLE_HEADING);
            stringBuffer.append(this.newline);
        }
        if (bl || "more".equals(string)) {
            stringBuffer.append(this.tab);
            stringBuffer.append("more - ");
            stringBuffer.append(ConsoleMsg.CONSOLE_HELP_MORE);
            stringBuffer.append(this.newline);
        }
        if (bl || "disconnect".equals(string)) {
            stringBuffer.append(this.tab);
            stringBuffer.append("disconnect - ");
            stringBuffer.append(ConsoleMsg.CONSOLE_HELP_DISCONNECT);
            stringBuffer.append(this.newline);
        }
        if (bl || "help".equals(string)) {
            stringBuffer.append(this.tab);
            stringBuffer.append("help <commmand> - ");
            stringBuffer.append(ConsoleMsg.CONSOLE_HELP_HELP_COMMAND_DESCRIPTION);
            stringBuffer.append(this.newline);
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public void _more() throws Exception {
        if (this.confirm(ConsoleMsg.CONSOLE_CONFIRM_MORE, true)) {
            int n = this.prompt(new StringBuffer(String.valueOf(this.newline)).append(ConsoleMsg.CONSOLE_MORE_ENTER_LINES).toString(), 24);
            this.setMaximumLinesToScroll(n);
        } else {
            this.setMaximumLinesToScroll(0);
        }
    }

    private void _disconnect() throws Exception {
        if (this.confirm(ConsoleMsg.CONSOLE_CONFIRM_DISCONNECT, true)) {
            this.con.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean confirm(String string, boolean bl) {
        Object object = this.out;
        synchronized (object) {
            if (string.length() > 0) {
                this.print(string);
            } else {
                this.print(ConsoleMsg.CONSOLE_CONFIRM);
            }
            this.print(new StringBuffer(" (").append(ConsoleMsg.CONSOLE_CONFIRM_VALUES).toString());
            if (bl) {
                this.print(new StringBuffer(String.valueOf(ConsoleMsg.CONSOLE_Y)).append(") ").toString());
            } else {
                this.print(new StringBuffer(String.valueOf(ConsoleMsg.CONSOLE_N)).append(") ").toString());
            }
        }
        object = this.con.getInput();
        this.resetLineCount();
        if (((String)object).length() == 0) {
            return bl;
        }
        return ((String)object).toLowerCase().charAt(0) == ConsoleMsg.CONSOLE_Y.charAt(0);
    }

    protected String prompt(String string, String string2) {
        CharSequence charSequence;
        if (string.length() > 0) {
            if (string2.length() > 0) {
                charSequence = new StringBuffer(256);
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append(" ");
                ((StringBuffer)charSequence).append(ConsoleMsg.CONSOLE_PROMPT_DEFAULT);
                ((StringBuffer)charSequence).append("=");
                ((StringBuffer)charSequence).append(string2);
                ((StringBuffer)charSequence).append(") ");
                this.print(((StringBuffer)charSequence).toString());
            } else {
                this.print(string);
            }
        }
        charSequence = this.con.getInput();
        this.resetLineCount();
        if (((String)charSequence).length() > 0) {
            return charSequence;
        }
        return string2;
    }

    protected int prompt(String string, int n) {
        Integer n2 = new Integer(n);
        int n3 = 0;
        while (n3 < 3) {
            String string2 = this.prompt(string, n2.toString());
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 >= 0) {
                    return n4;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            this.println(ConsoleMsg.CONSOLE_INVALID_INPUT);
            ++n3;
        }
        this.println(ConsoleMsg.CONSOLE_TOO_MUCH_INVALID_INPUT);
        return n;
    }
}

