/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterImpl
implements Filter {
    private final int op;
    private static final int EQUAL = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final int PRESENT = 5;
    private static final int SUBSTRING = 6;
    private static final int AND = 7;
    private static final int OR = 8;
    private static final int NOT = 9;
    private final String attr;
    private final Object value;
    private volatile transient String filterString;
    private static final Class<?>[] constructorType;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        constructorType = classArray;
    }

    public static FilterImpl newInstance(String string) throws InvalidSyntaxException {
        return new Parser(string).parse();
    }

    @Override
    public boolean match(ServiceReference<?> serviceReference) {
        if (serviceReference instanceof ServiceReferenceImpl) {
            return this.matchCase(((ServiceReferenceImpl)serviceReference).getRegistration().getProperties());
        }
        return this.matchCase(new ServiceReferenceDictionary(serviceReference));
    }

    @Override
    public boolean match(Dictionary<String, ?> dictionary) {
        if (dictionary != null) {
            dictionary = new Headers(dictionary);
        }
        return this.matchCase(dictionary);
    }

    @Override
    public boolean matchCase(Dictionary<String, ?> dictionary) {
        switch (this.op) {
            case 7: {
                FilterImpl[] filterImplArray;
                FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterImpl filterImpl = filterImplArray2[n2];
                    if (!filterImpl.matchCase(dictionary)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filterImplArray;
                FilterImpl[] filterImplArray3 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FilterImpl filterImpl = filterImplArray3[n3];
                    if (filterImpl.matchCase(dictionary)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            case 9: {
                FilterImpl filterImpl = (FilterImpl)this.value;
                return !filterImpl.matchCase(dictionary);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object var2_5 = dictionary == null ? null : dictionary.get(this.attr);
                return this.compare(this.op, var2_5, this.value);
            }
            case 5: {
                Object var2_6;
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("PRESENT(").append(this.attr).append(")").toString());
                }
                Object v0 = var2_6 = dictionary == null ? null : dictionary.get(this.attr);
                return var2_6 != null;
            }
        }
        return false;
    }

    @Override
    public boolean matches(Map<String, ?> map) {
        switch (this.op) {
            case 7: {
                FilterImpl[] filterImplArray;
                FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterImpl filterImpl = filterImplArray2[n2];
                    if (!filterImpl.matches(map)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filterImplArray;
                FilterImpl[] filterImplArray3 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FilterImpl filterImpl = filterImplArray3[n3];
                    if (filterImpl.matches(map)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            case 9: {
                FilterImpl filterImpl = (FilterImpl)this.value;
                return !filterImpl.matches(map);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object var2_5 = map == null ? null : map.get(this.attr);
                return this.compare(this.op, var2_5, this.value);
            }
            case 5: {
                Object var2_6;
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("PRESENT(").append(this.attr).append(")").toString());
                }
                Object v0 = var2_6 = map == null ? null : map.get(this.attr);
                return var2_6 != null;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        String string = this.filterString;
        if (string == null) {
            this.filterString = string = this.normalize();
        }
        return string;
    }

    private String normalize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        switch (this.op) {
            case 7: {
                FilterImpl[] filterImplArray;
                stringBuffer.append('&');
                FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterImpl filterImpl = filterImplArray2[n2];
                    stringBuffer.append(filterImpl.normalize());
                    ++n2;
                }
                break;
            }
            case 8: {
                FilterImpl[] filterImplArray;
                stringBuffer.append('|');
                FilterImpl[] filterImplArray3 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FilterImpl filterImpl = filterImplArray3[n3];
                    stringBuffer.append(filterImpl.normalize());
                    ++n3;
                }
                break;
            }
            case 9: {
                stringBuffer.append('!');
                FilterImpl filterImpl = (FilterImpl)this.value;
                stringBuffer.append(filterImpl.normalize());
                break;
            }
            case 6: {
                String[] stringArray;
                stringBuffer.append(this.attr);
                stringBuffer.append('=');
                String[] stringArray2 = stringArray = (String[])this.value;
                int n = stringArray.length;
                int n4 = 0;
                while (n4 < n) {
                    String string = stringArray2[n4];
                    if (string == null) {
                        stringBuffer.append('*');
                    } else {
                        stringBuffer.append(FilterImpl.encodeValue(string));
                    }
                    ++n4;
                }
                break;
            }
            case 1: {
                stringBuffer.append(this.attr);
                stringBuffer.append('=');
                stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 3: {
                stringBuffer.append(this.attr);
                stringBuffer.append(">=");
                stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 4: {
                stringBuffer.append(this.attr);
                stringBuffer.append("<=");
                stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                break;
            }
            case 2: {
                stringBuffer.append(this.attr);
                stringBuffer.append("~=");
                stringBuffer.append(FilterImpl.encodeValue(FilterImpl.approxString((String)this.value)));
                break;
            }
            case 5: {
                stringBuffer.append(this.attr);
                stringBuffer.append("=*");
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Filter)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    FilterImpl(int n, String string, Object object) {
        this.op = n;
        this.attr = string;
        this.value = object;
    }

    private static String encodeValue(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = n << 1;
        char[] cArray = new char[n2];
        string.getChars(0, n, cArray, n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    cArray[n3] = 92;
                    ++n3;
                    bl = true;
                }
            }
            cArray[n3] = c;
            ++n3;
            ++n4;
        }
        return bl ? new String(cArray, 0, n3) : string;
    }

    private boolean compare(int n, Object object, Object object2) {
        if (object == null) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("compare(").append(object).append(",").append(object2).append(")").toString());
            }
            return false;
        }
        if (object instanceof String) {
            return this.compare_String(n, (String)object, object2);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return this.compare_PrimitiveArray(n, clazz2, object, object2);
            }
            return this.compare_ObjectArray(n, (Object[])object, object2);
        }
        if (object instanceof Collection) {
            return this.compare_Collection(n, (Collection)object, object2);
        }
        if (object instanceof Integer) {
            return this.compare_Integer(n, (Integer)object, object2);
        }
        if (object instanceof Long) {
            return this.compare_Long(n, (Long)object, object2);
        }
        if (object instanceof Byte) {
            return this.compare_Byte(n, (Byte)object, object2);
        }
        if (object instanceof Short) {
            return this.compare_Short(n, (Short)object, object2);
        }
        if (object instanceof Character) {
            return this.compare_Character(n, ((Character)object).charValue(), object2);
        }
        if (object instanceof Float) {
            return this.compare_Float(n, ((Float)object).floatValue(), object2);
        }
        if (object instanceof Double) {
            return this.compare_Double(n, (Double)object, object2);
        }
        if (object instanceof Boolean) {
            return this.compare_Boolean(n, (Boolean)object, object2);
        }
        if (object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            return this.compare_Comparable(n, comparable, object2);
        }
        return this.compare_Unknown(n, object, object2);
    }

    private boolean compare_Collection(int n, Collection<?> collection, Object object) {
        for (Object obj : collection) {
            if (!this.compare(n, obj, object)) continue;
            return true;
        }
        return false;
    }

    private boolean compare_ObjectArray(int n, Object[] objectArray, Object object) {
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object2 = objectArray2[n3];
            if (this.compare(n, object2, object)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean compare_PrimitiveArray(int n, Class<?> clazz, Object object, Object object2) {
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            int[] nArray;
            int[] nArray2 = nArray = (int[])object;
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray2[n3];
                if (this.compare_Integer(n, n4, object2)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            long[] lArray;
            long[] lArray2 = lArray = (long[])object;
            int n5 = lArray.length;
            int n6 = 0;
            while (n6 < n5) {
                long l = lArray2[n6];
                if (this.compare_Long(n, l, object2)) {
                    return true;
                }
                ++n6;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            byte[] byArray;
            byte[] byArray2 = byArray = (byte[])object;
            int n7 = byArray.length;
            int n8 = 0;
            while (n8 < n7) {
                byte by = byArray2[n8];
                if (this.compare_Byte(n, by, object2)) {
                    return true;
                }
                ++n8;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            short[] sArray;
            short[] sArray2 = sArray = (short[])object;
            int n9 = sArray.length;
            int n10 = 0;
            while (n10 < n9) {
                short s = sArray2[n10];
                if (this.compare_Short(n, s, object2)) {
                    return true;
                }
                ++n10;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            char[] cArray;
            char[] cArray2 = cArray = (char[])object;
            int n11 = cArray.length;
            int n12 = 0;
            while (n12 < n11) {
                char c = cArray2[n12];
                if (this.compare_Character(n, c, object2)) {
                    return true;
                }
                ++n12;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            float[] fArray;
            float[] fArray2 = fArray = (float[])object;
            int n13 = fArray.length;
            int n14 = 0;
            while (n14 < n13) {
                float f = fArray2[n14];
                if (this.compare_Float(n, f, object2)) {
                    return true;
                }
                ++n14;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            double[] dArray;
            double[] dArray2 = dArray = (double[])object;
            int n15 = dArray.length;
            int n16 = 0;
            while (n16 < n15) {
                double d = dArray2[n16];
                if (this.compare_Double(n, d, object2)) {
                    return true;
                }
                ++n16;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            boolean[] blArray;
            boolean[] blArray2 = blArray = (boolean[])object;
            int n17 = blArray.length;
            int n18 = 0;
            while (n18 < n17) {
                boolean bl = blArray2[n18];
                if (this.compare_Boolean(n, bl, object2)) {
                    return true;
                }
                ++n18;
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compare_String(int n, String string, Object object) {
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("SUBSTRING(").append(string).append(",").append(object).append(")").toString());
                }
                String[] stringArray = (String[])object;
                int n2 = 0;
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    String string2 = stringArray[n3];
                    if (n3 + 1 < n4) {
                        if (string2 == null) {
                            String string3 = stringArray[n3 + 1];
                            if (string3 != null) {
                                int n5;
                                if (Debug.DEBUG_FILTER) {
                                    Debug.println(new StringBuffer("indexOf(\"").append(string3).append("\",").append(n2).append(")").toString());
                                }
                                if ((n5 = string.indexOf(string3, n2)) == -1) {
                                    return false;
                                }
                                n2 = n5 + string3.length();
                                if (n3 + 2 < n4) {
                                    ++n3;
                                }
                            }
                        } else {
                            int n6 = string2.length();
                            if (Debug.DEBUG_FILTER) {
                                Debug.println(new StringBuffer("regionMatches(").append(n2).append(",\"").append(string2).append("\")").toString());
                            }
                            if (!string.regionMatches(n2, string2, 0, n6)) return false;
                            n2 += n6;
                        }
                    } else {
                        if (string2 == null) {
                            return true;
                        }
                        if (!Debug.DEBUG_FILTER) return string.endsWith(string2);
                        Debug.println(new StringBuffer("regionMatches(").append(n2).append(",").append(string2).append(")").toString());
                        return string.endsWith(string2);
                    }
                    ++n3;
                }
                return true;
            }
            case 1: {
                if (!Debug.DEBUG_FILTER) return string.equals(object);
                Debug.println(new StringBuffer("EQUAL(").append(string).append(",").append(object).append(")").toString());
                return string.equals(object);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(string).append(",").append(object).append(")").toString());
                }
                string = FilterImpl.approxString(string);
                String string4 = FilterImpl.approxString((String)object);
                return string.equalsIgnoreCase(string4);
            }
            case 3: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) >= 0;
                Debug.println(new StringBuffer("GREATER(").append(string).append(",").append(object).append(")").toString());
                return string.compareTo((String)object) >= 0;
            }
            case 4: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) <= 0;
                Debug.println(new StringBuffer("LESS(").append(string).append(",").append(object).append(")").toString());
                return string.compareTo((String)object) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Integer(int n, int n2, Object object) {
        int n3;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(n2).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            n3 = Integer.parseInt(((String)object).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(n2).append(",").append(object).append(")").toString());
                }
                return n2 == n3;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(n2).append(",").append(object).append(")").toString());
                }
                return n2 == n3;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(n2).append(",").append(object).append(")").toString());
                }
                return n2 >= n3;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(n2).append(",").append(object).append(")").toString());
                }
                return n2 <= n3;
            }
        }
        return false;
    }

    private boolean compare_Long(int n, long l, Object object) {
        long l2;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(l).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            l2 = Long.parseLong(((String)object).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(l).append(",").append(object).append(")").toString());
                }
                return l == l2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(l).append(",").append(object).append(")").toString());
                }
                return l == l2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(l).append(",").append(object).append(")").toString());
                }
                return l >= l2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(l).append(",").append(object).append(")").toString());
                }
                return l <= l2;
            }
        }
        return false;
    }

    private boolean compare_Byte(int n, byte by, Object object) {
        byte by2;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(by).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            by2 = Byte.parseByte(((String)object).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(by).append(",").append(object).append(")").toString());
                }
                return by == by2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(by).append(",").append(object).append(")").toString());
                }
                return by == by2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(by).append(",").append(object).append(")").toString());
                }
                return by >= by2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(by).append(",").append(object).append(")").toString());
                }
                return by <= by2;
            }
        }
        return false;
    }

    private boolean compare_Short(int n, short s, Object object) {
        short s2;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(s).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            s2 = Short.parseShort(((String)object).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(s).append(",").append(object).append(")").toString());
                }
                return s == s2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(s).append(",").append(object).append(")").toString());
                }
                return s == s2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(s).append(",").append(object).append(")").toString());
                }
                return s >= s2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(s).append(",").append(object).append(")").toString());
                }
                return s <= s2;
            }
        }
        return false;
    }

    private boolean compare_Character(int n, char c, Object object) {
        char c2;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(c).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            c2 = ((String)object).charAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(c).append(",").append(object).append(")").toString());
                }
                return c == c2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(c).append(",").append(object).append(")").toString());
                }
                return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(c).append(",").append(object).append(")").toString());
                }
                return c >= c2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(c).append(",").append(object).append(")").toString());
                }
                return c <= c2;
            }
        }
        return false;
    }

    private boolean compare_Boolean(int n, boolean bl, Object object) {
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(bl).append(",").append(object).append(")").toString());
            }
            return false;
        }
        boolean bl2 = Boolean.valueOf(((String)object).trim());
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(bl).append(",").append(object).append(")").toString());
                }
                return bl == bl2;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(bl).append(",").append(object).append(")").toString());
                }
                return bl == bl2;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(bl).append(",").append(object).append(")").toString());
                }
                return bl == bl2;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(bl).append(",").append(object).append(")").toString());
                }
                return bl == bl2;
            }
        }
        return false;
    }

    private boolean compare_Float(int n, float f, Object object) {
        float f2;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(f).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            f2 = Float.parseFloat(((String)object).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(f).append(",").append(object).append(")").toString());
                }
                return Float.compare(f, f2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(f).append(",").append(object).append(")").toString());
                }
                return Float.compare(f, f2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(f).append(",").append(object).append(")").toString());
                }
                return Float.compare(f, f2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(f).append(",").append(object).append(")").toString());
                }
                return Float.compare(f, f2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Double(int n, double d, Object object) {
        double d2;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(d).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            d2 = Double.parseDouble(((String)object).trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        switch (n) {
            case 1: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("EQUAL(").append(d).append(",").append(object).append(")").toString());
                }
                return Double.compare(d, d2) == 0;
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("APPROX(").append(d).append(",").append(object).append(")").toString());
                }
                return Double.compare(d, d2) == 0;
            }
            case 3: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("GREATER(").append(d).append(",").append(object).append(")").toString());
                }
                return Double.compare(d, d2) >= 0;
            }
            case 4: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println(new StringBuffer("LESS(").append(d).append(",").append(object).append(")").toString());
                }
                return Double.compare(d, d2) <= 0;
            }
        }
        return false;
    }

    private boolean compare_Comparable(int n, Comparable<Object> comparable, Object object) {
        Constructor<?> constructor;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(comparable).append(",").append(object).append(")").toString());
            }
            return false;
        }
        try {
            constructor = comparable.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            object = constructor.newInstance(((String)object).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        try {
            switch (n) {
                case 1: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("EQUAL(").append(comparable).append(",").append(object).append(")").toString());
                    }
                    return comparable.compareTo(object) == 0;
                }
                case 2: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("APPROX(").append(comparable).append(",").append(object).append(")").toString());
                    }
                    return comparable.compareTo(object) == 0;
                }
                case 3: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("GREATER(").append(comparable).append(",").append(object).append(")").toString());
                    }
                    return comparable.compareTo(object) >= 0;
                }
                case 4: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("LESS(").append(comparable).append(",").append(object).append(")").toString());
                    }
                    return comparable.compareTo(object) <= 0;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private boolean compare_Unknown(int n, Object object, Object object2) {
        Constructor<?> constructor;
        if (n == 6) {
            if (Debug.DEBUG_FILTER) {
                Debug.println(new StringBuffer("SUBSTRING(").append(object).append(",").append(object2).append(")").toString());
            }
            return false;
        }
        try {
            constructor = object.getClass().getConstructor(constructorType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("Type not supported");
            }
            return false;
        }
        try {
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            object2 = constructor.newInstance(((String)object2).trim());
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
        try {
            switch (n) {
                case 1: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("EQUAL(").append(object).append(",").append(object2).append(")").toString());
                    }
                    return object.equals(object2);
                }
                case 2: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("APPROX(").append(object).append(",").append(object2).append(")").toString());
                    }
                    return object.equals(object2);
                }
                case 3: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("GREATER(").append(object).append(",").append(object2).append(")").toString());
                    }
                    return object.equals(object2);
                }
                case 4: {
                    if (Debug.DEBUG_FILTER) {
                        Debug.println(new StringBuffer("LESS(").append(object).append(",").append(object2).append(")").toString());
                    }
                    return object.equals(object2);
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static String approxString(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        char[] cArray2 = cArray;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray2[n3];
            if (Character.isWhitespace(c)) {
                bl = true;
            } else {
                cArray[n] = c;
                ++n;
            }
            ++n3;
        }
        return bl ? new String(cArray, 0, n) : string;
    }

    public String getRequiredObjectClass() {
        return this.getPrimaryKeyValue("objectClass");
    }

    public String getPrimaryKeyValue(String string) {
        switch (this.op) {
            case 1: {
                if (!this.attr.equalsIgnoreCase(string) || !(this.value instanceof String)) break;
                return (String)this.value;
            }
            case 7: {
                FilterImpl[] filterImplArray;
                FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2;
                    FilterImpl filterImpl = filterImplArray2[n2];
                    if (filterImpl.op == 1 && (string2 = filterImpl.getPrimaryKeyValue(string)) != null) {
                        return string2;
                    }
                    ++n2;
                }
                break;
            }
        }
        return null;
    }

    public String[] getAttributes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getAttributesInternal(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void getAttributesInternal(List<String> list) {
        if (this.value instanceof FilterImpl[]) {
            FilterImpl[] filterImplArray;
            FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
            int n = filterImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl filterImpl = filterImplArray2[n2];
                filterImpl.getAttributesInternal(list);
                ++n2;
            }
            return;
        }
        if (this.value instanceof FilterImpl) {
            FilterImpl filterImpl = (FilterImpl)this.value;
            filterImpl.getAttributesInternal(list);
            return;
        }
        if (this.attr != null) {
            list.add(this.attr);
        }
    }

    private static class Parser {
        private final String filterstring;
        private final char[] filterChars;
        private int pos;

        Parser(String string) {
            this.filterstring = string;
            this.filterChars = string.toCharArray();
            this.pos = 0;
        }

        FilterImpl parse() throws InvalidSyntaxException {
            FilterImpl filterImpl;
            try {
                filterImpl = this.parse_filter();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring);
            }
            if (this.pos != this.filterChars.length) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return filterImpl;
        }

        private FilterImpl parse_filter() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            FilterImpl filterImpl = this.parse_filtercomp();
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != ')') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
            return filterImpl;
        }

        private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filterChars[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    return this.parse_and();
                }
                case '|': {
                    ++this.pos;
                    return this.parse_or();
                }
                case '!': {
                    ++this.pos;
                    return this.parse_not();
                }
            }
            return this.parse_item();
        }

        private FilterImpl parse_and() throws InvalidSyntaxException {
            int n = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = n - 1;
                return this.parse_item();
            }
            ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl filterImpl = this.parse_filter();
                arrayList.add(filterImpl);
            }
            return new FilterImpl(7, null, arrayList.toArray(new FilterImpl[arrayList.size()]));
        }

        private FilterImpl parse_or() throws InvalidSyntaxException {
            int n = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = n - 1;
                return this.parse_item();
            }
            ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl filterImpl = this.parse_filter();
                arrayList.add(filterImpl);
            }
            return new FilterImpl(8, null, arrayList.toArray(new FilterImpl[arrayList.size()]));
        }

        private FilterImpl parse_not() throws InvalidSyntaxException {
            int n = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = n - 1;
                return this.parse_item();
            }
            FilterImpl filterImpl = this.parse_filter();
            return new FilterImpl(9, null, filterImpl);
        }

        private FilterImpl parse_item() throws InvalidSyntaxException {
            String string = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filterChars[this.pos]) {
                case '~': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(2, string, this.parse_value());
                }
                case '>': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(3, string, this.parse_value());
                }
                case '<': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterImpl(4, string, this.parse_value());
                }
                case '=': {
                    if (this.filterChars[this.pos + 1] == '*') {
                        int n = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filterChars[this.pos] == ')') {
                            return new FilterImpl(5, string, null);
                        }
                        this.pos = n;
                    }
                    ++this.pos;
                    Object object = this.parse_substring();
                    if (object instanceof String) {
                        return new FilterImpl(1, string, object);
                    }
                    return new FilterImpl(6, string, object);
                }
            }
            throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, this.filterstring.substring(this.pos)), this.filterstring);
        }

        private String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int n = this.pos;
            int n2 = this.pos;
            char c = this.filterChars[this.pos];
            while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    n2 = this.pos;
                }
                c = this.filterChars[this.pos];
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return new String(this.filterChars, n, n3);
        }

        private String parse_value() throws InvalidSyntaxException {
            StringBuffer stringBuffer = new StringBuffer(this.filterChars.length - this.pos);
            block5: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                    }
                    default: {
                        stringBuffer.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (stringBuffer.length() == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return stringBuffer.toString();
        }

        private Object parse_substring() throws InvalidSyntaxException {
            Object e;
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.filterChars.length - this.pos);
            ArrayList<String> arrayList = new ArrayList<String>(10);
            block6: while (true) {
                n = this.filterChars[this.pos];
                switch (n) {
                    case 41: {
                        if (stringBuffer.length() <= 0) break block6;
                        arrayList.add(stringBuffer.toString());
                        break block6;
                    }
                    case 40: {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case 42: {
                        if (stringBuffer.length() > 0) {
                            arrayList.add(stringBuffer.toString());
                        }
                        stringBuffer.setLength(0);
                        arrayList.add(null);
                        ++this.pos;
                        continue block6;
                    }
                    case 92: {
                        ++this.pos;
                        n = this.filterChars[this.pos];
                    }
                    default: {
                        stringBuffer.append((char)n);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            if ((n = arrayList.size()) == 0) {
                return "";
            }
            if (n == 1 && (e = arrayList.get(0)) != null) {
                return e;
            }
            return arrayList.toArray(new String[n]);
        }

        private void skipWhiteSpace() {
            int n = this.filterChars.length;
            while (this.pos < n && Character.isWhitespace(this.filterChars[this.pos])) {
                ++this.pos;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceReferenceDictionary
    extends Dictionary<String, Object> {
        private final ServiceReference<?> reference;

        ServiceReferenceDictionary(ServiceReference<?> serviceReference) {
            this.reference = serviceReference;
        }

        @Override
        public Object get(Object object) {
            if (this.reference == null) {
                return null;
            }
            return this.reference.getProperty((String)object);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<String> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<Object> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetAccessibleAction
    implements PrivilegedAction<Object> {
        private final AccessibleObject accessible;

        SetAccessibleAction(AccessibleObject accessibleObject) {
            this.accessible = accessibleObject;
        }

        @Override
        public Object run() {
            this.accessible.setAccessible(true);
            return null;
        }
    }
}

