/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.service.resolver.ResolverHookException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreResolverHookFactory
implements ResolverHookFactory {
    private final BundleContextImpl context;
    private final ServiceRegistry registry;
    static /* synthetic */ Class class$0;

    public CoreResolverHookFactory(BundleContextImpl bundleContextImpl, ServiceRegistry serviceRegistry) {
        this.context = bundleContextImpl;
        this.registry = serviceRegistry;
    }

    void handleHookException(Throwable throwable, Object object, String string, Bundle bundle, List<HookReference> list, boolean bl) {
        if (Debug.DEBUG_HOOKS) {
            Debug.println(new StringBuffer(String.valueOf(object.getClass().getName())).append(".").append(string).append("() exception:").toString());
            if (throwable != null) {
                Debug.printStackTrace(throwable);
            }
        }
        String string2 = NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, object.getClass().getName(), string);
        if (bl) {
            this.releaseHooks(list);
            throw new ResolverHookException(string2, throwable);
        }
        BundleException bundleException = new BundleException(string2, 12, throwable);
        this.context.framework.publishFrameworkEvent(2, bundle, bundleException);
    }

    private ServiceReferenceImpl<ResolverHookFactory>[] getHookReferences() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.framework.hooks.resolver.ResolverHookFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ServiceReferenceImpl<?>[] serviceReferenceImplArray = this.registry.getServiceReferences(this.context, clazz.getName(), null, false, false);
            return serviceReferenceImplArray;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    @Override
    public ResolverHook begin(Collection<BundleRevision> collection) {
        ServiceReferenceImpl<ResolverHookFactory>[] serviceReferenceImplArray;
        List list;
        if (Debug.DEBUG_HOOKS) {
            Debug.println("ResolverHook.begin");
        }
        List list2 = list = (serviceReferenceImplArray = this.getHookReferences()) == null ? Collections.EMPTY_LIST : new ArrayList(serviceReferenceImplArray.length);
        if (serviceReferenceImplArray != null) {
            ServiceReferenceImpl<ResolverHookFactory>[] serviceReferenceImplArray2 = serviceReferenceImplArray;
            int n = serviceReferenceImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReferenceImpl<ResolverHookFactory> serviceReferenceImpl = serviceReferenceImplArray2[n2];
                ResolverHookFactory resolverHookFactory = this.context.getService(serviceReferenceImpl);
                if (resolverHookFactory != null) {
                    try {
                        ResolverHook resolverHook = resolverHookFactory.begin(collection);
                        if (resolverHook != null) {
                            list.add(new HookReference(serviceReferenceImpl, resolverHook));
                        }
                    }
                    catch (Throwable throwable) {
                        this.handleHookException(throwable, resolverHookFactory, "begin", serviceReferenceImpl.getBundle(), list, true);
                    }
                }
                ++n2;
            }
        }
        return new CoreResolverHook(list);
    }

    void releaseHooks(List<HookReference> list) {
        for (HookReference hookReference : list) {
            this.context.ungetService(hookReference.reference);
        }
        list.clear();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CoreResolverHook
    implements ResolverHook {
        private final List<HookReference> hooks;

        CoreResolverHook(List<HookReference> list) {
            this.hooks = list;
        }

        @Override
        public void filterResolvable(Collection<BundleRevision> collection) {
            if (Debug.DEBUG_HOOKS) {
                Debug.println(new StringBuffer("ResolverHook.filterResolvable(").append(collection).append(")").toString());
            }
            if (this.hooks.isEmpty()) {
                return;
            }
            collection = new ShrinkableCollection<BundleRevision>(collection);
            for (HookReference hookReference : this.hooks) {
                if (hookReference.reference.getBundle() == null) {
                    CoreResolverHookFactory.this.handleHookException(null, hookReference.hook, "filterResolvable", hookReference.reference.getBundle(), this.hooks, true);
                    continue;
                }
                try {
                    hookReference.hook.filterResolvable(collection);
                }
                catch (Throwable throwable) {
                    CoreResolverHookFactory.this.handleHookException(throwable, hookReference.hook, "filterResolvable", hookReference.reference.getBundle(), this.hooks, true);
                }
            }
        }

        @Override
        public void filterSingletonCollisions(BundleCapability bundleCapability, Collection<BundleCapability> collection) {
            if (Debug.DEBUG_HOOKS) {
                Debug.println(new StringBuffer("ResolverHook.filterSingletonCollisions(").append(bundleCapability).append(", ").append(collection).append(")").toString());
            }
            if (this.hooks.isEmpty()) {
                return;
            }
            collection = new ShrinkableCollection<BundleCapability>(collection);
            for (HookReference hookReference : this.hooks) {
                if (hookReference.reference.getBundle() == null) {
                    CoreResolverHookFactory.this.handleHookException(null, hookReference.hook, "filterSingletonCollisions", hookReference.reference.getBundle(), this.hooks, true);
                    continue;
                }
                try {
                    hookReference.hook.filterSingletonCollisions(bundleCapability, collection);
                }
                catch (Throwable throwable) {
                    CoreResolverHookFactory.this.handleHookException(throwable, hookReference.hook, "filterSingletonCollisions", hookReference.reference.getBundle(), this.hooks, true);
                }
            }
        }

        @Override
        public void filterMatches(BundleRequirement bundleRequirement, Collection<BundleCapability> collection) {
            if (Debug.DEBUG_HOOKS) {
                Debug.println(new StringBuffer("ResolverHook.filterMatches(").append(bundleRequirement).append(", ").append(collection).append(")").toString());
            }
            if (this.hooks.isEmpty()) {
                return;
            }
            collection = new ShrinkableCollection<BundleCapability>(collection);
            for (HookReference hookReference : this.hooks) {
                if (hookReference.reference.getBundle() == null) {
                    CoreResolverHookFactory.this.handleHookException(null, hookReference.hook, "filterMatches", hookReference.reference.getBundle(), this.hooks, true);
                    continue;
                }
                try {
                    hookReference.hook.filterMatches(bundleRequirement, collection);
                }
                catch (Throwable throwable) {
                    CoreResolverHookFactory.this.handleHookException(throwable, hookReference.hook, "filterMatches", hookReference.reference.getBundle(), this.hooks, true);
                }
            }
        }

        @Override
        public void end() {
            if (Debug.DEBUG_HOOKS) {
                Debug.println("ResolverHook.end");
            }
            if (this.hooks.isEmpty()) {
                return;
            }
            for (HookReference hookReference : this.hooks) {
                if (hookReference.reference.getBundle() == null) continue;
                try {
                    hookReference.hook.end();
                }
                catch (Throwable throwable) {
                    CoreResolverHookFactory.this.handleHookException(throwable, hookReference.hook, "end", hookReference.reference.getBundle(), this.hooks, false);
                }
            }
            CoreResolverHookFactory.this.releaseHooks(this.hooks);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HookReference {
        final ServiceReferenceImpl<ResolverHookFactory> reference;
        final ResolverHook hook;

        public HookReference(ServiceReferenceImpl<ResolverHookFactory> serviceReferenceImpl, ResolverHook resolverHook) {
            this.reference = serviceReferenceImpl;
            this.hook = resolverHook;
        }
    }
}

