/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.EclipseDebugTrace;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkDebugOptions
implements DebugOptions,
ServiceTrackerCustomizer<DebugOptionsListener, DebugOptionsListener> {
    private static final String OSGI_DEBUG = "osgi.debug";
    private static final String OSGI_DEBUG_VERBOSE = "osgi.debug.verbose";
    public static final String PROP_TRACEFILE = "osgi.tracefile";
    private final Object lock = new Object();
    private Properties options = null;
    private Properties disabledOptions = null;
    private static FrameworkDebugOptions singleton = null;
    private static final String OPTIONS = ".options";
    protected static final Map<String, DebugTrace> debugTraceCache = new HashMap<String, DebugTrace>();
    protected File outFile = null;
    protected boolean verboseDebug = Boolean.valueOf(FrameworkProperties.getProperty("osgi.debug.verbose", Boolean.TRUE.toString()));
    private volatile BundleContext context;
    private volatile ServiceTracker<DebugOptionsListener, DebugOptionsListener> listenerTracker;
    static /* synthetic */ Class class$0;

    private FrameworkDebugOptions() {
        URL uRL;
        Object object2;
        String string = FrameworkProperties.getProperty(OSGI_DEBUG);
        if (string == null) {
            return;
        }
        this.options = new Properties();
        if (string.length() == 0) {
            object2 = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!((String)object2).endsWith("/")) {
                object2 = new StringBuffer(String.valueOf(object2)).append("/").toString();
            }
            string = new File((String)object2, OPTIONS).toString();
        }
        if ((uRL = FrameworkDebugOptions.buildURL(string, false)) == null) {
            System.out.println(new StringBuffer("Unable to construct URL for options file: ").append(string).toString());
            return;
        }
        System.out.print(new StringBuffer("Debug options:\n    ").append(uRL.toExternalForm()).toString());
        try {
            object2 = uRL.openStream();
            try {
                this.options.load((InputStream)object2);
                System.out.println(" loaded");
            }
            finally {
                ((InputStream)object2).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException iOException) {
            System.out.println(" did not parse");
            iOException.printStackTrace(System.out);
        }
        for (Object object2 : this.options.keySet()) {
            this.options.put(object2, ((String)this.options.get(object2)).trim());
        }
    }

    public void start(BundleContext bundleContext) {
        this.context = bundleContext;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker<DebugOptionsListener, DebugOptionsListener>(bundleContext, clazz.getName(), this);
        this.listenerTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this.listenerTracker.close();
        this.listenerTracker = null;
        this.context = null;
    }

    public static FrameworkDebugOptions getDefault() {
        if (singleton == null) {
            singleton = new FrameworkDebugOptions();
        }
        return singleton;
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith("file:");
        try {
            if (bl2) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string.substring(5)).toURL(), bl);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string).toURL(), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        String string = uRL.getFile();
        if (bl == string.endsWith("/")) {
            return uRL;
        }
        string = bl ? new StringBuffer(String.valueOf(string)).append("/").toString() : string.substring(0, string.length() - 1);
        return new URL(uRL.getProtocol(), uRL.getHost(), string);
    }

    @Override
    public boolean getBooleanOption(String string, boolean bl) {
        String string2 = this.getOption(string);
        return string2 != null ? string2.equalsIgnoreCase("true") : bl;
    }

    @Override
    public String getOption(String string) {
        return this.getOption(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOption(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                return this.options.getProperty(string, string2);
            }
        }
        return string2;
    }

    @Override
    public int getIntegerOption(String string, int n) {
        String string2 = this.getOption(string);
        try {
            return string2 == null ? n : Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                hashMap.putAll(this.options);
            } else if (this.disabledOptions != null) {
                hashMap.putAll(this.disabledOptions);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAllOptions() {
        String[] stringArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                stringArray = new String[this.options.size()];
                Iterator<Map.Entry<Object, Object>> iterator = this.options.entrySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    stringArray[n] = new StringBuffer(String.valueOf((String)entry.getKey())).append("=").append((String)entry.getValue()).toString();
                    ++n;
                }
            }
        }
        if (stringArray == null) {
            stringArray = new String[1];
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOption(String string) {
        if (string == null) {
            return;
        }
        String string2 = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null && this.options.remove(string) != null) {
                string2 = this.getSymbolicName(string);
            }
        }
        if (string2 != null) {
            this.optionsChanged(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("The option and value must not be null.");
        }
        String string3 = null;
        string2 = string2 != null ? string2.trim() : null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                String string4 = this.options.getProperty(string);
                if (string4 != null) {
                    if (!string4.equals(string2)) {
                        string3 = this.getSymbolicName(string);
                    }
                } else if (string2 != null) {
                    string3 = this.getSymbolicName(string);
                }
                if (string3 != null) {
                    this.options.put(string, string2);
                }
            }
        }
        if (string3 != null) {
            this.optionsChanged(string3);
        }
    }

    private String getSymbolicName(String string) {
        int n = string.indexOf("/");
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOptions(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("The options must not be null.");
        }
        Properties properties = new Properties();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            if (!(object2.getKey() instanceof String) || !(object2.getValue() instanceof String)) {
                throw new IllegalArgumentException(new StringBuffer("Option keys and values must be of type String: ").append(object2.getKey()).append("=").append(object2.getValue()).toString());
            }
            properties.put(object2.getKey(), object2.getValue().trim());
        }
        Object object3 = null;
        Object object = this.lock;
        synchronized (object) {
            String string;
            if (this.options == null) {
                this.disabledOptions = properties;
                return;
            }
            object3 = new HashSet();
            for (String string2 : this.options.keySet()) {
                if (properties.containsKey(string2) || (string = this.getSymbolicName(string2)) == null) continue;
                object3.add(string);
            }
            for (Map.Entry entry : properties.entrySet()) {
                String string3;
                string = (String)this.options.get(entry.getKey());
                if (entry.getValue().equals(string) || (string3 = this.getSymbolicName((String)entry.getKey())) == null) continue;
                object3.add(string3);
            }
            this.options = properties;
        }
        if (object3 != null) {
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                this.optionsChanged((String)iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDebugEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.options != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugEnabled(boolean bl) {
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                if (this.options != null) {
                    return;
                }
                EclipseDebugTrace.newSession = true;
                FrameworkProperties.setProperty(OSGI_DEBUG, "");
                if (this.disabledOptions != null) {
                    this.options = this.disabledOptions;
                    this.disabledOptions = null;
                    bl2 = true;
                } else {
                    this.options = new Properties();
                }
            } else {
                if (this.options == null) {
                    return;
                }
                FrameworkProperties.clearProperty(OSGI_DEBUG);
                if (this.options.size() > 0) {
                    this.disabledOptions = this.options;
                    bl2 = true;
                }
                this.options = null;
            }
        }
        if (bl2) {
            this.optionsChanged("*");
        }
    }

    @Override
    public final DebugTrace newDebugTrace(String string) {
        return this.newDebugTrace(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DebugTrace newDebugTrace(String string, Class<?> clazz) {
        DebugTrace debugTrace = null;
        Map<String, DebugTrace> map = debugTraceCache;
        synchronized (map) {
            debugTrace = debugTraceCache.get(string);
            if (debugTrace == null) {
                debugTrace = new EclipseDebugTrace(string, singleton, clazz);
                debugTraceCache.put(string, debugTrace);
            }
        }
        return debugTrace;
    }

    @Override
    public final File getFile() {
        return this.outFile;
    }

    @Override
    public synchronized void setFile(File file) {
        this.outFile = file;
        FrameworkProperties.setProperty(PROP_TRACEFILE, this.outFile.getAbsolutePath());
        EclipseDebugTrace.newSession = true;
    }

    boolean isVerbose() {
        return this.verboseDebug;
    }

    public synchronized void setVerbose(boolean bl) {
        this.verboseDebug = bl;
        EclipseDebugTrace.newSession = true;
    }

    private void optionsChanged(String string) {
        BundleContext bundleContext = this.context;
        if (bundleContext == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            serviceReferenceArray = bundleContext.getServiceReferences(clazz.getName(), new StringBuffer("(listener.symbolic.name=").append(string).append(")").toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (serviceReferenceArray == null) {
            return;
        }
        int n = 0;
        while (n < serviceReferenceArray.length) {
            block15: {
                DebugOptionsListener debugOptionsListener = (DebugOptionsListener)bundleContext.getService(serviceReferenceArray[n]);
                if (debugOptionsListener != null) {
                    try {
                        try {
                            debugOptionsListener.optionsChanged(this);
                        }
                        catch (Throwable throwable) {
                            bundleContext.ungetService(serviceReferenceArray[n]);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        bundleContext.ungetService(serviceReferenceArray[n]);
                        throw throwable;
                    }
                    bundleContext.ungetService(serviceReferenceArray[n]);
                }
            }
            ++n;
        }
    }

    @Override
    public DebugOptionsListener addingService(ServiceReference<DebugOptionsListener> serviceReference) {
        DebugOptionsListener debugOptionsListener = this.context.getService(serviceReference);
        debugOptionsListener.optionsChanged(this);
        return debugOptionsListener;
    }

    @Override
    public void modifiedService(ServiceReference<DebugOptionsListener> serviceReference, DebugOptionsListener debugOptionsListener) {
    }

    @Override
    public void removedService(ServiceReference<DebugOptionsListener> serviceReference, DebugOptionsListener debugOptionsListener) {
        this.context.ungetService(serviceReference);
    }
}

