/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.service.debug.DebugTrace;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EclipseDebugTrace
implements DebugTrace {
    private static final String PROP_TRACE_SIZE_MAX = "eclipse.trace.size.max";
    private static final String PROP_TRACE_FILE_MAX = "eclipse.trace.backup.max";
    private static final String MESSAGE_THREAD_DUMP = "Thread Stack dump: ";
    private static final String MESSAGE_EXIT_METHOD_WITH_RESULTS = "Exiting method {0}with result: ";
    private static final String MESSAGE_EXIT_METHOD_NO_RESULTS = "Exiting method {0}with a void return";
    private static final String MESSAGE_ENTER_METHOD_WITH_PARAMS = "Entering method {0}with parameters: (";
    private static final String MESSAGE_ENTER_METHOD_NO_PARAMS = "Entering method {0}with no parameters";
    private static final String TRACE_FILE_VERSION_COMMENT = "version: ";
    private static final String TRACE_FILE_VERBOSE_COMMENT = "verbose: ";
    private static final String TRACE_FILE_VERSION = "1.1";
    private static final String TRACE_NEW_SESSION = "!SESSION ";
    private static final String TRACE_FILE_DATE = "Time of creation: ";
    private static final SimpleDateFormat TRACE_FILE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String TRACE_COMMENT = "#";
    private static final String TRACE_ELEMENT_DELIMITER = "|";
    private static final String TRACE_ELEMENT_DELIMITER_ENCODED = "&#124;";
    private static final String LINE_SEPARATOR;
    private static final String NULL_VALUE = "<null>";
    private static final SecureAction secureAction;
    private static final Object writeLock;
    private static final int DEFAULT_TRACE_FILE_SIZE = 1000;
    private static final int DEFAULT_TRACE_FILES = 10;
    private static final int DEFAULT_TRACE_FILE_MIN_SIZE = 10;
    private static final String TRACE_FILE_EXTENSION = ".trace";
    private static final String BACKUP_MARK = ".bak_";
    private int maxTraceFileSize = 1000;
    private int maxTraceFiles = 10;
    private int backupTraceFileIndex = 0;
    private String traceClass = null;
    private String bundleSymbolicName = null;
    static boolean newSession;
    private FrameworkDebugOptions debugOptions = null;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
        secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
        writeLock = new Object();
        newSession = true;
    }

    EclipseDebugTrace(String string, FrameworkDebugOptions frameworkDebugOptions) {
        this(string, frameworkDebugOptions, null);
    }

    EclipseDebugTrace(String string, FrameworkDebugOptions frameworkDebugOptions, Class<?> clazz) {
        this.traceClass = clazz != null ? clazz.getName() : null;
        this.debugOptions = frameworkDebugOptions;
        this.bundleSymbolicName = string;
        this.readLogProperties();
    }

    private final boolean isDebuggingEnabled(String string) {
        if (string == null) {
            return true;
        }
        boolean bl = false;
        if (this.debugOptions.isDebugEnabled()) {
            String string2 = new StringBuffer(String.valueOf(this.bundleSymbolicName)).append(string).toString();
            bl = this.debugOptions.getBooleanOption(string2, false);
        }
        return bl;
    }

    @Override
    public void trace(String string, String string2) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, string2, this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    @Override
    public void trace(String string, String string2, Throwable throwable) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, string2, throwable, this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    @Override
    public void traceEntry(String string) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, null, this.traceClass);
            this.setMessage(frameworkDebugTraceEntry, MESSAGE_ENTER_METHOD_NO_PARAMS);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    @Override
    public void traceEntry(String string, Object object) {
        if (this.isDebuggingEnabled(string)) {
            this.traceEntry(string, new Object[]{object});
        }
    }

    @Override
    public void traceEntry(String string, Object[] objectArray) {
        if (this.isDebuggingEnabled(string)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_ENTER_METHOD_WITH_PARAMS);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null) {
                        stringBuffer.append(objectArray[n].toString());
                    } else {
                        stringBuffer.append(NULL_VALUE);
                    }
                    if (++n >= objectArray.length) continue;
                    stringBuffer.append(" ");
                }
                stringBuffer.append(")");
            }
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, null, this.traceClass);
            this.setMessage(frameworkDebugTraceEntry, stringBuffer.toString());
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    @Override
    public void traceExit(String string) {
        if (this.isDebuggingEnabled(string)) {
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, null, this.traceClass);
            this.setMessage(frameworkDebugTraceEntry, MESSAGE_EXIT_METHOD_NO_RESULTS);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    @Override
    public void traceExit(String string, Object object) {
        if (this.isDebuggingEnabled(string)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_EXIT_METHOD_WITH_RESULTS);
            if (object == null) {
                stringBuffer.append(NULL_VALUE);
            } else {
                stringBuffer.append(object.toString());
            }
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, null, this.traceClass);
            this.setMessage(frameworkDebugTraceEntry, stringBuffer.toString());
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    @Override
    public void traceDumpStack(String string) {
        if (this.isDebuggingEnabled(string)) {
            StringBuffer stringBuffer = new StringBuffer(MESSAGE_THREAD_DUMP);
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            int n = this.traceClass == null ? 1 : 2;
            int n2 = stackTraceElementArray.length - n;
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n2];
            int n3 = 0;
            while (n3 < n2) {
                stackTraceElementArray2[n3] = stackTraceElementArray[n];
                ++n3;
                ++n;
            }
            stringBuffer.append(this.convertStackTraceElementsToString(stackTraceElementArray2));
            FrameworkDebugTraceEntry frameworkDebugTraceEntry = new FrameworkDebugTraceEntry(this.bundleSymbolicName, string, stringBuffer.toString(), this.traceClass);
            this.writeRecord(frameworkDebugTraceEntry);
        }
    }

    private final void setMessage(FrameworkDebugTraceEntry frameworkDebugTraceEntry, String string) {
        CharSequence charSequence;
        String string2 = null;
        if (!this.debugOptions.isVerbose()) {
            charSequence = new StringBuffer(frameworkDebugTraceEntry.getClassName());
            ((StringBuffer)charSequence).append(TRACE_COMMENT);
            ((StringBuffer)charSequence).append(frameworkDebugTraceEntry.getMethodName());
            ((StringBuffer)charSequence).append(" ");
            string2 = ((StringBuffer)charSequence).toString();
        } else {
            string2 = "";
        }
        charSequence = MessageFormat.format(string, string2);
        frameworkDebugTraceEntry.setMessage((String)charSequence);
    }

    private final String convertStackTraceElementsToString(StackTraceElement[] stackTraceElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stackTraceElementArray != null) {
            stringBuffer.append("java.lang.Throwable: ");
            stringBuffer.append(LINE_SEPARATOR);
            int n = 0;
            while (n < stackTraceElementArray.length) {
                if (stackTraceElementArray[n] != null) {
                    stringBuffer.append("\tat ");
                    stringBuffer.append(stackTraceElementArray[n].toString());
                    stringBuffer.append(LINE_SEPARATOR);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecord(FrameworkDebugTraceEntry frameworkDebugTraceEntry) {
        if (frameworkDebugTraceEntry != null) {
            Object object = writeLock;
            synchronized (object) {
                block13: {
                    File file = this.debugOptions.getFile();
                    Writer writer = null;
                    try {
                        try {
                            this.checkTraceFileSize(file, frameworkDebugTraceEntry.getTimestamp());
                            writer = this.openWriter(file);
                            if (newSession) {
                                this.writeSession(writer, frameworkDebugTraceEntry.getTimestamp());
                                newSession = false;
                            }
                            this.writeMessage(writer, frameworkDebugTraceEntry);
                            writer.flush();
                        }
                        catch (Exception exception) {
                            System.err.println("An exception occurred while writing to the platform trace file: ");
                            exception.printStackTrace(System.err);
                            if (file != null) {
                                this.closeWriter(writer);
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        if (file != null) {
                            this.closeWriter(writer);
                        }
                        throw throwable;
                    }
                    if (file != null) {
                        this.closeWriter(writer);
                    }
                }
            }
        }
    }

    private void readLogProperties() {
        String string;
        String string2 = secureAction.getProperty(PROP_TRACE_SIZE_MAX);
        if (string2 != null) {
            this.maxTraceFileSize = Integer.parseInt(string2);
            if (this.maxTraceFileSize != 0 && this.maxTraceFileSize < 10) {
                this.maxTraceFileSize = 10;
            }
        }
        if ((string = secureAction.getProperty(PROP_TRACE_FILE_MAX)) != null) {
            this.maxTraceFiles = Integer.parseInt(string);
            if (this.maxTraceFiles < 1) {
                this.maxTraceFiles = 10;
            }
        }
    }

    private boolean checkTraceFileSize(File file, long l) {
        boolean bl = true;
        if (this.maxTraceFileSize > 0 && file != null && file.exists() && file.length() >> 10 > (long)this.maxTraceFileSize) {
            block13: {
                boolean bl2;
                String string = file.getAbsolutePath();
                String string2 = "";
                string2 = string.toLowerCase().endsWith(TRACE_FILE_EXTENSION) ? new StringBuffer(String.valueOf(string.substring(0, string.length() - TRACE_FILE_EXTENSION.length()))).append(BACKUP_MARK).append(this.backupTraceFileIndex).append(TRACE_FILE_EXTENSION).toString() : new StringBuffer(String.valueOf(string)).append(BACKUP_MARK).append(this.backupTraceFileIndex).toString();
                File file2 = new File(string2);
                if (file2.exists() && !file2.delete()) {
                    System.err.println(new StringBuffer("Error when trying to delete old trace file: ").append(file2.getName()).toString());
                    if (file2.renameTo(new File(new StringBuffer(String.valueOf(file2.getAbsolutePath())).append(System.currentTimeMillis()).toString()))) {
                        System.err.println(new StringBuffer("So we rename it to filename: ").append(file2.getName()).toString());
                    } else {
                        System.err.println("And we also cannot rename it!");
                        bl = false;
                    }
                }
                if (!(bl2 = file.renameTo(file2))) {
                    System.err.println("Error when trying to rename trace file to backup one.");
                    bl = false;
                }
                Writer writer = null;
                try {
                    try {
                        writer = this.openWriter(file);
                        this.writeComment(writer, new StringBuffer("This is a continuation of trace file ").append(file2.getAbsolutePath()).toString());
                        this.writeComment(writer, "version: 1.1");
                        this.writeComment(writer, new StringBuffer(TRACE_FILE_VERBOSE_COMMENT).append(this.debugOptions.isVerbose()).toString());
                        this.writeComment(writer, new StringBuffer(TRACE_FILE_DATE).append(this.getFormattedDate(l)).toString());
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        if (file != null) {
                            this.closeWriter(writer);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (file != null) {
                        this.closeWriter(writer);
                    }
                    throw throwable;
                }
                if (file != null) {
                    this.closeWriter(writer);
                }
            }
            ++this.backupTraceFileIndex;
            this.backupTraceFileIndex %= this.maxTraceFiles;
        }
        return bl;
    }

    private void writeComment(Writer writer, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(TRACE_COMMENT);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(LINE_SEPARATOR);
        writer.write(stringBuffer.toString());
    }

    private final String getFormattedDate(long l) {
        return TRACE_FILE_DATE_FORMATTER.format(new Date(l));
    }

    private final String getFormattedThrowable(Throwable throwable) {
        String string = null;
        if (throwable != null) {
            PrintStream printStream = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                printStream = new PrintStream(byteArrayOutputStream, false);
                throwable.printStackTrace(printStream);
                string = EclipseDebugTrace.encodeText(byteArrayOutputStream.toString());
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
        }
        return string;
    }

    private void writeSession(Writer writer, long l) throws IOException {
        this.writeComment(writer, new StringBuffer(TRACE_NEW_SESSION).append(this.getFormattedDate(l)).toString());
        this.writeComment(writer, "version: 1.1");
        this.writeComment(writer, new StringBuffer(TRACE_FILE_VERBOSE_COMMENT).append(this.debugOptions.isVerbose()).toString());
        this.writeComment(writer, "The following option strings are specified for this debug session:");
        String[] stringArray = FrameworkDebugOptions.getDefault().getAllOptions();
        int n = 0;
        while (n < stringArray.length) {
            this.writeComment(writer, new StringBuffer("\t").append(stringArray[n]).toString());
            ++n;
        }
    }

    private void writeMessage(Writer writer, FrameworkDebugTraceEntry frameworkDebugTraceEntry) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(EclipseDebugTrace.encodeText(frameworkDebugTraceEntry.getThreadName()));
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        stringBuffer.append(this.getFormattedDate(frameworkDebugTraceEntry.getTimestamp()));
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(" ");
        if (!this.debugOptions.isVerbose()) {
            stringBuffer.append(EclipseDebugTrace.encodeText(frameworkDebugTraceEntry.getMessage()));
        } else {
            stringBuffer.append(frameworkDebugTraceEntry.getBundleSymbolicName());
            stringBuffer.append(" ");
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(EclipseDebugTrace.encodeText(frameworkDebugTraceEntry.getOptionPath()));
            stringBuffer.append(" ");
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(frameworkDebugTraceEntry.getClassName());
            stringBuffer.append(" ");
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(frameworkDebugTraceEntry.getMethodName());
            stringBuffer.append(" ");
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(frameworkDebugTraceEntry.getLineNumber());
            stringBuffer.append(" ");
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(EclipseDebugTrace.encodeText(frameworkDebugTraceEntry.getMessage()));
        }
        if (frameworkDebugTraceEntry.getThrowable() != null) {
            stringBuffer.append(" ");
            stringBuffer.append(TRACE_ELEMENT_DELIMITER);
            stringBuffer.append(" ");
            stringBuffer.append(this.getFormattedThrowable(frameworkDebugTraceEntry.getThrowable()));
        }
        stringBuffer.append(" ");
        stringBuffer.append(TRACE_ELEMENT_DELIMITER);
        stringBuffer.append(LINE_SEPARATOR);
        if (writer != null && stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    private static String encodeText(String string) {
        if (string == null || string.indexOf(TRACE_ELEMENT_DELIMITER) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf(TRACE_ELEMENT_DELIMITER);
        while (n >= 0) {
            stringBuffer.replace(n, n + TRACE_ELEMENT_DELIMITER.length(), TRACE_ELEMENT_DELIMITER_ENCODED);
            n = stringBuffer.indexOf(TRACE_ELEMENT_DELIMITER);
        }
        return stringBuffer.toString();
    }

    private Writer logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    private Writer openWriter(File file) {
        Writer writer = null;
        if (file != null) {
            try {
                writer = this.logForStream(secureAction.getFileOutputStream(file, true));
            }
            catch (IOException iOException) {
                writer = this.logForStream(System.out);
            }
        } else {
            writer = this.logForStream(System.out);
        }
        return writer;
    }

    private void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            writer = null;
        }
    }
}

