/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.FragmentClasspath;
import org.eclipse.osgi.baseadaptor.loader.ParallelClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.ArrayMap;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathManager {
    private static final FragmentClasspath[] emptyFragments = new FragmentClasspath[0];
    private static final String PROP_CLASSLOADER_LOCK = "osgi.classloader.lock";
    private static final String VALUE_CLASSNAME_LOCK = "classname";
    private static final boolean LOCK_CLASSNAME = "classname".equals(FrameworkProperties.getProperty("osgi.classloader.lock"));
    private final BaseData data;
    private final String[] classpath;
    private final BaseClassLoader classloader;
    private final boolean isParallelClassLoader;
    private final Map<String, Thread> classNameLocks = new HashMap<String, Thread>(5);
    private ClasspathEntry[] entries;
    private FragmentClasspath[] fragments = emptyFragments;
    private ArrayMap<String, String> loadedLibraries = null;
    private ThreadLocal<Collection<String>> currentlyDefining = new ThreadLocal();

    public ClasspathManager(BaseData baseData, String[] stringArray, BaseClassLoader baseClassLoader) {
        this.data = baseData;
        this.classpath = stringArray;
        this.classloader = baseClassLoader;
        this.isParallelClassLoader = baseClassLoader instanceof ParallelClassLoader ? ((ParallelClassLoader)baseClassLoader).isParallelCapable() : false;
    }

    public void initialize() {
        this.entries = ClasspathManager.buildClasspath(this.classpath, this, this.data, this.classloader == null ? null : this.classloader.getDomain());
        ClassLoadingHook[] classLoadingHookArray = this.data.getAdaptor().getHookRegistry().getClassLoadingHooks();
        if (this.classloader != null) {
            int n = 0;
            while (n < classLoadingHookArray.length) {
                classLoadingHookArray[n].initializedClassLoader(this.classloader, this.data);
                ++n;
            }
        }
    }

    public void close() {
        int n;
        if (this.entries != null) {
            n = 0;
            while (n < this.entries.length) {
                if (this.entries[n] != null) {
                    try {
                        this.entries[n].getBundleFile().close();
                    }
                    catch (IOException iOException) {
                        this.data.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.data.getBundle(), iOException);
                    }
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.fragments.length) {
            this.fragments[n].close();
            ++n;
        }
    }

    public void attachFragment(BundleData bundleData, ProtectionDomain protectionDomain, String[] stringArray) {
        try {
            bundleData.open();
        }
        catch (IOException iOException) {
            ((BaseData)bundleData).getAdaptor().getEventPublisher().publishFrameworkEvent(2, ((BaseData)bundleData).getBundle(), iOException);
        }
        ClasspathEntry[] classpathEntryArray = ClasspathManager.buildClasspath(stringArray, this, (BaseData)bundleData, protectionDomain);
        FragmentClasspath fragmentClasspath = new FragmentClasspath((BaseData)bundleData, classpathEntryArray, protectionDomain);
        this.insertFragment(fragmentClasspath);
    }

    private synchronized void insertFragment(FragmentClasspath fragmentClasspath) {
        FragmentClasspath[] fragmentClasspathArray = new FragmentClasspath[this.fragments.length + 1];
        long l = fragmentClasspath.getBundleData().getBundleID();
        int n = 0;
        int n2 = 0;
        while (n2 < this.fragments.length) {
            long l2 = this.fragments[n2].getBundleData().getBundleID();
            if (n == 0 && l < l2) {
                fragmentClasspathArray[n2] = fragmentClasspath;
                n = 1;
            }
            fragmentClasspathArray[n2 + n] = this.fragments[n2];
            ++n2;
        }
        if (n == 0) {
            fragmentClasspathArray[this.fragments.length] = fragmentClasspath;
        }
        this.fragments = fragmentClasspathArray;
    }

    private static ClasspathEntry[] buildClasspath(String[] stringArray, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            ClasspathManager.findClassPathEntry(arrayList, stringArray[n], classpathManager, baseData, protectionDomain);
            ++n;
        }
        return arrayList.toArray(new ClasspathEntry[arrayList.size()]);
    }

    public static void findClassPathEntry(ArrayList<ClasspathEntry> arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        ClassLoadingHook[] classLoadingHookArray = baseData.getAdaptor().getHookRegistry().getClassLoadingHooks();
        boolean bl = false;
        int n = 0;
        while (n < classLoadingHookArray.length) {
            bl |= classLoadingHookArray[n].addClassPathEntry(arrayList, string, classpathManager, baseData, protectionDomain);
            ++n;
        }
        if (!ClasspathManager.addClassPathEntry(arrayList, string, classpathManager, baseData, protectionDomain) && !bl) {
            BundleException bundleException = new BundleException(NLS.bind(AdaptorMsg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, string, baseData.getLocation()), 3);
            baseData.getAdaptor().getEventPublisher().publishFrameworkEvent(32, baseData.getBundle(), bundleException);
        }
    }

    public static boolean addClassPathEntry(ArrayList<ClasspathEntry> arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        if (string.equals(".")) {
            arrayList.add(classpathManager.createClassPathEntry(baseData.getBundleFile(), protectionDomain, baseData));
            return true;
        }
        ClasspathEntry classpathEntry = classpathManager.getClasspath(string, baseData, protectionDomain);
        if (classpathEntry != null) {
            arrayList.add(classpathEntry);
            return true;
        }
        if (classpathManager.data == baseData) {
            int n = 0;
            while (n < classpathManager.fragments.length) {
                FragmentClasspath fragmentClasspath = classpathManager.fragments[n];
                classpathEntry = classpathManager.getClasspath(string, fragmentClasspath.getBundleData(), fragmentClasspath.getDomain());
                if (classpathEntry != null) {
                    arrayList.add(classpathEntry);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public ClasspathEntry getClasspath(String string, BaseData baseData, ProtectionDomain protectionDomain) {
        BundleFile bundleFile = null;
        BundleEntry bundleEntry = baseData.getBundleFile().getEntry(string);
        if (bundleEntry != null && bundleEntry.getName().endsWith("/")) {
            bundleFile = ClasspathManager.createBundleFile(string, baseData);
        } else {
            File file = baseData.getBundleFile().getFile(string, false);
            if (file != null) {
                bundleFile = ClasspathManager.createBundleFile(file, baseData);
            }
        }
        if (bundleFile != null) {
            return this.createClassPathEntry(bundleFile, protectionDomain, baseData);
        }
        return null;
    }

    public ClasspathEntry getExternalClassPath(String string, BaseData baseData, ProtectionDomain protectionDomain) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            return null;
        }
        BundleFile bundleFile = ClasspathManager.createBundleFile(file, baseData);
        if (bundleFile != null) {
            return this.createClassPathEntry(bundleFile, protectionDomain, baseData);
        }
        return null;
    }

    private static BundleFile createBundleFile(Object object, BaseData baseData) {
        if (object == null || object instanceof File && !((File)object).exists()) {
            return null;
        }
        try {
            return baseData.getAdaptor().createBundleFile(object, baseData);
        }
        catch (IOException iOException) {
            baseData.getAdaptor().getEventPublisher().publishFrameworkEvent(2, baseData.getBundle(), iOException);
            return null;
        }
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundleFile, ProtectionDomain protectionDomain, BaseData baseData) {
        ClasspathEntry classpathEntry = this.classloader != null ? this.classloader.createClassPathEntry(bundleFile, protectionDomain) : new ClasspathEntry(bundleFile, null);
        classpathEntry.setBaseData(baseData);
        ProtectionDomain protectionDomain2 = classpathEntry.getDomain();
        if (protectionDomain2 instanceof BundleProtectionDomain) {
            ((BundleProtectionDomain)protectionDomain2).setBundle(baseData.getBundle());
        }
        return classpathEntry;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL findLocalResource(String var1_1) {
        var2_2 = this.data.getAdaptor().getHookRegistry().getClassLoadingStatsHooks();
        var3_3 = 0;
        while (var3_3 < var2_2.length) {
            var2_2[var3_3].preFindLocalResource(var1_1, this);
            ++var3_3;
        }
        var3_4 = null;
        try {
            var5_5 = var3_4 = this.findLocalResourceImpl(var1_1, -1);
            return var5_5;
        }
        finally {
            var6_6 = 0;
            ** while (var6_6 < var2_2.length)
        }
lbl-1000:
        // 1 sources

        {
            var2_2[var6_6].postFindLocalResource(var1_1, var3_4, this);
            ++var6_6;
            continue;
        }
lbl17:
        // 1 sources

        return var5_5;
    }

    private URL findLocalResourceImpl(String string, int n) {
        URL uRL = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.entries.length) {
            if (this.entries[n3] != null && (uRL = this.findResourceImpl(string, this.entries[n3].getBundleFile(), n2)) != null && (n == -1 || n == n2)) {
                return uRL;
            }
            ++n2;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.fragments.length) {
            ClasspathEntry[] classpathEntryArray = this.fragments[n3].getEntries();
            int n4 = 0;
            while (n4 < classpathEntryArray.length) {
                uRL = this.findResourceImpl(string, classpathEntryArray[n4].getBundleFile(), n2);
                if (uRL != null && (n == -1 || n == n2)) {
                    return uRL;
                }
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public Enumeration<URL> findLocalResources(String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        int n = 0;
        int n2 = 0;
        while (n2 < this.entries.length) {
            if (this.entries[n2] != null && (object = this.findResourceImpl(string, this.entries[n2].getBundleFile(), n)) != null) {
                arrayList.add(object);
            }
            ++n;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.fragments.length) {
            object = this.fragments[n2].getEntries();
            int n3 = 0;
            while (n3 < ((ClasspathEntry[])object).length) {
                URL uRL = this.findResourceImpl(string, object[n3].getBundleFile(), n);
                if (uRL != null) {
                    arrayList.add(uRL);
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            return Collections.enumeration(arrayList);
        }
        return null;
    }

    private URL findResourceImpl(String string, BundleFile bundleFile, int n) {
        return bundleFile.getResourceURL(string, this.data, n);
    }

    public BundleEntry findLocalEntry(String string) {
        return this.findLocalEntry(string, -1);
    }

    public BundleEntry findLocalEntry(String string, int n) {
        BundleEntry bundleEntry = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.entries.length) {
            if (this.entries[n3] != null && (bundleEntry = this.findEntryImpl(string, this.entries[n3].getBundleFile())) != null && (n == -1 || n == n2)) {
                return bundleEntry;
            }
            ++n2;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.fragments.length) {
            ClasspathEntry[] classpathEntryArray = this.fragments[n3].getEntries();
            int n4 = 0;
            while (n4 < classpathEntryArray.length) {
                bundleEntry = this.findEntryImpl(string, classpathEntryArray[n4].getBundleFile());
                if (bundleEntry != null && (n == -1 || n == n2)) {
                    return bundleEntry;
                }
                ++n2;
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public Enumeration<BundleEntry> findLocalEntries(String string) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (object = this.findEntryImpl(string, this.entries[n].getBundleFile())) != null) {
                arrayList.add(object);
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            object = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < ((ClasspathEntry[])object).length) {
                BundleEntry bundleEntry = this.findEntryImpl(string, object[n2].getBundleFile());
                if (bundleEntry != null) {
                    arrayList.add(bundleEntry);
                }
                ++n2;
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            return Collections.enumeration(arrayList);
        }
        return null;
    }

    private BundleEntry findEntryImpl(String string, BundleFile bundleFile) {
        return bundleFile.getEntry(string);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> findLocalClass(String var1_1) throws ClassNotFoundException {
        var2_2 = null;
        var3_3 = this.data.getAdaptor().getHookRegistry().getClassLoadingStatsHooks();
        try {
            var4_4 = 0;
            while (var4_4 < var3_3.length) {
                var3_3[var4_4].preFindLocalClass(var1_1, this);
                ++var4_4;
            }
            var2_2 = ClasspathManager.LOCK_CLASSNAME != false || this.isParallelClassLoader != false ? this.findLocalClass_LockClassName(var1_1, var3_3) : this.findLocalClass_LockClassLoader(var1_1, var3_3);
            var6_5 = var2_2;
            return var6_5;
        }
        finally {
            var7_6 = 0;
            ** while (var7_6 < var3_3.length)
        }
lbl-1000:
        // 1 sources

        {
            var3_3[var7_6].postFindLocalClass(var1_1, var2_2, this);
            ++var7_6;
            continue;
        }
lbl18:
        // 1 sources

        return var6_5;
    }

    private Class<?> findLocalClass_LockClassName(String string, ClassLoadingStatsHook[] classLoadingStatsHookArray) throws ClassNotFoundException {
        boolean bl = this.lockClassName(string);
        try {
            Class<?> clazz = this.findLocalClassImpl(string, classLoadingStatsHookArray);
            return clazz;
        }
        finally {
            if (bl) {
                this.unlockClassName(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> findLocalClass_LockClassLoader(String string, ClassLoadingStatsHook[] classLoadingStatsHookArray) throws ClassNotFoundException {
        BaseClassLoader baseClassLoader = this.classloader;
        synchronized (baseClassLoader) {
            return this.findLocalClassImpl(string, classLoadingStatsHookArray);
        }
    }

    private Class<?> findLocalClassImpl(String string, ClassLoadingStatsHook[] classLoadingStatsHookArray) throws ClassNotFoundException {
        Class<?> clazz = this.classloader.publicFindLoaded(string);
        if (clazz != null) {
            return clazz;
        }
        int n = 0;
        while (n < this.entries.length) {
            if (this.entries[n] != null && (clazz = this.findClassImpl(string, this.entries[n], classLoadingStatsHookArray)) != null) {
                return clazz;
            }
            ++n;
        }
        n = 0;
        while (n < this.fragments.length) {
            ClasspathEntry[] classpathEntryArray = this.fragments[n].getEntries();
            int n2 = 0;
            while (n2 < classpathEntryArray.length) {
                clazz = this.findClassImpl(string, classpathEntryArray[n2], classLoadingStatsHookArray);
                if (clazz != null) {
                    return clazz;
                }
                ++n2;
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    /*
     * Unable to fully structure code
     */
    private boolean lockClassName(String var1_1) throws ClassNotFoundException {
        var2_2 = this.classNameLocks;
        synchronized (var2_2) {
            block8: {
                var3_3 = this.classNameLocks.get(var1_1);
                var4_4 = Thread.currentThread();
                if (var3_3 != var4_4) break block8;
                return false;
            }
            while (true) lbl-1000:
            // 2 sources

            {
                if (var3_3 != null) ** break block9
                this.classNameLocks.put(var1_1, var4_4);
                return true;
                break;
            }
            {
                try {
                    this.classNameLocks.wait();
                    var3_3 = this.classNameLocks.get(var1_1);
                    continue;
                }
                catch (InterruptedException var5_5) {
                    var4_4.interrupt();
                    throw new ClassNotFoundException(var1_1, var5_5);
                }
                ** while (true)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockClassName(String string) {
        Map<String, Thread> map = this.classNameLocks;
        synchronized (map) {
            this.classNameLocks.remove(string);
            this.classNameLocks.notifyAll();
        }
    }

    private Class<?> findClassImpl(String string, ClasspathEntry classpathEntry, ClassLoadingStatsHook[] classLoadingStatsHookArray) {
        Collection<String> collection;
        byte[] byArray;
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("BundleClassLoader[").append(classpathEntry.getBundleFile()).append("].findClass(").append(string).append(")").toString());
        }
        String string2 = string.replace('.', '/').concat(".class");
        BundleEntry bundleEntry = classpathEntry.getBundleFile().getEntry(string2);
        if (bundleEntry == null) {
            return null;
        }
        try {
            byArray = bundleEntry.getBytes();
        }
        catch (IOException iOException) {
            if (Debug.DEBUG_LOADER) {
                Debug.println(new StringBuffer("  IOException reading ").append(string2).append(" from ").append(classpathEntry.getBundleFile()).toString());
            }
            return null;
        }
        if (Debug.DEBUG_LOADER) {
            Debug.println(new StringBuffer("  read ").append(byArray.length).append(" bytes from ").append(classpathEntry.getBundleFile()).append("/").append(string2).toString());
            Debug.println(new StringBuffer("  defining class ").append(string).toString());
        }
        if ((collection = this.currentlyDefining.get()) == null) {
            collection = new ArrayList<String>(5);
            this.currentlyDefining.set(collection);
        }
        if (collection.contains(string)) {
            return null;
        }
        try {
            collection.add(string);
            Class<?> clazz = this.defineClass(string, byArray, classpathEntry, bundleEntry, classLoadingStatsHookArray);
            return clazz;
        }
        catch (Error error) {
            if (Debug.DEBUG_LOADER) {
                Debug.println(new StringBuffer("  error defining class ").append(string).toString());
            }
            throw error;
        }
        finally {
            collection.remove(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> defineClass(String var1_1, byte[] var2_2, ClasspathEntry var3_3, BundleEntry var4_4, ClassLoadingStatsHook[] var5_5) {
        var6_6 = this.data.getAdaptor().getHookRegistry().getClassLoadingHooks();
        var7_7 = var2_2;
        var8_8 = null;
        try {
            var9_9 = 0;
            while (var9_9 < var6_6.length) {
                var7_7 = var6_6[var9_9].processClass(var1_1, var2_2, var3_3, var4_4, this);
                if (var7_7 != null) {
                    var2_2 = var7_7;
                }
                ++var9_9;
            }
            var8_8 = this.classloader.defineClass(var1_1, var2_2, var3_3, var4_4);
        }
        finally {
            var11_12 = 0;
            ** while (var11_12 < var5_5.length)
        }
lbl-1000:
        // 1 sources

        {
            var5_5[var11_12].recordClassDefine(var1_1, var8_8, var2_2, var3_3, var4_4, this);
            ++var11_12;
            continue;
        }
lbl20:
        // 1 sources

        return var8_8;
    }

    public BaseData getBaseData() {
        return this.data;
    }

    public FragmentClasspath[] getFragmentClasspaths() {
        return this.fragments;
    }

    public ClasspathEntry[] getHostClasspathEntries() {
        return this.entries;
    }

    public BaseClassLoader getBaseClassLoader() {
        return this.classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLibrary(String string) {
        Object object = this;
        synchronized (object) {
            if (this.loadedLibraries == null) {
                this.loadedLibraries = new ArrayMap(1);
            }
        }
        object = this.loadedLibraries;
        synchronized (object) {
            String string2 = this.loadedLibraries.get(string);
            if (string2 != null) {
                return string2;
            }
            string2 = this.classloader.getDelegate().findLibrary(string);
            if (string2 != null) {
                this.loadedLibraries.put(string, string2);
            }
            return string2;
        }
    }

    public List<URL> findEntries(String string, String string2, int n) {
        ArrayList<URL> arrayList;
        FragmentClasspath[] fragmentClasspathArray;
        BaseAdaptor baseAdaptor = this.getBaseData().getAdaptor();
        ArrayList<BundleData> arrayList2 = new ArrayList<BundleData>();
        arrayList2.add(this.getBaseData());
        FragmentClasspath[] fragmentClasspathArray2 = fragmentClasspathArray = this.getFragmentClasspaths();
        int n2 = fragmentClasspathArray.length;
        int n3 = 0;
        while (n3 < n2) {
            arrayList = fragmentClasspathArray2[n3];
            arrayList2.add(((FragmentClasspath)((Object)arrayList)).getBundleData());
            ++n3;
        }
        arrayList = Collections.EMPTY_LIST;
        Enumeration<URL> enumeration = baseAdaptor.findEntries(arrayList2, string, string2, n);
        if (enumeration == null) {
            return arrayList;
        }
        arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Collection<String> listLocalResources(String string, String string2, int n) {
        Object object;
        ClasspathEntry[] classpathEntryArray;
        ArrayList<BundleFile> arrayList = new ArrayList<BundleFile>();
        ClasspathEntry[] classpathEntryArray2 = classpathEntryArray = this.getHostClasspathEntries();
        int n2 = classpathEntryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = classpathEntryArray2[n3];
            arrayList.add(((ClasspathEntry)object).getBundleFile());
            ++n3;
        }
        object = this.getFragmentClasspaths();
        FragmentClasspath[] fragmentClasspathArray = object;
        int n4 = ((FragmentClasspath[])object).length;
        n2 = 0;
        while (n2 < n4) {
            ClasspathEntry[] classpathEntryArray3;
            FragmentClasspath fragmentClasspath = fragmentClasspathArray[n2];
            ClasspathEntry[] classpathEntryArray4 = classpathEntryArray3 = fragmentClasspath.getEntries();
            int n5 = classpathEntryArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                ClasspathEntry classpathEntry = classpathEntryArray4[n6];
                arrayList.add(classpathEntry.getBundleFile());
                ++n6;
            }
            ++n2;
        }
        return this.getBaseData().getAdaptor().listEntryPaths(arrayList, string, string2, n);
    }
}

