/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedDirBundleFile
extends BundleFile {
    private final BundleFile baseBundleFile;
    private final String cp;

    public NestedDirBundleFile(BundleFile bundleFile, String string) {
        super(bundleFile.getBaseFile());
        this.baseBundleFile = bundleFile;
        if (string.charAt(string.length() - 1) != '/') {
            string = new StringBuffer(String.valueOf(string)).append('/').toString();
        }
        this.cp = string;
    }

    @Override
    public void close() {
    }

    @Override
    public BundleEntry getEntry(String string) {
        return this.baseBundleFile.getEntry(this.prependNestedDir(string));
    }

    @Override
    public boolean containsDir(String string) {
        if (string == null) {
            return false;
        }
        return this.baseBundleFile.containsDir(this.prependNestedDir(string));
    }

    private String prependNestedDir(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return new StringBuffer(this.cp).append(string).toString();
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) {
        final Enumeration<String> enumeration = this.baseBundleFile.getEntryPaths(this.prependNestedDir(string));
        final int n = this.cp.length();
        if (enumeration == null) {
            return null;
        }
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public String nextElement() {
                String string = (String)enumeration.nextElement();
                return string.substring(n);
            }
        };
    }

    @Override
    public File getFile(String string, boolean bl) {
        return null;
    }

    @Override
    public void open() throws IOException {
    }
}

