/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.util.HashMap;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.Logger;
import org.eclipse.equinox.log.internal.ExtendedLogServiceFactory;
import org.eclipse.equinox.log.internal.LoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ExtendedLogServiceImpl
implements ExtendedLogService,
LogService {
    private final ExtendedLogServiceFactory factory;
    private volatile Bundle bundle;
    private final HashMap<String, Logger> loggerCache = new HashMap();

    public ExtendedLogServiceImpl(ExtendedLogServiceFactory extendedLogServiceFactory, Bundle bundle) {
        this.factory = extendedLogServiceFactory;
        this.bundle = bundle;
    }

    public void log(int n, String string) {
        this.log((ServiceReference)null, n, string, (Throwable)null);
    }

    public void log(int n, String string, Throwable throwable) {
        this.log((ServiceReference)null, n, string, throwable);
    }

    public void log(ServiceReference serviceReference, int n, String string) {
        this.log(serviceReference, n, string, (Throwable)null);
    }

    public void log(ServiceReference serviceReference, int n, String string, Throwable throwable) {
        this.getLogger(null).log(serviceReference, n, string, throwable);
    }

    public void log(Object object, int n, String string) {
        this.log(object, n, string, null);
    }

    public void log(Object object, int n, String string, Throwable throwable) {
        this.getLogger(null).log(object, n, string, throwable);
    }

    public synchronized Logger getLogger(String string) {
        Logger logger = this.loggerCache.get(string);
        if (logger == null) {
            logger = new LoggerImpl(this, string);
            this.loggerCache.put(string, logger);
        }
        return logger;
    }

    public Logger getLogger(Bundle bundle, String string) {
        if (bundle == null || bundle == this.bundle) {
            return this.getLogger(string);
        }
        this.factory.checkLogPermission();
        ExtendedLogServiceImpl extendedLogServiceImpl = this.factory.getLogService(bundle);
        return extendedLogServiceImpl.getLogger(string);
    }

    public String getName() {
        return this.getLogger(null).getName();
    }

    public boolean isLoggable(int n) {
        return this.getLogger(null).isLoggable(n);
    }

    boolean isLoggable(String string, int n) {
        return this.factory.isLoggable(this.bundle, string, n);
    }

    void log(String string, Object object, int n, String string2, Throwable throwable) {
        this.factory.log(this.bundle, string, object, n, string2, throwable);
    }

    void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }
}

