/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogPermission;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.eclipse.equinox.log.internal.ExtendedLogServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedLogServiceFactory
implements ServiceFactory<ExtendedLogService>,
BundleListener {
    private final Permission logPermission = new LogPermission("*", "log");
    private final ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private final Map<Bundle, ExtendedLogService> logServices = new HashMap<Bundle, ExtendedLogService>();

    public ExtendedLogServiceFactory(ExtendedLogReaderServiceFactory extendedLogReaderServiceFactory) {
        this.logReaderServiceFactory = extendedLogReaderServiceFactory;
    }

    @Override
    public ExtendedLogServiceImpl getService(Bundle bundle, ServiceRegistration<ExtendedLogService> serviceRegistration) {
        return this.getLogService(bundle);
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<ExtendedLogService> serviceRegistration, ExtendedLogService extendedLogService) {
    }

    @Override
    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 16) {
            this.removeLogService(bundleEvent.getBundle());
        }
    }

    synchronized ExtendedLogServiceImpl getLogService(Bundle bundle) {
        ExtendedLogServiceImpl extendedLogServiceImpl = (ExtendedLogServiceImpl)this.logServices.get(bundle);
        if (extendedLogServiceImpl == null) {
            extendedLogServiceImpl = new ExtendedLogServiceImpl(this, bundle);
            if (bundle != null && bundle.getState() != 1) {
                this.logServices.put(bundle, extendedLogServiceImpl);
            }
        }
        return extendedLogServiceImpl;
    }

    synchronized void shutdown() {
        this.logServices.clear();
    }

    synchronized void removeLogService(Bundle bundle) {
        this.logServices.remove(bundle);
    }

    boolean isLoggable(Bundle bundle, String string, int n) {
        return this.logReaderServiceFactory.isLoggable(bundle, string, n);
    }

    void log(Bundle bundle, String string, Object object, int n, String string2, Throwable throwable) {
        this.logReaderServiceFactory.log(bundle, string, object, n, string2, throwable);
    }

    void checkLogPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.logPermission);
        }
    }
}

