/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.equinox.log.internal.BasicReadWriteLock;
import org.eclipse.equinox.log.internal.ExtendedLogEntryImpl;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceImpl;
import org.eclipse.equinox.log.internal.SerializedTaskQueue;
import org.eclipse.osgi.internal.baseadaptor.ArrayMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedLogReaderServiceFactory
implements ServiceFactory<ExtendedLogReaderServiceImpl> {
    static final int MAX_RECURSIONS = 50;
    private static final Enumeration<?> EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_LIST);
    static final LogFilter NULL_LOGGER_FILTER = new LogFilter(){

        public boolean isLoggable(Bundle bundle, String string, int n) {
            return true;
        }
    };
    private static final LogFilter[] ALWAYS_LOG = new LogFilter[0];
    private static PrintStream errorStream;
    private ArrayMap<LogListener, Object[]> listeners = new ArrayMap(5);
    private LogFilter[] filters = null;
    private BasicReadWriteLock listenersLock = new BasicReadWriteLock();

    static boolean safeIsLoggable(LogFilter logFilter, Bundle bundle, String string, int n) {
        try {
            return logFilter.isLoggable(bundle, string, n);
        }
        catch (RuntimeException runtimeException) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            runtimeException.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        catch (LinkageError linkageError) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            linkageError.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        return false;
    }

    private static synchronized PrintStream getErrorStream() {
        if (errorStream == null) {
            return System.err;
        }
        return errorStream;
    }

    public static synchronized void setErrorStream(PrintStream printStream) {
        errorStream = printStream;
    }

    static void safeLogged(LogListener logListener, LogEntry logEntry) {
        try {
            logListener.logged(logEntry);
        }
        catch (RuntimeException runtimeException) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            runtimeException.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        catch (LinkageError linkageError) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            linkageError.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
    }

    @Override
    public ExtendedLogReaderServiceImpl getService(Bundle bundle, ServiceRegistration<ExtendedLogReaderServiceImpl> serviceRegistration) {
        return new ExtendedLogReaderServiceImpl(this);
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<ExtendedLogReaderServiceImpl> serviceRegistration, ExtendedLogReaderServiceImpl extendedLogReaderServiceImpl) {
        extendedLogReaderServiceImpl.shutdown();
    }

    boolean isLoggable(final Bundle bundle, final String string, final int n) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return new Boolean(ExtendedLogReaderServiceFactory.this.isLoggablePrivileged(bundle, string, n));
                }
            });
        }
        return this.isLoggablePrivileged(bundle, string, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isLoggablePrivileged(Bundle bundle, String string, int n) {
        int n2 = this.listenersLock.readLock();
        try {
            if (n2 == 50) {
                return false;
            }
            if (this.filters == null) {
                return false;
            }
            if (this.filters == ALWAYS_LOG) {
                return true;
            }
            int n3 = this.filters.length;
            int n4 = 0;
            while (n4 < n3) {
                LogFilter logFilter = this.filters[n4];
                if (ExtendedLogReaderServiceFactory.safeIsLoggable(logFilter, bundle, string, n)) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        finally {
            this.listenersLock.readUnlock();
        }
    }

    void log(final Bundle bundle, final String string, final Object object, final int n, final String string2, final Throwable throwable) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ExtendedLogReaderServiceFactory.this.logPrivileged(bundle, string, object, n, string2, throwable);
                    return null;
                }
            });
        } else {
            this.logPrivileged(bundle, string, object, n, string2, throwable);
        }
    }

    void logPrivileged(Bundle bundle, String string, Object object, int n, String string2, Throwable throwable) {
        ExtendedLogEntryImpl extendedLogEntryImpl = new ExtendedLogEntryImpl(bundle, string, object, n, string2, throwable);
        int n2 = this.listenersLock.readLock();
        try {
            if (n2 >= 50) {
                return;
            }
            int n3 = this.listeners.size();
            int n4 = 0;
            while (n4 < n3) {
                Object[] objectArray = this.listeners.getValue(n4);
                LogFilter logFilter = (LogFilter)objectArray[0];
                if (ExtendedLogReaderServiceFactory.safeIsLoggable(logFilter, bundle, string, n)) {
                    LogListener logListener = this.listeners.getKey(n4);
                    SerializedTaskQueue serializedTaskQueue = (SerializedTaskQueue)objectArray[1];
                    if (serializedTaskQueue != null) {
                        serializedTaskQueue.put(new LogTask(extendedLogEntryImpl, logListener));
                    } else {
                        ExtendedLogReaderServiceFactory.safeLogged(logListener, extendedLogEntryImpl);
                    }
                }
                ++n4;
            }
        }
        finally {
            this.listenersLock.readUnlock();
        }
    }

    void addLogListener(LogListener logListener, LogFilter logFilter) {
        this.listenersLock.writeLock();
        try {
            Object[] objectArray = this.listeners.get(logListener);
            if (objectArray == null) {
                SerializedTaskQueue serializedTaskQueue = logListener instanceof SynchronousLogListener ? null : new SerializedTaskQueue(logListener.toString());
                objectArray = new Object[]{logFilter, serializedTaskQueue};
            } else if (logFilter != objectArray[0]) {
                objectArray[0] = logFilter;
            }
            this.listeners.put(logListener, objectArray);
            this.recalculateFilters();
        }
        finally {
            this.listenersLock.writeUnlock();
        }
    }

    private void recalculateFilters() {
        ArrayList<LogFilter> arrayList = new ArrayList<LogFilter>();
        int n = this.listeners.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = this.listeners.getValue(n2);
            LogFilter logFilter = (LogFilter)objectArray[0];
            if (logFilter == NULL_LOGGER_FILTER) {
                this.filters = ALWAYS_LOG;
                return;
            }
            arrayList.add(logFilter);
            ++n2;
        }
        if (arrayList.isEmpty()) {
            this.filters = null;
        }
        this.filters = arrayList.toArray(new LogFilter[arrayList.size()]);
    }

    void removeLogListener(LogListener logListener) {
        this.listenersLock.writeLock();
        try {
            this.listeners.remove(logListener);
            this.recalculateFilters();
        }
        finally {
            this.listenersLock.writeUnlock();
        }
    }

    Enumeration<?> getLog() {
        return EMPTY_ENUMERATION;
    }

    static final class LogTask
    implements Runnable {
        private final LogEntry logEntry;
        private final LogListener listener;

        LogTask(LogEntry logEntry, LogListener logListener) {
            this.logEntry = logEntry;
            this.listener = logListener;
        }

        public void run() {
            ExtendedLogReaderServiceFactory.safeLogged(this.listener, this.logEntry);
        }
    }
}

