/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.EclipseLogFactory;
import org.eclipse.core.runtime.internal.adaptor.EclipseLogWriter;
import org.eclipse.equinox.log.internal.LogServiceManager;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLogHook
implements HookConfigurator,
AdaptorHook {
    static final String EQUINOX_LOGGER_NAME = "org.eclipse.equinox.logger";
    static final String PERF_LOGGER_NAME = "org.eclipse.performance.logger";
    private static final String PROP_LOG_ENABLED = "eclipse.log.enabled";
    private static final String LOG_EXT = ".log";
    private final LogServiceManager logServiceManager;
    private final EclipseLogFactory eclipseLogFactory;
    private final EclipseLogWriter logWriter;
    private final EclipseLogWriter perfWriter;
    private ServiceRegistration<?> frameworkLogReg;
    private ServiceRegistration<?> perfLogReg;
    static /* synthetic */ Class class$0;

    public EclipseLogHook() {
        File file;
        Object object;
        String string = FrameworkProperties.getProperty("osgi.logfile");
        boolean bl = "true".equals(FrameworkProperties.getProperty(PROP_LOG_ENABLED, "true"));
        if (string != null) {
            this.logWriter = new EclipseLogWriter(new File(string), EQUINOX_LOGGER_NAME, bl);
        } else {
            object = LocationManager.getConfigurationLocation();
            file = null;
            if (object != null) {
                file = new File(object.getURL().getFile());
            }
            if (file != null) {
                String string2 = new StringBuffer(String.valueOf(Long.toString(System.currentTimeMillis()))).append(LOG_EXT).toString();
                File file2 = new File(file, string2);
                FrameworkProperties.setProperty("osgi.logfile", file2.getAbsolutePath());
                this.logWriter = new EclipseLogWriter(file2, EQUINOX_LOGGER_NAME, bl);
            } else {
                this.logWriter = new EclipseLogWriter(null, EQUINOX_LOGGER_NAME, bl);
            }
        }
        object = this.logWriter.getFile();
        if (object != null) {
            file = new File(((File)object).getParentFile(), "performance.log");
            this.perfWriter = new EclipseLogWriter(file, PERF_LOGGER_NAME, true);
        } else {
            this.perfWriter = new EclipseLogWriter(null, PERF_LOGGER_NAME, true);
        }
        if ("true".equals(FrameworkProperties.getProperty("eclipse.consoleLog"))) {
            this.logWriter.setConsoleLog(true);
        }
        this.logServiceManager = new LogServiceManager(new LogListener[]{this.logWriter, this.perfWriter});
        this.eclipseLogFactory = new EclipseLogFactory(this.logWriter, this.logServiceManager);
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
    }

    @Override
    public void initialize(BaseAdaptor baseAdaptor) {
    }

    @Override
    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        this.logServiceManager.start(bundleContext);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.frameworkLogReg = AdaptorUtil.register(clazz.getName(), this.eclipseLogFactory, bundleContext);
        this.perfLogReg = this.registerPerformanceLog(bundleContext);
    }

    @Override
    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        this.frameworkLogReg.unregister();
        this.perfLogReg.unregister();
        this.logServiceManager.stop(bundleContext);
    }

    @Override
    public void frameworkStopping(BundleContext bundleContext) {
    }

    @Override
    public void addProperties(Properties properties) {
    }

    @Override
    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    @Override
    public void handleRuntimeError(Throwable throwable) {
    }

    @Override
    public FrameworkLog createFrameworkLog() {
        return this.eclipseLogFactory.createFrameworkLog(null, this.logWriter);
    }

    private ServiceRegistration<?> registerPerformanceLog(BundleContext bundleContext) {
        FrameworkLog frameworkLog = this.createPerformanceLog(bundleContext.getBundle());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = clazz.getName();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(7);
        Dictionary<String, String> dictionary = bundleContext.getBundle().getHeaders();
        ((Dictionary)hashtable).put("service.vendor", dictionary.get("Bundle-Vendor"));
        ((Dictionary)hashtable).put("service.ranking", new Integer(Integer.MIN_VALUE));
        ((Dictionary)hashtable).put("service.pid", new StringBuffer(String.valueOf(bundleContext.getBundle().getBundleId() + 46L)).append(frameworkLog.getClass().getName()).toString());
        ((Dictionary)hashtable).put("performance", Boolean.TRUE.toString());
        return bundleContext.registerService(string, (Object)frameworkLog, hashtable);
    }

    private FrameworkLog createPerformanceLog(Bundle bundle) {
        return this.eclipseLogFactory.createFrameworkLog(bundle, this.perfWriter);
    }
}

