/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.runtime.internal.adaptor.EclipseLogWriter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.equinox.log.internal.LogServiceManager;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLogFactory
implements ServiceFactory<FrameworkLog> {
    final EclipseLogWriter defaultWriter;
    final LogServiceManager logManager;

    public EclipseLogFactory(EclipseLogWriter eclipseLogWriter, LogServiceManager logServiceManager) {
        this.defaultWriter = eclipseLogWriter;
        this.logManager = logServiceManager;
    }

    @Override
    public FrameworkLog getService(Bundle bundle, ServiceRegistration<FrameworkLog> serviceRegistration) {
        return this.createFrameworkLog(bundle, this.defaultWriter);
    }

    FrameworkLog createFrameworkLog(Bundle bundle, EclipseLogWriter eclipseLogWriter) {
        final EclipseLogWriter eclipseLogWriter2 = eclipseLogWriter == null ? this.defaultWriter : eclipseLogWriter;
        final Logger logger = bundle == null ? this.logManager.getSystemBundleLog().getLogger(eclipseLogWriter.getLoggerName()) : this.logManager.getSystemBundleLog().getLogger(bundle, eclipseLogWriter2.getLoggerName());
        return new FrameworkLog(){

            public void setWriter(Writer writer, boolean bl) {
                eclipseLogWriter2.setWriter(writer, bl);
            }

            public void setFile(File file, boolean bl) throws IOException {
                eclipseLogWriter2.setFile(file, bl);
            }

            public void setConsoleLog(boolean bl) {
                eclipseLogWriter2.setConsoleLog(bl);
            }

            public void log(FrameworkLogEntry frameworkLogEntry) {
                logger.log(frameworkLogEntry, EclipseLogFactory.convertLevel(frameworkLogEntry), frameworkLogEntry.getMessage(), frameworkLogEntry.getThrowable());
            }

            public void log(FrameworkEvent frameworkEvent) {
                int n;
                Bundle bundle = frameworkEvent.getBundle();
                Throwable throwable = frameworkEvent.getThrowable();
                String string = bundle.getSymbolicName() == null ? bundle.getLocation() : bundle.getSymbolicName();
                switch (frameworkEvent.getType()) {
                    case 32: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 16: {
                        n = 2;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry(string, n, 0, "", 0, throwable, null);
                this.log(frameworkLogEntry);
            }

            public File getFile() {
                return eclipseLogWriter2.getFile();
            }

            public void close() {
                eclipseLogWriter2.close();
            }
        };
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<FrameworkLog> serviceRegistration, FrameworkLog frameworkLog) {
    }

    static int convertLevel(FrameworkLogEntry frameworkLogEntry) {
        switch (frameworkLogEntry.getSeverity()) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return 32;
    }
}

