/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingStatsHook;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLazyStarter
implements ClassLoadingStatsHook,
AdaptorHook,
HookConfigurator {
    private static final boolean throwErrorOnFailedStart = "true".equals(FrameworkProperties.getProperty("osgi.compatibility.errorOnFailedStart", "true"));
    private BaseAdaptor adaptor;
    private ThreadLocal<List<Object>> activationStack = new ThreadLocal();
    private final Map<ClasspathManager, TerminatingClassNotFoundException> errors = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public void preFindLocalClass(String string, ClasspathManager classpathManager) throws ClassNotFoundException {
        int n;
        AbstractBundle abstractBundle = (AbstractBundle)classpathManager.getBaseData().getBundle();
        if ((abstractBundle.getState() & 0x31) != 0) {
            return;
        }
        EclipseStorageHook eclipseStorageHook = (EclipseStorageHook)classpathManager.getBaseData().getStorageHook(EclipseStorageHook.KEY);
        if (!this.shouldActivateFor(string, classpathManager.getBaseData(), eclipseStorageHook, classpathManager)) {
            return;
        }
        List<Object> list = this.activationStack.get();
        if (list == null) {
            list = new ArrayList<Object>(6);
            this.activationStack.set(list);
        }
        if ((n = list.size()) > 1) {
            int n2 = n - 1;
            while (n2 >= 1) {
                if (classpathManager == list.get(n2)) {
                    return;
                }
                --n2;
            }
        }
        Thread thread = abstractBundle.getStateChanging();
        if (abstractBundle.getState() == 8 && thread == Thread.currentThread()) {
            return;
        }
        if (n == 0) {
            list.add(string);
        }
        list.add(classpathManager);
    }

    @Override
    public void postFindLocalClass(String string, Class<?> clazz, ClasspathManager classpathManager) throws ClassNotFoundException {
        List<Object> list = this.activationStack.get();
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n <= 1 || list.get(0) != string) {
            return;
        }
        ClasspathManager[] classpathManagerArray = null;
        classpathManagerArray = new ClasspathManager[n - 1];
        int n2 = 1;
        while (n2 < n) {
            classpathManagerArray[n2 - 1] = (ClasspathManager)list.get(n2);
            ++n2;
        }
        list.clear();
        if (clazz == null) {
            return;
        }
        n2 = classpathManagerArray.length - 1;
        while (n2 >= 0) {
            if (this.errors.get(classpathManagerArray[n2]) != null) {
                if (throwErrorOnFailedStart) {
                    throw this.errors.get(classpathManagerArray[n2]);
                }
            } else {
                long l = System.currentTimeMillis();
                try {
                    classpathManagerArray[n2].getBaseClassLoader().getDelegate().setLazyTrigger();
                }
                catch (BundleException bundleException) {
                    Object object;
                    Object object2;
                    Bundle bundle = classpathManagerArray[n2].getBaseData().getBundle();
                    Throwable throwable = bundleException.getCause();
                    if (throwable != null && throwable instanceof StatusException && ((object2 = (StatusException)((Object)throwable)).getStatusCode() & 8) == 0) {
                        if (object2.getStatus() instanceof Thread) {
                            object = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CONCURRENT_STARTUP, new Object[]{Thread.currentThread(), string, object2.getStatus(), bundle, new Long(System.currentTimeMillis() - l)});
                            this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, (String)object, 0, bundleException, null));
                        }
                    }
                    object2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_ACTIVATION, bundle.getSymbolicName(), Long.toString(bundle.getBundleId()));
                    object = new TerminatingClassNotFoundException((String)object2, bundleException);
                    this.errors.put(classpathManagerArray[n2], (TerminatingClassNotFoundException)object);
                    if (throwErrorOnFailedStart) {
                        this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, (String)object2, 0, bundleException, null));
                        throw object;
                    }
                    this.adaptor.getEventPublisher().publishFrameworkEvent(2, bundle, new BundleException((String)object2, bundleException));
                }
            }
            --n2;
        }
    }

    @Override
    public void preFindLocalResource(String string, ClasspathManager classpathManager) {
    }

    @Override
    public void postFindLocalResource(String string, URL uRL, ClasspathManager classpathManager) {
    }

    @Override
    public void recordClassDefine(String string, Class<?> clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
    }

    private boolean shouldActivateFor(String string, BaseData baseData, EclipseStorageHook eclipseStorageHook, ClasspathManager classpathManager) throws ClassNotFoundException {
        if (!this.isLazyStartable(string, baseData, eclipseStorageHook)) {
            return false;
        }
        if (baseData.getBundle().getState() == 4) {
            TerminatingClassNotFoundException terminatingClassNotFoundException;
            if (throwErrorOnFailedStart && (terminatingClassNotFoundException = this.errors.get(classpathManager)) != null) {
                throw terminatingClassNotFoundException;
            }
            return (baseData.getStatus() & 1) != 0;
        }
        return true;
    }

    private boolean isLazyStartable(String string, BaseData baseData, EclipseStorageHook eclipseStorageHook) {
        if (eclipseStorageHook == null) {
            return false;
        }
        boolean bl = eclipseStorageHook.isLazyStart();
        String[] stringArray = eclipseStorageHook.getLazyStartExcludes();
        String[] stringArray2 = eclipseStorageHook.getLazyStartIncludes();
        if (stringArray == null && stringArray2 == null) {
            return bl;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return bl;
        }
        String string2 = string.substring(0, n);
        if (bl) {
            return !(stringArray2 != null && !this.contains(stringArray2, string2) || stringArray != null && this.contains(stringArray, string2));
        }
        return stringArray != null && this.contains(stringArray, string2);
    }

    private boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingStatsHook(this);
        hookRegistry.addAdaptorHook(this);
    }

    @Override
    public void addProperties(Properties properties) {
    }

    @Override
    public FrameworkLog createFrameworkLog() {
        return null;
    }

    @Override
    public void frameworkStart(BundleContext bundleContext) throws BundleException {
    }

    @Override
    public void frameworkStop(BundleContext bundleContext) throws BundleException {
    }

    @Override
    public void frameworkStopping(BundleContext bundleContext) {
        if (!Debug.DEBUG_ENABLED) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = this.adaptor.getState().getResolvedBundles();
        StateHelper stateHelper = this.adaptor.getPlatformAdmin().getStateHelper();
        Object[][] objectArray = stateHelper.sortBundles(bundleDescriptionArray);
        this.logCycles(objectArray);
    }

    @Override
    public void handleRuntimeError(Throwable throwable) {
    }

    @Override
    public void initialize(BaseAdaptor baseAdaptor) {
        this.adaptor = baseAdaptor;
    }

    @Override
    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    private void logCycles(Object[][] objectArray) {
        if (objectArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("[");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append('[');
                int n2 = 0;
                while (n2 < objectArray[n].length) {
                    stringBuffer.append(((BundleDescription)objectArray[n][n2]).getSymbolicName());
                    stringBuffer.append(',');
                    ++n2;
                }
                stringBuffer.insert(stringBuffer.length() - 1, ']');
                ++n;
            }
            stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
            String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_BUNDLESTOPPER_CYCLES_FOUND, stringBuffer);
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, string, 0, null, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
        }
    }

    private static class TerminatingClassNotFoundException
    extends ClassNotFoundException
    implements StatusException {
        private static final long serialVersionUID = -6730732895632169173L;
        private Object cause;

        public TerminatingClassNotFoundException(String string, Throwable throwable) {
            super(string, throwable);
            this.cause = throwable;
        }

        public Object getStatus() {
            return this.cause;
        }

        public int getStatusCode() {
            return 8;
        }
    }
}

