/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class EclipseErrorHandler
implements AdaptorHook,
HookConfigurator {
    private static final String PROP_EXITONERROR = "eclipse.exitOnError";
    private BaseAdaptor adaptor;

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    private boolean isFatalException(Throwable throwable) {
        if (throwable instanceof VirtualMachineError) {
            return true;
        }
        return throwable instanceof ThreadDeath;
    }

    public void handleRuntimeError(Throwable throwable) {
        boolean bl = false;
        try {
            try {
                bl = Boolean.valueOf(FrameworkProperties.getProperty(PROP_EXITONERROR, "true"));
                String string = EclipseAdaptorMsg.ECLIPSE_ADAPTOR_RUNTIME_ERROR;
                if (bl && this.isFatalException(throwable)) {
                    string = String.valueOf(string) + ' ' + EclipseAdaptorMsg.ECLIPSE_ADAPTOR_EXITING;
                }
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, throwable, null);
                this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            }
            catch (Throwable throwable2) {
                try {
                    throwable.printStackTrace();
                    throwable2.printStackTrace();
                }
                catch (Throwable throwable3) {}
                if (bl && this.isFatalException(throwable)) {
                    System.exit(13);
                }
            }
        }
        finally {
            if (bl && this.isFatalException(throwable)) {
                System.exit(13);
            }
        }
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        this.adaptor = baseAdaptor;
    }
}

