/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.baseadaptor.loader.FragmentClasspath;
import org.eclipse.osgi.framework.util.KeyedElement;

public class ClasspathManifest
implements KeyedElement {
    public static final Object KEY = new Object();
    public static final int HASHCODE = KEY.hashCode();
    private Manifest manifest;
    private boolean initialized = false;

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement keyedElement) {
        return keyedElement.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }

    public synchronized Manifest getManifest(ClasspathEntry classpathEntry, ClasspathManager classpathManager) {
        if (this.initialized) {
            return this.manifest;
        }
        if (!this.hasPackageInfo(classpathEntry, classpathManager)) {
            this.initialized = true;
            this.manifest = null;
            return this.manifest;
        }
        BundleEntry bundleEntry = classpathEntry.getBundleFile().getEntry("META-INF/MANIFEST.MF");
        if (bundleEntry != null) {
            InputStream inputStream = null;
            try {
                try {
                    inputStream = bundleEntry.getInputStream();
                    this.manifest = new Manifest(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {}
        }
        this.initialized = true;
        return this.manifest;
    }

    private boolean hasPackageInfo(ClasspathEntry classpathEntry, ClasspathManager classpathManager) {
        Object object;
        BaseData baseData = null;
        if (classpathEntry.getBundleFile() == classpathManager.getBaseData().getBundleFile()) {
            baseData = classpathManager.getBaseData();
        }
        if (baseData == null && (object = classpathManager.getFragmentClasspaths()) != null) {
            int n = 0;
            while (n < ((FragmentClasspath[])object).length) {
                if (classpathEntry.getBundleFile() == ((FragmentClasspath)object[n]).getBundleData().getBundleFile()) {
                    baseData = ((FragmentClasspath)object[n]).getBundleData();
                    break;
                }
                ++n;
            }
        }
        if (baseData == null) {
            return true;
        }
        object = (EclipseStorageHook)baseData.getStorageHook(EclipseStorageHook.KEY);
        return object == null ? true : ((EclipseStorageHook)object).hasPackageInfo();
    }
}

