/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedManifest
extends Dictionary<String, String> {
    static final String SERVICE_COMPONENT = "Service-Component";
    static boolean DEBUG = false;
    private Dictionary<String, String> manifest = null;
    private EclipseStorageHook storageHook;

    public CachedManifest(EclipseStorageHook eclipseStorageHook) {
        this.storageHook = eclipseStorageHook;
    }

    public Dictionary<String, String> getManifest() {
        if (this.manifest == null) {
            try {
                if (DEBUG) {
                    System.out.println(new StringBuffer("Reading manifest for: ").append(this.storageHook.getBaseData()).toString());
                }
                this.manifest = this.storageHook.createCachedManifest(true);
            }
            catch (BundleException bundleException) {
                String string = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CACHEDMANIFEST_UNEXPECTED_EXCEPTION, this.storageHook.getBaseData().getLocation());
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, bundleException, null);
                this.storageHook.getAdaptor().getFrameworkLog().log(frameworkLogEntry);
            }
        }
        if (this.manifest == null) {
            Headers<String, String> headers = new Headers<String, String>(0);
            headers.setReadOnly();
            this.manifest = headers;
            return headers;
        }
        return this.manifest;
    }

    @Override
    public int size() {
        return this.getManifest().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Enumeration<String> elements() {
        return this.getManifest().elements();
    }

    @Override
    public Enumeration<String> keys() {
        return this.getManifest().keys();
    }

    @Override
    public String get(Object object) {
        String[] stringArray;
        Object object2;
        if (this.manifest != null) {
            return this.manifest.get(object);
        }
        String string = (String)object;
        if ("Bundle-Version".equalsIgnoreCase(string)) {
            Version version = this.storageHook.getBaseData().getVersion();
            return version == null ? null : version.toString();
        }
        if ("Plugin-Class".equalsIgnoreCase(string)) {
            return this.storageHook.getPluginClass();
        }
        if ("Bundle-SymbolicName".equalsIgnoreCase(string)) {
            if ((this.storageHook.getBaseData().getType() & 8) == 0) {
                return this.storageHook.getBaseData().getSymbolicName();
            }
            return new StringBuffer(String.valueOf(this.storageHook.getBaseData().getSymbolicName())).append(';').append("singleton").append(":=true").toString();
        }
        if ("Eclipse-BuddyPolicy".equalsIgnoreCase(string)) {
            return this.storageHook.getBuddyList();
        }
        if ("Eclipse-RegisterBuddy".equalsIgnoreCase(string)) {
            return this.storageHook.getRegisteredBuddyList();
        }
        if ("Bundle-Activator".equalsIgnoreCase(string)) {
            return this.storageHook.getBaseData().getActivator();
        }
        if ("Bundle-ActivationPolicy".equals(string)) {
            int n;
            if (!this.storageHook.isAutoStartable()) {
                return null;
            }
            object2 = this.storageHook.getLazyStartExcludes();
            stringArray = this.storageHook.getLazyStartIncludes();
            if (object2 == null && stringArray == null) {
                return "lazy";
            }
            StringBuffer stringBuffer = new StringBuffer("lazy");
            if (object2 != null) {
                stringBuffer.append(';').append("exclude").append(":=\"");
                n = 0;
                while (n < ((Object)object2).length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append((String)object2[n]);
                    ++n;
                }
                stringBuffer.append("\"");
            }
            if (stringArray != null) {
                stringBuffer.append(';').append("include").append(":=\"");
                n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(stringArray[n]);
                    ++n;
                }
                stringBuffer.append("\"");
            }
        }
        if ("Eclipse-LazyStart".equals(string) || "Eclipse-AutoStart".equals(string)) {
            if (!this.storageHook.isAutoStartable()) {
                return null;
            }
            if (this.storageHook.getLazyStartExcludes() == null) {
                return Boolean.TRUE.toString();
            }
            object2 = new StringBuffer(this.storageHook.isLazyStart() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            ((StringBuffer)object2).append(";").append("exceptions").append("=\"");
            stringArray = this.storageHook.getLazyStartExcludes();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    ((StringBuffer)object2).append(",");
                }
                ((StringBuffer)object2).append(stringArray[n]);
                ++n;
            }
            ((StringBuffer)object2).append("\"");
            return ((StringBuffer)object2).toString();
        }
        if ("Bundle-ManifestVersion".equals(string)) {
            return this.storageHook.getBundleManifestVersion() == 0 ? null : Integer.toString(this.storageHook.getBundleManifestVersion());
        }
        if (SERVICE_COMPONENT.equals(string)) {
            return this.storageHook.getServiceComponent();
        }
        object2 = this.getManifest();
        if (DEBUG) {
            System.out.println(new StringBuffer("Manifest read because of header: ").append(object).toString());
        }
        return object2 == null ? null : (String)((Dictionary)object2).get(object);
    }

    @Override
    public String remove(Object object) {
        return this.getManifest().remove(object);
    }

    @Override
    public String put(String string, String string2) {
        return this.getManifest().put(string, string2);
    }
}

