/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PasswordUtility {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String DELIMITER = "{E}";
    private static final String SALT_DELIMITER = "{S}";
    private static final SecureRandom random = new SecureRandom();
    private static final int ITERATIONS = 500;

    public static boolean isPasswordCorrect(String string, byte[] byArray) {
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            String string2 = new String(byArray, CHARSET);
            int n = string2.indexOf(SALT_DELIMITER);
            byte[] byArray2 = bASE64Decoder.decodeBuffer(string2.substring(0, n));
            byte[] byArray3 = bASE64Decoder.decodeBuffer(string2.substring(n + SALT_DELIMITER.length(), string2.indexOf(DELIMITER)));
            return Arrays.equals(byArray3, PasswordUtility.getHashedPassword(string, byArray2));
        }
        catch (Exception exception) {
            System.err.println("Reading password hash failed" + exception);
            return false;
        }
    }

    public static String getRoleInHash(byte[] byArray) {
        String string = new String(byArray, CHARSET);
        int n = string.indexOf(DELIMITER);
        return string.substring(n + DELIMITER.length());
    }

    public static byte[] encryptPassword(String string, String string2) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        byte[] byArray = new byte[8];
        random.nextBytes(byArray);
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(bASE64Encoder.encode(byArray));
        stringBuilder.append(SALT_DELIMITER);
        byte[] byArray2 = PasswordUtility.getHashedPassword(string, byArray);
        stringBuilder.append(bASE64Encoder.encode(byArray2));
        stringBuilder.append(DELIMITER);
        stringBuilder.append(string2);
        return stringBuilder.toString().getBytes(CHARSET);
    }

    private static byte[] getHashedPassword(String string, byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.reset();
            messageDigest.update(byArray);
            messageDigest.update(string.getBytes());
            byte[] byArray2 = messageDigest.digest();
            int n = 0;
            while (n < 500) {
                messageDigest.reset();
                messageDigest.update(byArray2);
                byArray2 = messageDigest.digest();
                ++n;
            }
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Could not find hashing algorithm" + noSuchAlgorithmException);
            return null;
        }
    }

    public static byte[] calcSMD5(byte[] byArray, byte[] byArray2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new byte[0];
        }
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        byte[] byArray3 = messageDigest.digest();
        byte[] byArray4 = new byte[byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        byte[] byArray5 = bASE64Encoder.encode(byArray4).getBytes(CHARSET);
        return byArray5;
    }
}

