/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.logging.ALogger;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Locale;

public class OSUtils {
    private static final java.lang.management.OperatingSystemMXBean osManagment = ManagementFactory.getOperatingSystemMXBean();
    private static final long MB = 0x100000L;
    private static long availableMemory;

    public static long getAvailableComputerMemory() {
        if (availableMemory != 0L) {
            return availableMemory / 0x100000L;
        }
        if (osManagment instanceof OperatingSystemMXBean) {
            long l = ((OperatingSystemMXBean)osManagment).getTotalPhysicalMemorySize();
            return l / 0x100000L;
        }
        return -1L;
    }

    public static long getFreeComputerMemory() {
        if (osManagment instanceof OperatingSystemMXBean) {
            long l = ((OperatingSystemMXBean)osManagment).getFreePhysicalMemorySize();
            return l / 0x100000L;
        }
        return -1L;
    }

    public static final boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("win");
    }

    @Deprecated
    public static double getSystemLoadAverage() {
        return osManagment.getSystemLoadAverage();
    }

    public static void setAvailableMemory(long l) {
        availableMemory = l;
        ALogger.getLogger(OSUtils.class).info("Computer memory: " + OSUtils.getFreeComputerMemory() + " / " + OSUtils.getAvailableComputerMemory() + " MByte");
    }
}

