/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.util.IFileServiceData;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.LoginSessionFactory;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.StreamUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FileServiceUtil {
    private static final String SPACE_STRING = " ";
    private static final String HTTP_SPACE_PLACEHOLDER = "%20";
    private static final ALogger log = ALogger.getLogger(FileServiceUtil.class);
    public static final String PARAMETER_ACTION = "action";
    protected final String serviceUrl = FileServiceUtil.getFileServiceUrl();
    private final String scope;
    private boolean serviceable = true;

    public FileServiceUtil(String string) {
        this.scope = string;
        if (Product.isInOfflineModus() || Product.isInEmergencyMode()) {
            this.serviceable = false;
        }
    }

    public boolean isServiceable() throws Exception {
        if (Product.isInOfflineModus() || Product.isInEmergencyMode()) {
            return false;
        }
        InputStream inputStream = this.makeHttpGETRequest(this.createParameterString(Actions.GET_COUNT, null, null));
        byte[] byArray = StreamUtil.readStreamSimple((InputStream)inputStream);
        if (byArray != null && byArray.length > 0) {
            return true;
        }
        throw new Exception("Checking " + this.scope + " serviceability failed!");
    }

    public boolean isDataAvailable(String string, String string2) throws Exception {
        InputStream inputStream = this.makeHttpGETRequest(this.createParameterString(Actions.GET_COUNT, string, string2));
        byte[] byArray = StreamUtil.readStreamSimple((InputStream)inputStream);
        if (byArray != null && byArray.length > 0) {
            return Integer.parseInt(new String(byArray)) > 0;
        }
        throw new Exception("Checking " + this.scope + " data availability failed!");
    }

    public Collection<String> getFileNames(String string, String string2) throws Exception {
        if (!this.serviceable) {
            return Collections.emptyList();
        }
        InputStream inputStream = this.makeHttpGETRequest(this.createParameterString(Actions.GET_NAMES, string, string2));
        ArrayList<String> arrayList = new ArrayList<String>();
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            while (dataInputStream.available() > 0) {
                arrayList.add(dataInputStream.readUTF());
            }
        }
        return arrayList;
    }

    public InputStream getDataStream(String string, String string2) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(this.getResponseStream(string, string2));
        dataInputStream.readUTF();
        return dataInputStream;
    }

    protected InputStream getResponseStream(String string, String string2) throws Exception {
        return this.makeHttpGETRequest(this.createParameterString(Actions.GET, string, string2));
    }

    public void saveData(IFileServiceData iFileServiceData, boolean bl, boolean bl2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.createParameterString(Actions.SAVE, iFileServiceData.getUserId(), null));
        stringBuilder.append("&override=");
        stringBuilder.append(bl);
        stringBuilder.append("&exclusive=");
        stringBuilder.append(bl2);
        InputStream inputStream = this.makeHttpPOSTRequest(stringBuilder.toString(), iFileServiceData);
        if (inputStream == null) {
            throw new Exception("Saving " + this.scope + " data failed!");
        }
    }

    public void deleteData(String string) throws Exception {
        this.makeHttpGETRequest(this.createParameterString(Actions.DELETE, string, ".*"));
    }

    public void deleteData(String string, String string2) throws Exception {
        this.makeHttpGETRequest(this.createParameterString(Actions.DELETE, string, string2));
    }

    public static String getFileServiceUrl() {
        return String.valueOf(URLProviderFactory.getProvider().getServerUrl()) + "lta/file";
    }

    private String createParameterString(Actions actions, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("action=");
        stringBuilder.append(actions.toString());
        if (this.scope != null) {
            stringBuilder.append("&scope=");
            stringBuilder.append(this.scope);
        }
        if (string != null) {
            stringBuilder.append("&user-id=");
            stringBuilder.append(string);
        }
        if (string2 != null) {
            stringBuilder.append("&pattern=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private InputStream makeHttpGETRequest(String string) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.openConnection(string, false);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                log.debug("LTA file-service GET message success at URL " + httpURLConnection.getURL().toString());
                return httpURLConnection.getInputStream();
            }
            String string2 = httpURLConnection.getResponseMessage();
            log.error("LTA file-service GET message failed (" + n + ' ' + string2 + ')');
            log.error("Sent parameters were: " + string);
            throw new Exception("LTA file-service GET message failed: Service returned " + n);
        }
        catch (Exception exception) {
            log.error("LTA file-service GET message failed", (Throwable)exception);
            throw exception;
        }
    }

    private InputStream makeHttpPOSTRequest(String string, IFileServiceData iFileServiceData) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.openConnection(string, true);
            iFileServiceData.write(httpURLConnection.getOutputStream());
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                log.debug("LTA file-service POST message success at URL " + httpURLConnection.getURL().toString());
                InputStream inputStream = httpURLConnection.getInputStream();
                return inputStream;
            }
            try {
                String string2 = httpURLConnection.getResponseMessage();
                log.error("LTA file-service POST message failed (" + n + ' ' + string2 + ')');
                log.error("Sent parameters were: " + string);
                throw new Exception("LTA file-service POST message failed: Service returned " + n);
            }
            catch (Exception exception) {
                log.error("LTA file-service POST message failed", (Throwable)exception);
                return null;
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private HttpURLConnection openConnection(String string, boolean bl) throws IOException, ProtocolException {
        String string2 = bl ? "POST" : "GET";
        string = string.replaceAll(SPACE_STRING, HTTP_SPACE_PLACEHOLDER);
        URL uRL = new URL(String.valueOf(this.serviceUrl) + "?" + string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        LoginSessionFactory.getSession().attach(httpURLConnection);
        httpURLConnection.setRequestMethod(string2);
        httpURLConnection.setRequestProperty("content-type", "text/xml");
        httpURLConnection.setDoOutput(bl);
        httpURLConnection.setDoInput(true);
        log.debug("LTA file-service " + string2 + " message attempt [URL: " + uRL.toString() + ']');
        httpURLConnection.connect();
        return httpURLConnection;
    }

    public static enum Actions {
        GET("get"),
        GET_COUNT("get-count"),
        GET_NAMES("get-names"),
        EXIST("exist"),
        DELETE("delete"),
        SAVE("save"),
        GET_TRUSTED("getTrusted"),
        GET_PRIVATE("getPrivate");

        private final String action;

        private Actions(String string2) {
            this.action = string2;
        }

        public String toString() {
            return this.action;
        }
    }
}

