/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.util;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.DicomModalityComparator;
import com.agfa.pacs.base.util.DicomParseException;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.dicom.DicomPropertiesOwner;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeProviderFactory;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataInfoNodeProvider;
import com.agfa.pacs.logging.ALogger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class DicomUtils {
    private static final ALogger log = ALogger.getLogger(DicomUtils.class);
    private static final HashMap<Integer, int[]> nestedDicomTagMap = new HashMap();
    private static final Map<String, String> CHARSET = new HashMap<String, String>();

    static {
        int[][] nArray = DicomCFindConst.SERIES_NESTED_TAGS;
        int n = DicomCFindConst.SERIES_NESTED_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            int[] nArray2 = nArray[n2];
            int n3 = nArray2[nArray2.length - 1];
            nestedDicomTagMap.put(n3, nArray2);
            ++n2;
        }
        int[] nArray3 = new int[3];
        nArray3[0] = 4194933;
        nArray3[2] = 3280947;
        nestedDicomTagMap.put(3280947, nArray3);
        int[] nArray4 = new int[3];
        nArray4[0] = 4194933;
        nArray4[2] = 3280946;
        nestedDicomTagMap.put(3280946, nArray4);
        CHARSET.put("", "US-ASCII");
        CHARSET.put("ISO_IR 100", "ISO-8859-1");
        CHARSET.put("ISO_IR 101", "ISO-8859-2");
        CHARSET.put("ISO_IR 109", "ISO-8859-3");
        CHARSET.put("ISO_IR 110", "ISO-8859-4");
        CHARSET.put("ISO_IR 144", "ISO-8859-5");
        CHARSET.put("ISO_IR 127", "ISO-8859-6");
        CHARSET.put("ISO_IR 126", "ISO-8859-7");
        CHARSET.put("ISO_IR 138", "ISO-8859-8");
        CHARSET.put("ISO_IR 148", "ISO-8859-9");
        CHARSET.put("ISO_IR 13", "JIS_X0201");
        CHARSET.put("ISO_IR 166", "TIS-620");
        CHARSET.put("ISO 2022 IR 6", "US-ASCII");
        CHARSET.put("ISO 2022 IR 100", "ISO-8859-1");
        CHARSET.put("ISO 2022 IR 101", "ISO-8859-2");
        CHARSET.put("ISO 2022 IR 109", "ISO-8859-3");
        CHARSET.put("ISO 2022 IR 110", "ISO-8859-4");
        CHARSET.put("ISO 2022 IR 144", "ISO-8859-5");
        CHARSET.put("ISO 2022 IR 127", "ISO-8859-6");
        CHARSET.put("ISO 2022 IR 126", "ISO-8859-7");
        CHARSET.put("ISO 2022 IR 138", "ISO-8859-8");
        CHARSET.put("ISO 2022 IR 148", "ISO-8859-9");
        CHARSET.put("ISO 2022 IR 13", "JIS_X0201");
        CHARSET.put("ISO 2022 IR 166", "TIS-620");
        CHARSET.put("ISO 2022 IR 87", "JIS0208");
        CHARSET.put("ISO 2022 IR 159", "JIS0212");
        CHARSET.put("ISO 2022 IR 149", "cp949");
        CHARSET.put("ISO_IR 192", "UTF-8");
        CHARSET.put("GB18030", "GB18030");
    }

    public static int[] getFullTagPath(int n) {
        if (nestedDicomTagMap.containsKey(n)) {
            return nestedDicomTagMap.get(n);
        }
        return null;
    }

    public static boolean isSecondaryCapture(Attributes attributes) {
        String string = attributes.getString(524310);
        return UIDUtilities.isType((String)string, (UIDType)UIDType.SecondaryCapture);
    }

    public static boolean isSecondaryCapture(String string) {
        return UIDUtilities.isType((String)string, (UIDType)UIDType.SecondaryCapture);
    }

    public static boolean isSession(IObjectInfo iObjectInfo) {
        if (UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.KeyObject)) {
            Code code = Code.create((Attributes)iObjectInfo.getAttributes(), (int)4235331);
            return code != null && CodeDictionary.TianiKeyObjectSelectionDocumentTitle.Session.getCodeValue().equals(code.getCodeValue());
        }
        return false;
    }

    public static boolean isVideoData(String string) {
        return UIDUtilities.isType((String)string, (UIDType)UIDType.Video);
    }

    public static boolean isUSVolumeData(String string) {
        return UIDUtilities.isType((String)string, (UIDType)UIDType.USVolume);
    }

    public static boolean isVideoData(Attributes attributes) {
        return DicomUtils.isVideoData(attributes.getString(524310));
    }

    public static void putString(Attributes attributes, int n, String string) throws DicomParseException {
        block10: {
            try {
                VR vR = ElementDictionary.vrOf((int)n, null);
                if (vR == VR.PN) {
                    PersonName personName = PersonNameUtilities.parseFromReverseShort(string);
                    attributes.setString(n, vR, personName.toString());
                    break block10;
                }
                if (vR == VR.DA) {
                    Date date = null;
                    try {
                        date = DateTimeUtils.stringShortFormat2Date(string);
                    }
                    catch (ParseException parseException) {
                        date = DateTimeUtils.string2Date(string);
                    }
                    attributes.setDate(n, vR, new Date[]{date});
                    break block10;
                }
                if (vR == VR.DT) {
                    Date date = DateTimeUtils.string2DateTime(string);
                    attributes.setDate(n, vR, new Date[]{date});
                } else if (vR == VR.TM) {
                    Date date = DateTimeUtils.stringMediumFormat2Time(string);
                    attributes.setDate(n, vR, new Date[]{date});
                } else {
                    attributes.setString(n, vR, string);
                }
            }
            catch (ParseException parseException) {
                throw new DicomParseException(parseException.getMessage(), string);
            }
        }
    }

    public static String getString(int[] nArray, Attributes attributes) {
        if (nArray.length == 1) {
            return attributes.getString(nArray[0]);
        }
        if ((attributes = DicomUtils.getNestedDataset(nArray, attributes, false)) == null) {
            return null;
        }
        return attributes.getString(nArray[nArray.length - 1]);
    }

    public static final Attributes getNestedDataset(int[] nArray, Attributes attributes, boolean bl) {
        if (nArray == null || nArray.length == 1) {
            return attributes;
        }
        int n = 0;
        Sequence sequence = null;
        while (n != nArray.length - 1) {
            if (attributes.containsValue(nArray[n])) {
                sequence = attributes.getSequence(nArray[n]);
            } else if (bl) {
                sequence = attributes.newSequence(nArray[n], 1);
            }
            if (sequence == null) {
                return null;
            }
            if (sequence.size() > nArray[n + 1]) {
                attributes = (Attributes)sequence.get(nArray[n + 1]);
            } else if (bl) {
                attributes = new Attributes();
                sequence.add(attributes);
            } else {
                return null;
            }
            n += 2;
            sequence = null;
        }
        return attributes;
    }

    public static String[] getStrings(int[] nArray, Attributes attributes) {
        if ((attributes = DicomUtils.getNestedDataset(nArray, attributes, false)) == null) {
            return null;
        }
        return attributes.getStrings(nArray[nArray.length - 1]);
    }

    public static String getString(Attributes attributes, int n) {
        Object object = DicomUtils.getObject(attributes, n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Date) {
            VR vR = ElementDictionary.vrOf((int)n, null);
            if (vR == VR.DA) {
                return DateTimeUtils.date2String((Date)object);
            }
            if (VR.DT == vR) {
                return DateTimeUtils.dateTime2String((Date)object);
            }
            return DateTimeUtils.time2String((Date)object);
        }
        return object.toString();
    }

    private static Object getObject(Attributes attributes, int n, VR vR) {
        if (!attributes.containsValue(n)) {
            return null;
        }
        if (vR == VR.LO || vR == VR.SH || vR == VR.ST) {
            return attributes.getString(n);
        }
        if (vR == VR.CS) {
            if (n == 524385) {
                return DicomUtils.getModalitiesInStudiesAsString(attributes.getStrings(n), false, false);
            }
            return attributes.getString(n);
        }
        if (vR == VR.PN) {
            try {
                PersonName personName = new PersonName(attributes.getString(n), true);
                return PersonNameUtilities.personNameToHRReverse(personName);
            }
            catch (Exception exception) {
                return attributes.getString(n);
            }
        }
        if (vR == VR.DA || vR == VR.DT || vR == VR.TM) {
            return attributes.getDate(n, null);
        }
        if (vR == VR.SQ) {
            List list = Code.createList((Sequence)attributes.getSequence(n));
            StringBuilder stringBuilder = new StringBuilder();
            for (Code code : list) {
                stringBuilder.append(code.getCodeMeaning()).append(',');
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        if (vR == VR.DS || vR == VR.FL || vR == VR.FD) {
            return attributes.getDouble(n, 0.0);
        }
        if (vR == VR.IS || vR == VR.SL || vR == VR.SS || vR == VR.US || vR == VR.UL) {
            return attributes.getInt(n, 0);
        }
        if (vR == VR.LT || vR == VR.UT || vR == VR.UI || vR == VR.AE || vR == VR.AS) {
            return attributes.getString(n);
        }
        log.warn("Unknown vr:" + vR + " in tag" + n);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getObject(Attributes attributes, int n) {
        Attributes attributes2;
        block6: {
            if (n < 0) {
                return null;
            }
            if (attributes == null) {
                return null;
            }
            if (n == 4390932) {
                return attributes.getString("dcm4che/archive", n);
            }
            int[] nArray = nestedDicomTagMap.get(n);
            try {
                if (nArray == null) return DicomUtils.getObject(attributes, n, ElementDictionary.vrOf((int)n, null));
                attributes2 = DicomUtils.getNestedDataset(nArray, attributes, false);
                if (attributes2 != null) break block6;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Could not parse tag " + TagUtils.toString((int)n));
                return null;
            }
        }
        return DicomUtils.getObject(attributes2, n, ElementDictionary.vrOf((int)n, null));
    }

    public static Object getObject(Attributes attributes, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        Attributes attributes2 = DicomUtils.getNestedDataset(nArray, attributes, false);
        if (attributes2 == null) {
            return null;
        }
        return DicomUtils.getObject(attributes2, nArray[nArray.length - 1], ElementDictionary.vrOf((int)nArray[nArray.length - 1], null));
    }

    public static Class<?> getValueFormatClassForTag(int n) {
        if (n < 0) {
            return null;
        }
        VR vR = ElementDictionary.vrOf((int)n, null);
        if (vR != null) {
            if (vR == VR.AE) {
                return String.class;
            }
            if (vR == VR.AS) {
                return String.class;
            }
            if (vR == VR.CS) {
                return String.class;
            }
            if (vR == VR.DA) {
                return Date.class;
            }
            if (vR == VR.DS) {
                return Double.class;
            }
            if (vR == VR.DT) {
                return Date.class;
            }
            if (vR == VR.FL) {
                return Double.class;
            }
            if (vR == VR.FD) {
                return Double.class;
            }
            if (vR == VR.IS) {
                return Integer.class;
            }
            if (vR == VR.LO) {
                return String.class;
            }
            if (vR == VR.LT) {
                return String.class;
            }
            if (vR == VR.PN) {
                return String.class;
            }
            if (vR == VR.SH) {
                return String.class;
            }
            if (vR == VR.SL) {
                return Integer.class;
            }
            if (vR == VR.SS) {
                return Integer.class;
            }
            if (vR == VR.ST) {
                return String.class;
            }
            if (vR == VR.TM) {
                return Time.class;
            }
            if (vR == VR.UL) {
                return Integer.class;
            }
            if (vR == VR.US) {
                return Integer.class;
            }
            if (vR == VR.UT) {
                return String.class;
            }
            if (vR == VR.UI) {
                return String.class;
            }
            if (vR == VR.SQ) {
                return String.class;
            }
        }
        return null;
    }

    public static String getStandardNameForTag(int n) {
        String string = ElementDictionary.keywordOf((int)n, null);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (bl && Character.isUpperCase(c)) {
                bl = false;
                stringBuffer.append(' ').append(c);
            } else {
                stringBuffer.append(c);
                bl = Character.isLowerCase(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static int getTagFromString(String string) {
        if (string.length() != 11) {
            throw new IllegalArgumentException("Illegal format");
        }
        String string2 = string.substring(1, 5);
        String string3 = string.substring(6, 10);
        int n = Integer.parseInt(string2, 16);
        int n2 = Integer.parseInt(string3, 16);
        return (n << 16) + n2;
    }

    public static IDataInfoNode createDataInfoNode(String string, IDicomNode iDicomNode) throws Exception {
        IDataInfoNodeProvider iDataInfoNodeProvider = DataInfoNodeProviderFactory.getInstance().getDataNodeProvider("AGFADICOMWADO");
        if (iDataInfoNodeProvider != null) {
            DicomPropertiesOwner dicomPropertiesOwner = new DicomPropertiesOwner(iDicomNode);
            Properties properties = dicomPropertiesOwner.properties();
            properties.put("relationalQuery", Boolean.TRUE.toString());
            properties.put("wadoURI", "http://" + iDicomNode.getHost() + ":8080/wado");
            return iDataInfoNodeProvider.createDataNode(string, properties);
        }
        return null;
    }

    public static String getCharsetName(Attributes attributes) {
        String string = attributes.getString(524293);
        try {
            return CHARSET.get(string);
        }
        catch (Exception exception) {
            log.warn("could not get charset name for " + string, (Throwable)exception);
            return null;
        }
    }

    private static String getModalitiesInStudiesAsString(String[] stringArray, boolean bl, boolean bl2) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Arrays.sort(stringArray, new DicomModalityComparator());
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                String string;
                block10: {
                    block9: {
                        string = stringArray2[n2];
                        if (string == null) break block8;
                        if (!string.equals("KO")) break block9;
                        bl3 = true;
                        if (!bl) break block10;
                        break block8;
                    }
                    if (string.equals("PR") ? bl : (string.equals("SR") || string.equals("PDF")) && bl2) break block8;
                }
                stringBuilder.append(string).append(',');
            }
            ++n2;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else if (stringBuilder.length() == 0 && bl3) {
            stringBuilder.append("KO");
        }
        return stringBuilder.toString();
    }

    public static String[] getModalitiesInStudy(IStudyInfo iStudyInfo, boolean bl) {
        List list;
        String[] stringArray = iStudyInfo.getAttributes().getStrings(524385);
        if (stringArray == null && bl && (list = iStudyInfo.getSeries()) != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ISeriesInfo iSeriesInfo : list) {
                String string = iSeriesInfo.getAttributes().getString(524384, null);
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            stringArray = arrayList.toArray(new String[0]);
        }
        return stringArray;
    }

    public static String getModalitiesInStudiesAsString(IStudyInfo iStudyInfo, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = DicomUtils.getModalitiesInStudy(iStudyInfo, bl3);
        return DicomUtils.getModalitiesInStudiesAsString(stringArray, bl, bl2);
    }

    public static String getModalitiesInStudiesAsString(Attributes attributes, boolean bl, boolean bl2) {
        String[] stringArray = attributes.getStrings(524385);
        return DicomUtils.getModalitiesInStudiesAsString(stringArray, bl, bl2);
    }

    public static Collection<String> getExaminedParts(IStudyInfo iStudyInfo) {
        List list = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
        HashSet<String> hashSet = new HashSet<String>();
        for (IDataInfo iDataInfo : list) {
            String string = iDataInfo.getAttributes().getString(1572885, null);
            if (string == null || string.isEmpty()) continue;
            hashSet.add(string.toUpperCase(Locale.getDefault()));
        }
        return hashSet;
    }

    public static PersonName getPersonNameFromFirstSeries(IDataInfo iDataInfo, int n) {
        String string;
        List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, ISeriesInfo.class);
        if (list != null && !list.isEmpty() && (string = ((ISeriesInfo)list.get(0)).getAttributes().getString(n)) != null) {
            return new PersonName(string);
        }
        return null;
    }

    public static String getStringFromFirstSeries(IDataInfo iDataInfo, int n) {
        List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, ISeriesInfo.class);
        ISeriesInfo iSeriesInfo2 = null;
        for (ISeriesInfo iSeriesInfo2 : list) {
            String string = iSeriesInfo2.getString(524384);
            if (string == null || string.equalsIgnoreCase("PDF") || string.equals("SR") || string.equals("KO") || string.equals("PR")) continue;
            return (String)DicomUtils.getObject(iSeriesInfo2.getAttributes(), n);
        }
        return null;
    }

    public class Time
    extends Date {
        private static final long serialVersionUID = 172241262274763636L;
    }
}

