/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic.xml;

import com.agfa.pacs.base.lic.impl.XMLUtils;
import com.agfa.pacs.base.lic.xml.Customer;
import com.agfa.pacs.base.lic.xml.License;
import com.agfa.pacs.base.lic.xml.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;

public class LicensesType {
    protected Customer issuer;
    protected List<License> license;
    protected long serialNumber;
    protected List<String> serverIdentification;

    protected LicensesType(Node node) throws ParseException {
        this.issuer = new Customer(XMLUtils.getSingleChild(node, "issuer"));
        try {
            this.serialNumber = Long.parseLong(XMLUtils.getSingleChildContent(node, "serialNumber"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException);
        }
        List<Node> list = XMLUtils.getChildList(node, "license");
        this.license = new LinkedList<License>();
        for (Node object2 : list) {
            this.license.add(new License(object2));
        }
        List<Node> list2 = XMLUtils.getChildList(node, "serverIdentification");
        this.serverIdentification = new LinkedList<String>();
        for (Object node2 : list2) {
            this.serverIdentification.add(node2.getTextContent().trim());
        }
    }

    public Customer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Customer customer) {
        this.issuer = customer;
    }

    public List<License> getLicense() {
        if (this.license == null) {
            this.license = new ArrayList<License>();
        }
        return Collections.unmodifiableList(this.license);
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public List<String> getServerIdentification() {
        if (this.serverIdentification == null) {
            this.serverIdentification = new ArrayList<String>();
        }
        return this.serverIdentification;
    }
}

