/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic.impl;

import java.io.IOException;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Locale;

public class MACReader {
    public static MACReader getInstance() {
        return new MACReader();
    }

    public static void main(String[] stringArray) throws IOException {
        MACReader mACReader = MACReader.getInstance();
        byte[] byArray = MACReader.getInstance().readMAC();
        if (byArray == null) {
            System.out.println("Failed to read MAC");
            return;
        }
        System.out.println("MAC=" + MACReader.toString(byArray[0]) + ":" + MACReader.toString(byArray[1]) + ":" + MACReader.toString(byArray[2]) + ":" + MACReader.toString(byArray[3]) + ":" + MACReader.toString(byArray[4]) + ":" + MACReader.toString(byArray[5]));
        System.out.println("SHort mac:" + mACReader.getMAC());
    }

    static String toString(byte by) {
        int n = by & 0xFF;
        return String.valueOf(n < 16 ? "0" : "") + Integer.toHexString(n);
    }

    public byte[] readMAC() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    byte[] byArray = networkInterface.getHardwareAddress();
                    String string = networkInterface.getName();
                    if (byArray == null || string == null || string.toUpperCase(Locale.ENGLISH).indexOf("ETH") == -1) continue;
                    return byArray;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public String getMAC() {
        byte[] byArray = this.readMAC();
        if (byArray == null) {
            return "00-00-00-00-00-00";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(MACReader.toString(byArray[n]));
            if (n < 5) {
                stringBuffer.append('-');
            }
            ++n;
        }
        return stringBuffer.toString().toUpperCase(Locale.ENGLISH);
    }
}

