/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.lic.impl;

import com.agfa.pacs.base.lic.impl.LicenseCheckException;
import com.agfa.pacs.base.lic.impl.LicenseChecker;
import com.agfa.pacs.base.lic.xml.Customer;
import com.agfa.pacs.base.lic.xml.License;
import com.agfa.pacs.base.lic.xml.LicenseTicket;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.URLEncodeUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LicenseUtilities {
    private static final ALogger log = ALogger.getLogger(LicenseUtilities.class);
    private static int networkErrorCounter = 0;

    private static boolean issuerEquals(Customer customer, Customer customer2) {
        if (!Objects.equals(customer.getName(), customer2.getName())) {
            return false;
        }
        if (!Objects.equals(customer.getLocation(), customer2.getLocation())) {
            return false;
        }
        return Objects.equals(customer.getCountry(), customer2.getCountry());
    }

    private static boolean licenseEquals(License license, License license2) {
        if (!license.getId().equals(license2.getId())) {
            return false;
        }
        return license.getLimitation().size() == license2.getLimitation().size();
    }

    public static boolean checkLicense(LicenseTicket licenseTicket) {
        if (!LicenseUtilities.issuerEquals(licenseTicket.getIssuer(), licenseTicket.getSource().getLicenses().getIssuer())) {
            return false;
        }
        boolean bl = false;
        for (License object : licenseTicket.getSource().getLicenses().getLicense()) {
            if (!LicenseUtilities.licenseEquals(object, licenseTicket.getLicense())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        try {
            String signatureException = LicenseChecker.getDataForSignature(licenseTicket.getSourceString());
            return LicenseChecker.checkLicense(signatureException, licenseTicket.getSource().getSignature());
        }
        catch (SignatureException licenseCheckException) {
            log.error("Signature error", (Throwable)licenseCheckException);
        }
        catch (LicenseCheckException licenseCheckException) {
            log.error("Signature error", (Throwable)licenseCheckException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return false;
    }

    public static LicenseTicket query(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string == null) {
            return null;
        }
        if (networkErrorCounter >= 2) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("?action=request&product=");
        stringBuilder.append(string2);
        stringBuilder.append('&');
        stringBuilder.append("IP");
        stringBuilder.append('=');
        stringBuilder.append(string3);
        stringBuilder.append('&');
        stringBuilder.append("MAC");
        stringBuilder.append('=');
        stringBuilder.append(string4);
        if (string6 != null) {
            stringBuilder.append('&');
            stringBuilder.append("SESSION");
            stringBuilder.append('=');
            stringBuilder.append(string6);
        }
        stringBuilder.append('&');
        stringBuilder.append("PINGING");
        stringBuilder.append("=true");
        stringBuilder.append('&');
        stringBuilder.append("USER");
        stringBuilder.append('=');
        stringBuilder.append(URLEncodeUtil.encode((String)string7));
        if (string5 != null && string5.length() > 0) {
            string5 = URLEncodeUtil.encode((String)string5);
            stringBuilder.append('&');
            stringBuilder.append("ROLE");
            stringBuilder.append('=');
            stringBuilder.append(string5);
        }
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(stringBuilder.toString());
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                log.warn("No license found code:" + n + "(" + string2 + ")");
                return null;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream(), "UTF8");
            String string8 = StreamUtil.readStream((Reader)inputStreamReader);
            LicenseTicket licenseTicket = new LicenseTicket();
            licenseTicket.setSourceString(string8);
            networkErrorCounter = 0;
            LicenseTicket licenseTicket2 = licenseTicket;
            return licenseTicket2;
        }
        catch (Exception exception) {
            log.error("License error", (Throwable)exception);
            ++networkErrorCounter;
            return null;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static void startPinging(String string, String string2) {
        final String string3 = String.valueOf(string) + "?action=ping&" + "SESSION" + "=" + string2;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(45000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    HttpURLConnection httpURLConnection = null;
                    try {
                        URL uRL = new URL(string3);
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setDoInput(true);
                        httpURLConnection.setDoOutput(false);
                        httpURLConnection.connect();
                        int n = httpURLConnection.getResponseCode();
                        if (n == 200) continue;
                        log.warn("Could not ping:" + n);
                        return;
                    }
                    catch (Exception exception) {
                        log.error("Server communication", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (httpURLConnection == null) continue;
                        httpURLConnection.disconnect();
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("LicensePinging");
        thread.setPriority(1);
        thread.start();
    }

    public static void unregister(String string, String string2, String string3) {
        String string4 = String.valueOf(string) + "?action=unregister&ticket=" + string2;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string4);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                log.warn("Could not unregister:" + n);
                return;
            }
            try {
                log.debug("License unregistered:" + string3);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                log.error("Server communication", (Throwable)iOException);
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static String determineMachine() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return "IMPAX WORKSTATION";
        }
    }

    public static Set<String> querySupported(String string, String string2, String string3) {
        if (string == null) {
            return Collections.emptySet();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("?action=supported&");
        stringBuilder.append("MAC");
        stringBuilder.append('=');
        stringBuilder.append(string2);
        if (string3 != null && string3.length() > 0) {
            string3 = URLEncodeUtil.encode((String)string3);
            stringBuilder.append('&');
            stringBuilder.append("ROLE");
            stringBuilder.append('=');
            stringBuilder.append(string3);
        }
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(stringBuilder.toString());
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                log.info("Query for supported IDs not available");
                Set<String> set = Collections.emptySet();
                return set;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream(), "UTF8");
            String string4 = StreamUtil.readStream((Reader)inputStreamReader);
            if (string4.length() == 0) {
                return null;
            }
            log.info("Supported Licenses:" + string4);
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = string4.split(";");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string5 = stringArray[n3];
                hashSet.add(string5);
                ++n3;
            }
            Set<String> set = Collections.unmodifiableSet(hashSet);
            return set;
        }
        catch (Exception exception) {
            log.error("License error", (Throwable)exception);
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }
}

