/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.undo;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.IEventDispatcher;
import com.agfa.pacs.event.internal.task.TaskCache;
import com.agfa.pacs.event.internal.task.TaskGroup;
import com.agfa.pacs.event.internal.undo.UndoRedoContainer;
import com.agfa.pacs.logging.ALogger;
import java.util.NoSuchElementException;

public class UndoRedoEngine {
    private static final ALogger logger = ALogger.getLogger(UndoRedoEngine.class);
    protected UndoRedoContainer cont;
    protected IEventDispatcher disp;
    protected TaskCache taskCache;

    public UndoRedoEngine(IEventDispatcher iEventDispatcher) {
        int n = (int)ConfigurationProviderFactory.getConfig().getLong("com.agfa.pacs.event.undosteps");
        this.cont = new UndoRedoContainer(n);
        this.disp = iEventDispatcher;
        this.taskCache = TaskCache.instance();
    }

    public synchronized void putTask(TaskGroup taskGroup) {
        if (!taskGroup.event.isUndoable()) {
            this.taskCache.putDelayedTaskGroup(taskGroup);
            return;
        }
        try {
            if (taskGroup.event.getUndoFallThrough() && taskGroup.event.id == this.cont.undoStack.getLast().event.id) {
                this.taskCache.putDelayedTaskGroup(taskGroup);
                return;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("", (Throwable)noSuchElementException);
        }
        if (taskGroup.event.action == ActionInfo.END || taskGroup.event.action == ActionInfo.PROGRESS) {
            this.taskCache.putDelayedTaskGroup(taskGroup);
            return;
        }
        if (taskGroup.id == 0 || taskGroup.id == 1) {
            this.taskCache.putDelayedTaskGroup(taskGroup);
            return;
        }
        this.cont.putTask(taskGroup);
    }

    public synchronized void undo() {
        if (!this.canUndo()) {
            return;
        }
        boolean bl = true;
        while (bl && this.canUndo()) {
            TaskGroup taskGroup = this.cont.undo();
            taskGroup.event = taskGroup.head.next.e;
            taskGroup.event.setUndo(true);
            try {
                logger.debug("UNDO: " + taskGroup.event);
                this.disp.send(taskGroup);
            }
            catch (Throwable throwable) {
                logger.warn("Error during undo()", throwable);
            }
            bl = taskGroup.head.next.e.getUndoFallThrough();
        }
    }

    public boolean canUndo() {
        return this.cont.canUndo();
    }

    public synchronized void redo() {
        if (!this.canRedo()) {
            return;
        }
        boolean bl = true;
        while (bl && this.canRedo()) {
            TaskGroup taskGroup = this.cont.redo();
            taskGroup.event = taskGroup.head.next.e;
            try {
                logger.debug("REDO: " + taskGroup.event);
                this.disp.send(taskGroup);
            }
            catch (Throwable throwable) {
                logger.warn("Error during redo()", throwable);
            }
            bl = taskGroup.head.next.e.getUndoFallThrough();
        }
    }

    public boolean canRedo() {
        return this.cont.canRedo();
    }

    public int getLimit() {
        return this.cont.getLimit();
    }

    public void setLimit(int n) {
        this.cont.setLimit(n);
    }

    public void removeAll() {
        this.cont.removeAll();
    }

    public String toString() {
        return this.cont.toString();
    }
}

