/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.tools;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class FixedQueue<E>
implements Queue<E> {
    protected E[] buf;
    protected int head = 0;
    protected int tail = 0;
    protected int size;
    protected int space;

    public FixedQueue(int n) {
        this.size = n;
        this.buf = new Object[n];
        this.space = n * 2;
    }

    @Override
    public boolean offer(E e) {
        if (this.head - this.tail >= this.size) {
            return false;
        }
        this.buf[this.head % this.size] = e;
        ++this.head;
        if (this.head >= this.space) {
            this.head -= this.size;
            this.tail -= this.size;
        }
        return true;
    }

    @Override
    public E poll() {
        if (this.head != this.tail) {
            ++this.tail;
            return this.buf[(this.tail - 1) % this.size];
        }
        return null;
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        if (this.head != this.tail) {
            return this.buf[this.tail % this.size];
        }
        return null;
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.head - this.tail;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        if (!this.offer(e)) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private class Itr
    implements ListIterator<E> {
        private int ptr;
        private int lastRet;

        Itr() {
            this.ptr = FixedQueue.this.tail;
            this.lastRet = FixedQueue.this.tail;
        }

        @Override
        public boolean hasNext() {
            return this.ptr != FixedQueue.this.head;
        }

        @Override
        public E next() {
            if (this.ptr == FixedQueue.this.head) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.ptr++;
            return FixedQueue.this.buf[(this.ptr - 1) % FixedQueue.this.size];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr != FixedQueue.this.tail;
        }

        @Override
        public E previous() {
            if (this.ptr == FixedQueue.this.tail) {
                throw new NoSuchElementException();
            }
            --this.ptr;
            this.lastRet = this.ptr;
            return FixedQueue.this.buf[this.ptr % FixedQueue.this.size];
        }

        @Override
        public int nextIndex() {
            return this.ptr - FixedQueue.this.tail + 1;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void set(E e) {
            FixedQueue.this.buf[this.lastRet % FixedQueue.this.size] = e;
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

