/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal.registry;

import com.agfa.pacs.event.AsyncEventHookContainer;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IEventListenerProviderRegistry;
import com.agfa.pacs.event.SyncEventHookContainer;
import com.agfa.pacs.event.internal.registry.ElProvNode;
import com.agfa.pacs.event.internal.registry.ElProvTree;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IteratorIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class EventListenerProviderRegistry
implements IEventListenerProviderRegistry,
IEventListenerProvider<IEventListener> {
    private static final ALogger logger = ALogger.getLogger(EventListenerProviderRegistry.class);
    private static final int LOCKING_WAITING_TIME = 2500;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<PathProviderPair> deferredRegistrations = Collections.synchronizedList(new LinkedList());
    private boolean isDeferredRegistrationEnabled = false;
    private SyncEventHookContainer syncHooks;
    private AsyncEventHookContainer asyncHooks;
    protected ElProvTree tree = new ElProvTree();

    public void enableDeferredRegistration() {
        this.isDeferredRegistrationEnabled = true;
    }

    public void disableDeferredRegistration() {
        this.isDeferredRegistrationEnabled = false;
    }

    public Iterator<IEventListener> flushDeferredRegistrations(IEvent iEvent, String string) {
        if (this.deferredRegistrations.isEmpty()) {
            return null;
        }
        if (iEvent.getProvider() != this) {
            return null;
        }
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        this.lock.writeLock().lock();
        try {
            ArrayList<PathProviderPair> arrayList2 = new ArrayList<PathProviderPair>(this.deferredRegistrations);
            for (PathProviderPair pathProviderPair : arrayList2) {
                IEventListenerProvider<IEventListener> iEventListenerProvider = pathProviderPair.prov;
                String string2 = pathProviderPair.path;
                if (this.tree.contains(iEventListenerProvider)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Flushing deferred registration: Path: %s, Provider: %s", string2, iEventListenerProvider));
                }
                this.tree.register(iEventListenerProvider, string2);
                if (string2 != null && string != null && !string.startsWith(string2) && !string2.startsWith(string)) continue;
                String string3 = "";
                if (string != null) {
                    if (string2 != null) {
                        if (string2.length() < string.length()) {
                            string3 = string.substring(string2.length() + 1);
                        }
                    } else {
                        string3 = string;
                    }
                }
                arrayList.add(pathProviderPair.prov.iterator(iEvent, string3));
            }
            this.deferredRegistrations.removeAll(arrayList2);
            this.disableDeferredRegistration();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return new IteratorIterator(arrayList.iterator());
    }

    public void flushDeferredRegistrations() {
        if (this.deferredRegistrations.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            ArrayList<PathProviderPair> arrayList = new ArrayList<PathProviderPair>(this.deferredRegistrations);
            for (PathProviderPair pathProviderPair : arrayList) {
                IEventListenerProvider<IEventListener> iEventListenerProvider = pathProviderPair.prov;
                String string = pathProviderPair.path;
                if (this.tree.contains(iEventListenerProvider)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Flushing deferred registration: Path: %s, Provider: %s", string, iEventListenerProvider));
                }
                this.tree.register(iEventListenerProvider, string);
            }
            this.deferredRegistrations.removeAll(arrayList);
            this.disableDeferredRegistration();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void verifyPath(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("no zero length prefix");
        }
        if (string.indexOf(46) == 0) {
            throw new IllegalArgumentException("no prefix starting with '.' allowed");
        }
        if (string.indexOf("..") >= 0) {
            throw new IllegalArgumentException("no '..' in prefix allowed");
        }
        if (string.lastIndexOf(46) == string.length() - 1) {
            throw new IllegalArgumentException("no prefix ending with '.' allowed");
        }
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public boolean register(IEventListenerProvider<IEventListener> iEventListenerProvider, String string) {
        if (this.syncHooks != null) {
            this.syncHooks.registerProvider(iEventListenerProvider, string);
        }
        if (this.asyncHooks != null) {
            this.asyncHooks.registerProvider(iEventListenerProvider, string);
        }
        this.verifyPath(string);
        if (this.isDeferredRegistrationEnabled) {
            this.deferredRegistrations.add(new PathProviderPair(string, iEventListenerProvider));
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Deferred registration: Path: %s, Provider: %s", string, iEventListenerProvider));
            }
            return true;
        }
        boolean bl = false;
        try {
            try {
                bl = this.lock.writeLock().tryLock(2500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                logger.error("Interrupted drung write lock acquisition", (Throwable)interruptedException);
            }
            if (!bl) {
                PathProviderPair pathProviderPair = new PathProviderPair(string, iEventListenerProvider);
                this.deferredRegistrations.add(pathProviderPair);
                logger.warn(String.format("Deferred registration because of locking timeout: %s", pathProviderPair));
                return true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Registration: Path: %s, Provider: %s", string, iEventListenerProvider));
            }
            boolean bl2 = this.tree.register(iEventListenerProvider, string);
            return bl2;
        }
        finally {
            if (bl) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public boolean unregister(IEventListenerProvider<?> iEventListenerProvider) {
        if (this.syncHooks != null) {
            this.syncHooks.unregisterProvider(iEventListenerProvider, null);
        }
        if (this.asyncHooks != null) {
            this.asyncHooks.unregisterProvider(iEventListenerProvider, null);
        }
        this.lock.writeLock().lock();
        try {
            boolean bl = this.tree.unregister(iEventListenerProvider);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean unregister(String string) {
        if (this.syncHooks != null) {
            this.syncHooks.unregisterProvider(null, string);
        }
        if (this.asyncHooks != null) {
            this.asyncHooks.unregisterProvider(null, string);
        }
        this.lock.writeLock().lock();
        try {
            boolean bl = this.tree.unregister(string);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean contains(IEventListenerProvider<IEventListener> iEventListenerProvider) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.tree.contains(iEventListenerProvider);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public IEventListenerProvider<IEventListener> getGroup(String string, boolean bl) {
        ElProvNode elProvNode = this.tree.getNode(string);
        if (elProvNode == null && bl) {
            elProvNode = new ElProvNode(string);
        }
        return elProvNode;
    }

    public Iterator<IEventListener> iterator() {
        return this.tree.iterator();
    }

    public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
        this.verifyPath(string);
        return this.tree.iterator(iEvent, string);
    }

    public int size() {
        return this.tree.inverseLookup.size();
    }

    public String getContent() {
        return this.tree.getContent();
    }

    public String toString() {
        return this.tree.getContent();
    }

    public boolean register(IEventListenerProvider<IEventListener> iEventListenerProvider, String string, boolean bl) {
        boolean bl2;
        if (!bl) {
            bl2 = this.register(iEventListenerProvider, string);
        } else {
            this.enableDeferredRegistration();
            bl2 = this.register(iEventListenerProvider, string);
            this.disableDeferredRegistration();
        }
        return bl2;
    }

    public void setSynchronousEventHooks(SyncEventHookContainer syncEventHookContainer) {
        this.syncHooks = syncEventHookContainer;
    }

    public void setAsynchronousEventHooks(AsyncEventHookContainer asyncEventHookContainer) {
        this.asyncHooks = asyncEventHookContainer;
    }

    protected static class PathProviderPair {
        public String path;
        public IEventListenerProvider<IEventListener> prov;

        public PathProviderPair(String string, IEventListenerProvider<IEventListener> iEventListenerProvider) {
            this.path = string;
            this.prov = iEventListenerProvider;
        }

        public String toString() {
            return String.format("PathProviderPair(%s,%s)", this.path, this.prov);
        }
    }
}

