/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.internal;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventContext;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.context.EventPropagatedContext;
import com.agfa.pacs.event.internal.EventDictionary;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.tools.EventEngineSemaphore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class Event
implements IEvent {
    private static final long serialVersionUID = 3257847696936219700L;
    public static final int UNDO_MASK = 1;
    public static final int REMOTE_DISPATCH_MASK = 2;
    public static final int UNDO_FALLTHROUGH_MASK = 4;
    public static final int SCRIPTABLE_MASK = 8;
    public static final int UNDOABLE_MASK = 16;
    public static final int INTERNAL_MASK = 24;
    public static final AtomicLong uidGenerator = new AtomicLong(0L);
    public final long uid = uidGenerator.incrementAndGet();
    public int id;
    public IEventListenerProvider<? extends IEventListener> eDestination;
    public Object eSource;
    public Object payload;
    public ActionInfo action;
    public long timestamp;
    public Transfer transfer;
    private short flags;
    public String extDestination;
    public EventEngineSemaphore syncSem;
    public int stackDepth;
    public String remoteHandshake;
    private IEventContext context;
    public EventPropagatedContext senderLocalContext;

    public Event(Event event) {
        this.id = event.id;
        this.eDestination = event.eDestination;
        this.eSource = event.eSource;
        this.payload = event.payload;
        this.action = event.action;
        this.timestamp = event.timestamp;
        this.transfer = event.transfer;
        this.flags = event.flags;
        this.extDestination = event.extDestination;
        this.syncSem = event.syncSem;
        this.stackDepth = event.stackDepth;
        this.remoteHandshake = event.remoteHandshake;
    }

    public Event(int n, boolean bl, boolean bl2) {
        this.id = n;
        this.eDestination = null;
        this.eSource = null;
        this.payload = null;
        this.action = ActionInfo.SINGLE;
        this.transfer = Transfer.NORMAL;
        this.flags = 0;
        this.flags = (short)(this.flags | (bl ? 16 : 0));
        this.flags = (short)(this.flags | (bl2 ? 8 : 0));
        this.flags = (short)(this.flags | 2);
    }

    public Event(int n, IEventListenerProvider<? extends IEventListener> iEventListenerProvider, Object object, Serializable serializable, ActionInfo actionInfo, boolean bl, boolean bl2) {
        this.id = n;
        this.eDestination = iEventListenerProvider;
        this.eSource = object;
        this.payload = serializable;
        this.action = actionInfo;
        this.transfer = Transfer.NORMAL;
        this.flags = 0;
        this.flags = (short)(this.flags | (bl ? 16 : 0));
        this.flags = (short)(this.flags | (bl2 ? 8 : 0));
        this.flags = (short)(this.flags | 2);
    }

    public long getUID() {
        return this.uid;
    }

    public final void setDestination(IEventListenerProvider<? extends IEventListener> iEventListenerProvider) {
        this.eDestination = iEventListenerProvider;
    }

    public final void setDestination(IEventListenerProvider<? extends IEventListener> iEventListenerProvider, String string) {
        this.eDestination = iEventListenerProvider;
        this.extDestination = string;
    }

    public final IEventListenerProvider<? extends IEventListener> getProvider() {
        return this.eDestination;
    }

    public final void setSource(Object object) {
        this.eSource = object;
    }

    public final Object getSource() {
        return this.eSource;
    }

    public final void setPayload(Object object) {
        this.payload = object;
    }

    public final Object getPayload() {
        return this.payload;
    }

    public final void setEventID(int n) {
        this.id = n;
    }

    public final int getEventID() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(EventDictionary.getInstance().resolveName(this.id)) + " - " + new Date(this.timestamp) + " - " + this.action + " - " + this.transfer + " - " + this.extDestination;
    }

    public final void setActionInfo(ActionInfo actionInfo) {
        if (actionInfo != null) {
            this.action = actionInfo;
        }
    }

    public final ActionInfo getActionInfo() {
        return this.action;
    }

    public boolean isInternal() {
        return (this.flags & 0x18) == 0;
    }

    public final void setRemoteDispatch(boolean bl) {
        this.flags = bl ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    public final boolean getRemoteDispatch() {
        return (this.flags & 2) == 2;
    }

    public final void setUndoFallThrough(boolean bl) {
        this.flags = bl ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    public final boolean getUndoFallThrough() {
        return (this.flags & 4) == 4;
    }

    public final void setUndo(boolean bl) {
        this.flags = bl ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    public final boolean isUndoEvent() {
        return (this.flags & 1) == 1;
    }

    public final void setScriptable(boolean bl) {
        this.flags = bl ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    public final boolean isScriptable() {
        return (this.flags & 8) == 8;
    }

    public final boolean isUndoable() {
        return (this.flags & 0x10) == 16;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.timestamp = objectInputStream.readLong();
        objectInputStream.readChar();
        this.id = EventDictionary.getInstance().getEventID(objectInputStream.readUTF(), null, null);
        objectInputStream.readChar();
        this.action = (ActionInfo)objectInputStream.readObject();
        objectInputStream.readChar();
        this.transfer = (Transfer)objectInputStream.readObject();
        objectInputStream.readChar();
        this.eDestination = (IEventListenerProvider)objectInputStream.readObject();
        objectInputStream.readChar();
        this.extDestination = (String)objectInputStream.readObject();
        objectInputStream.readChar();
        this.payload = (Serializable)objectInputStream.readObject();
        objectInputStream.readChar();
        this.remoteHandshake = (String)objectInputStream.readObject();
        this.flags = (short)(this.flags & 0xFFFFFFE7);
        this.flags = (short)(this.flags & 0xFFFFFFFE);
        this.eSource = null;
        if (this.transfer == Transfer.EXCLUSIVE) {
            this.syncSem = new EventEngineSemaphore();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.timestamp);
        objectOutputStream.writeChar(32);
        objectOutputStream.writeUTF(EventDictionary.getInstance().resolveName(this.id));
        objectOutputStream.writeChar(32);
        objectOutputStream.writeObject(this.action);
        objectOutputStream.writeChar(32);
        objectOutputStream.writeObject(this.transfer);
        objectOutputStream.writeChar(32);
        if (this.eDestination instanceof Serializable) {
            objectOutputStream.writeObject(this.eDestination);
        } else {
            objectOutputStream.writeObject(null);
        }
        objectOutputStream.writeChar(32);
        objectOutputStream.writeObject(this.extDestination);
        objectOutputStream.writeChar(32);
        objectOutputStream.writeObject(this.payload);
        objectOutputStream.writeChar(32);
        objectOutputStream.writeObject(this.remoteHandshake);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isSerializable() {
        return this.payload == null || this.payload instanceof Serializable;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public void setTimeStamp(long l) {
        this.timestamp = l;
    }

    public void setContext(IEventContext iEventContext) {
        if (this.context != null) {
            throw new IllegalStateException("The event's context has already been set.");
        }
        this.context = iEventContext;
    }

    public IEventContext getContext() {
        return this.context;
    }
}

