/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventHook;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.internal.listener.ListenerProviderInstance;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;

public class SyncEventHookContainer
extends ArrayList<IEventHook> {
    private static final ALogger logger = ALogger.getLogger(SyncEventHookContainer.class);

    public void handle(IEvent iEvent) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                ((IEventHook)this.get(n2)).handle(iEvent);
            }
            catch (Throwable throwable) {
                logger.warn("Error while handling event.", throwable);
            }
            ++n2;
        }
    }

    public void registerEventID(String string, int n) {
        for (IEventHook iEventHook : this) {
            try {
                iEventHook.registerEventID(string, n);
            }
            catch (Throwable throwable) {
                logger.warn("Error while registering event ID.", throwable);
            }
        }
    }

    public void registerProvider(IEventListenerProvider<?> iEventListenerProvider, String string) {
        for (IEventHook iEventHook : this) {
            try {
                iEventHook.registerProvider(iEventListenerProvider, string);
            }
            catch (Throwable throwable) {
                logger.warn("Error while registering provider.", throwable);
            }
        }
    }

    public void unregisterProvider(IEventListenerProvider<?> iEventListenerProvider, String string) {
        for (IEventHook iEventHook : this) {
            try {
                iEventHook.unregisterProvider(iEventListenerProvider, string);
            }
            catch (Throwable throwable) {
                logger.warn("Error while unregistering provider.", throwable);
            }
        }
    }

    public IEventListenerProvider<IEventListener> getEventListenerProvider() {
        ArrayList<IEventListener> arrayList = new ArrayList<IEventListener>();
        for (IEventHook iEventHook : this) {
            IEventListener iEventListener = iEventHook.getEventListener();
            if (iEventListener == null) continue;
            arrayList.add(iEventListener);
        }
        if (arrayList.size() > 0) {
            return new ListenerProviderInstance(arrayList);
        }
        return null;
    }
}

