/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.AsyncEventHookContainer;
import com.agfa.pacs.event.EventHookContainerFactory;
import com.agfa.pacs.event.IEventHook;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.SyncEventHookContainer;
import com.agfa.pacs.event.internal.lazy.LazyListenerProvider;
import com.agfa.pacs.event.internal.listener.ListenerProviderInstance;
import com.agfa.pacs.logging.ALogger;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EventHookContainerFactoryEclipseImpl
extends EventHookContainerFactory {
    private static final ALogger LOGGER = ALogger.getLogger(EventHookContainerFactoryEclipseImpl.class);

    public EventHookContainerFactoryEclipseImpl() {
        this.collectSyncExtensions();
        this.collectAsyncExtensions();
        this.collectSingeltonExtensions();
        this.collectProviderExtensions();
    }

    protected void collectSyncExtensions() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.event.SyncEventHook");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        syncEventHooks = new SyncEventHookContainer();
        if (iExtensionArray == null) {
            return;
        }
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                LOGGER.debug("sync hook loaded: " + iExtension.getUniqueIdentifier());
                syncEventHooks.add((IEventHook)iConfigurationElementArray[0].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {
                LOGGER.warn("Error during SyncExtension collection.", (Throwable)coreException);
            }
            ++n2;
        }
    }

    protected void collectAsyncExtensions() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.event.AsyncEventHook");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        asyncEventHooks = new AsyncEventHookContainer();
        if (iExtensionArray == null) {
            return;
        }
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                LOGGER.debug("async hook loaded: " + iExtension.getUniqueIdentifier());
                asyncEventHooks.add((IEventListener)iConfigurationElementArray[0].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {
                LOGGER.warn("Error during AsyncExtension collection.", (Throwable)coreException);
            }
            ++n2;
        }
    }

    protected void collectSingeltonExtensions() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.core.shared.EventListenerSingelton");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        singleEventListener = new Vector();
        if (iExtensionArray == null) {
            return;
        }
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                boolean bl = Boolean.parseBoolean(iConfigurationElementArray[0].getAttribute("lazy"));
                String string = iConfigurationElementArray[0].getAttribute("path");
                if (bl) {
                    singleEventListener.add(new EventHookContainerFactory.RegisterInfo(new LazyListenerProvider(iConfigurationElementArray[0]), string));
                } else {
                    singleEventListener.add(new EventHookContainerFactory.RegisterInfo(new ListenerProviderInstance((IEventListener)iConfigurationElementArray[0].createExecutableExtension("class")), string));
                }
            }
            catch (CoreException coreException) {
                LOGGER.warn("Error during SingeltonExtension collection.", (Throwable)coreException);
            }
            ++n2;
        }
    }

    protected void collectProviderExtensions() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.core.shared.EventListenerProviderSingelton");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        singleEventListenerProvider = new Vector();
        if (iExtensionArray == null) {
            return;
        }
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                String string = iConfigurationElementArray[0].getAttribute("path");
                singleEventListenerProvider.add(new EventHookContainerFactory.RegisterInfo((IEventListenerProvider<IEventListener>)((IEventListenerProvider)iConfigurationElementArray[0].createExecutableExtension("class")), string));
            }
            catch (CoreException coreException) {
                LOGGER.warn("Error during ProviderExtension collection.", (Throwable)coreException);
            }
            ++n2;
        }
    }
}

