/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.event.AsyncEventHookContainer;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventHookContainerFactory;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.SyncEventHookContainer;
import java.util.List;

public abstract class EventHookContainerFactory
implements IEventHookContainerFactory {
    private static IEventHookContainerFactory implementation;
    protected static SyncEventHookContainer syncEventHooks;
    protected static AsyncEventHookContainer asyncEventHooks;
    protected static List<RegisterInfo> singleEventListener;
    protected static List<RegisterInfo> singleEventListenerProvider;

    public static synchronized SyncEventHookContainer getSynchronHooks() {
        if (implementation == null) {
            EventHookContainerFactory.initialize();
        }
        return implementation.getSyncEventHooksInt();
    }

    public static synchronized AsyncEventHookContainer getAsynchronHooks() {
        if (implementation == null) {
            EventHookContainerFactory.initialize();
        }
        return implementation.getAsyncEventHooksInt();
    }

    public static synchronized void registerSingleEventListener(IEventEngine iEventEngine) {
        if (implementation == null) {
            EventHookContainerFactory.initialize();
        }
        implementation.registerSingleEventListenerInt(iEventEngine);
    }

    public static synchronized void registerSingleEventListenerProvider(IEventEngine iEventEngine) {
        if (implementation == null) {
            EventHookContainerFactory.initialize();
        }
        implementation.registerSingleEventListenerProviderInt(iEventEngine);
    }

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)EventHookContainerFactory.class.getName()));
            implementation = (IEventHookContainerFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + EventHookContainerFactory.class.getName(), reflectiveOperationException);
        }
    }

    @Override
    public SyncEventHookContainer getSyncEventHooksInt() {
        return syncEventHooks;
    }

    @Override
    public AsyncEventHookContainer getAsyncEventHooksInt() {
        return asyncEventHooks;
    }

    @Override
    public void registerSingleEventListenerInt(IEventEngine iEventEngine) {
        if (singleEventListener == null) {
            return;
        }
        int n = 0;
        while (n < singleEventListener.size()) {
            iEventEngine.register(singleEventListener.get(n).getProvider(), EventHookContainerFactory.singleEventListener.get((int)n).path);
            ++n;
        }
    }

    @Override
    public void registerSingleEventListenerProviderInt(IEventEngine iEventEngine) {
        if (singleEventListenerProvider == null) {
            return;
        }
        int n = 0;
        while (n < singleEventListenerProvider.size()) {
            iEventEngine.register(singleEventListenerProvider.get(n).getProvider(), EventHookContainerFactory.singleEventListenerProvider.get((int)n).path);
            ++n;
        }
    }

    public static class RegisterInfo {
        public String path;
        private IEventListenerProvider<IEventListener> prov;

        public RegisterInfo(IEventListenerProvider<IEventListener> iEventListenerProvider, String string) {
            this.path = string;
            this.prov = iEventListenerProvider;
        }

        public IEventListenerProvider<IEventListener> getProvider() {
            return this.prov;
        }
    }
}

