/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventHook;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.EmptyIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AsyncEventHookContainer
extends ArrayList<IEventListener>
implements IEventListenerProvider<IEventListener> {
    private static final ALogger LOGGER = ALogger.getLogger(AsyncEventHookContainer.class);
    private long takeTicketIntern = 0L;
    private long takeTicketExtern = 0L;
    private transient CachedIterator cached = new CachedIterator();

    public void setTicket(long l) {
        this.takeTicketExtern = l;
    }

    @Override
    public Iterator<IEventListener> iterator() {
        if (this.takeTicketIntern >= this.takeTicketExtern) {
            return EmptyIterator.getInstance();
        }
        ++this.takeTicketIntern;
        if (this.cached.isUsed) {
            return super.iterator();
        }
        this.cached.reset();
        return this.cached;
    }

    public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
        return this.iterator();
    }

    public void registerEventID(String string, int n) {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            try {
                IEventListener iEventListener = (IEventListener)iterator.next();
                if (!(iEventListener instanceof IEventHook)) continue;
                ((IEventHook)iEventListener).registerEventID(string, n);
            }
            catch (Throwable throwable) {
                LOGGER.error("", throwable);
            }
        }
    }

    public void registerProvider(IEventListenerProvider<?> iEventListenerProvider, String string) {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            try {
                IEventListener iEventListener = (IEventListener)iterator.next();
                if (!(iEventListener instanceof IEventHook)) continue;
                ((IEventHook)iEventListener).registerProvider(iEventListenerProvider, string);
            }
            catch (Throwable throwable) {
                LOGGER.error("", throwable);
            }
        }
    }

    public void unregisterProvider(IEventListenerProvider<?> iEventListenerProvider, String string) {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            try {
                IEventListener iEventListener = (IEventListener)iterator.next();
                if (!(iEventListener instanceof IEventHook)) continue;
                ((IEventHook)iEventListener).unregisterProvider(iEventListenerProvider, string);
            }
            catch (Throwable throwable) {
                LOGGER.error("", throwable);
            }
        }
    }

    protected final class CachedIterator
    implements Iterator<IEventListener> {
        private int myIdx = 0;
        public boolean isUsed = false;

        protected CachedIterator() {
        }

        public void reset() {
            ((AsyncEventHookContainer)AsyncEventHookContainer.this).cached.isUsed = true;
            this.myIdx = 0;
        }

        @Override
        public final boolean hasNext() {
            this.isUsed = this.myIdx < AsyncEventHookContainer.this.size();
            return this.isUsed;
        }

        @Override
        public final IEventListener next() {
            try {
                return (IEventListener)AsyncEventHookContainer.this.get(this.myIdx++);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                LOGGER.warn("AsyncEventHookContainer: exp");
                throw new NoSuchElementException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

