/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicom.modifier;

import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomCStoreSCU;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCStoreSCU;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.listtext.dicom.modifier.dataset.IModificationObject;
import com.agfa.pacs.logging.ALogger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;

public class CStoreDicomModifier {
    private static final ALogger log = ALogger.getLogger(CStoreDicomModifier.class);
    private final Object sync = new Object();
    private final IDicomNode dicomNode;
    private DicomCStoreSCU cstore;
    protected ProgressState state = null;

    public CStoreDicomModifier(IDicomNode iDicomNode) {
        this.dicomNode = iDicomNode;
    }

    public void store(IModificationObject iModificationObject) throws Exception {
        this.store(Collections.singletonList(iModificationObject));
    }

    public void store(Collection<IModificationObject> collection) throws Exception {
        this.store(collection, null);
    }

    public void store(Collection<IModificationObject> collection, ProgressState progressState) throws Exception {
        Exception exception;
        block18: {
            if (collection == null) {
                return;
            }
            exception = null;
            try {
                try {
                    log.info("Performing dicom c-store with " + collection.size() + " modification datasets...");
                    if (progressState != null) {
                        progressState.setState(JobState.STARTED);
                    }
                    if (!collection.isEmpty()) {
                        this.checkConnection(this.getClassUIDs(collection));
                        int n = collection.size();
                        int n2 = 0;
                        for (IModificationObject iModificationObject : collection) {
                            ++n2;
                            if (progressState != null) {
                                if (progressState.isCanceled()) break;
                                progressState.setState(JobState.PROGRESSING);
                            }
                            try {
                                String string;
                                Attributes attributes = iModificationObject.toDataset();
                                if (log.isDebugEnabled()) {
                                    log.debug("Performing dicom c-store of modification dataset: " + iModificationObject.getSOPInstanceUID());
                                    log.debug(attributes.toString());
                                }
                                String string2 = iModificationObject.getTransferSyntaxUID();
                                String string3 = iModificationObject.getSOPClassUID();
                                String string4 = iModificationObject.getSOPInstanceUID();
                                UIDMap uIDMap = this.cstore.getSupportedUIDs();
                                Set set = uIDMap.getTransferSyntaxUIDs(string3);
                                String string5 = string = set != null ? this.selectTransferSyntaxUID(new HashSet<String>(set), string2) : null;
                                if (string == null) {
                                    string = "1.2.840.10008.1.2";
                                    log.warn("Unable to make transfer-syntax agreement: Using the default ... " + string);
                                }
                                if (progressState != null) {
                                    progressState.setProgress((float)n / (float)n2);
                                }
                                this.cstore.store(string3, string4, string, (DataWriter)new DataWriterAdapter(attributes));
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Finished dicom c-store of modification dataset: " + iModificationObject.getSOPInstanceUID());
                            }
                            catch (Exception exception2) {
                                log.error("Error in dicom c-store of modification dataset: " + iModificationObject.getSOPInstanceUID(), (Throwable)exception2);
                                exception = exception2;
                            }
                        }
                    }
                    if (progressState != null) {
                        progressState.setState(JobState.FINISHED);
                    }
                }
                catch (Exception exception3) {
                    log.error("Performing dicom c-store of modification dataset(s) failed!", (Throwable)exception3);
                    exception = exception3;
                    if (progressState != null) {
                        progressState.setState(JobState.FAILED);
                    }
                    this.releaseConnection();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection();
                throw throwable;
            }
            this.releaseConnection();
        }
        if (exception != null) {
            throw new Exception("Performing dicom c-store of modification dataset(s) failed!", exception);
        }
    }

    private Collection<String> getClassUIDs(Collection<IModificationObject> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IModificationObject iModificationObject : collection) {
            hashSet.add(iModificationObject.getSOPClassUID());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnection(Collection<String> collection) throws DicomException {
        Object object = this.sync;
        synchronized (object) {
            if (this.cstore == null) {
                this.cstore = new DicomCompositeCStoreSCU(this.dicomNode, collection);
            }
            if (!this.cstore.isConnected()) {
                this.cstore.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.dicomNode.isEnabled(NodeProperty.KeepAlive) && this.cstore != null) {
                try {
                    this.cstore.close();
                }
                catch (DicomException dicomException) {
                    log.error("close", (Throwable)dicomException);
                }
            }
        }
    }

    protected String selectTransferSyntaxUID(Set<String> set, String string) {
        return UIDUtilities.selectTransferSyntaxUID(set, (String)string);
    }
}

