/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MultiRule
implements ISchedulingRule {
    private ISchedulingRule[] rules;

    public static ISchedulingRule combine(ISchedulingRule[] iSchedulingRuleArray) {
        ISchedulingRule iSchedulingRule = null;
        int n = 0;
        while (n < iSchedulingRuleArray.length) {
            if (iSchedulingRuleArray[n] != null) {
                iSchedulingRule = iSchedulingRule == null ? iSchedulingRuleArray[n] : MultiRule.combine(iSchedulingRule, iSchedulingRuleArray[n]);
            }
            ++n;
        }
        return iSchedulingRule;
    }

    public static ISchedulingRule combine(ISchedulingRule iSchedulingRule, ISchedulingRule iSchedulingRule2) {
        if (iSchedulingRule == iSchedulingRule2) {
            return iSchedulingRule;
        }
        if (iSchedulingRule == null) {
            return iSchedulingRule2;
        }
        if (iSchedulingRule2 == null) {
            return iSchedulingRule;
        }
        if (iSchedulingRule.contains(iSchedulingRule2)) {
            return iSchedulingRule;
        }
        if (iSchedulingRule2.contains(iSchedulingRule)) {
            return iSchedulingRule2;
        }
        MultiRule multiRule = new MultiRule();
        multiRule.rules = new ISchedulingRule[]{iSchedulingRule, iSchedulingRule2};
        if (iSchedulingRule instanceof MultiRule || iSchedulingRule2 instanceof MultiRule) {
            multiRule.rules = MultiRule.flatten(multiRule.rules);
        }
        return multiRule;
    }

    private static ISchedulingRule[] flatten(ISchedulingRule[] iSchedulingRuleArray) {
        ArrayList<ISchedulingRule> arrayList = new ArrayList<ISchedulingRule>(iSchedulingRuleArray.length);
        int n = 0;
        while (n < iSchedulingRuleArray.length) {
            if (iSchedulingRuleArray[n] instanceof MultiRule) {
                ISchedulingRule[] iSchedulingRuleArray2 = ((MultiRule)iSchedulingRuleArray[n]).getChildren();
                int n2 = 0;
                while (n2 < iSchedulingRuleArray2.length) {
                    arrayList.add(iSchedulingRuleArray2[n2]);
                    ++n2;
                }
            } else {
                arrayList.add(iSchedulingRuleArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ISchedulingRule[arrayList.size()]);
    }

    public MultiRule(ISchedulingRule[] iSchedulingRuleArray) {
        this.rules = MultiRule.flatten(iSchedulingRuleArray);
    }

    private MultiRule() {
    }

    public ISchedulingRule[] getChildren() {
        return (ISchedulingRule[])this.rules.clone();
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        if (this == iSchedulingRule) {
            return true;
        }
        if (iSchedulingRule instanceof MultiRule) {
            ISchedulingRule[] iSchedulingRuleArray = ((MultiRule)iSchedulingRule).getChildren();
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                boolean bl = false;
                int n2 = 0;
                while (!bl && n2 < this.rules.length) {
                    bl = this.rules[n2].contains(iSchedulingRuleArray[n]);
                    ++n2;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        int n = 0;
        while (n < this.rules.length) {
            if (this.rules[n].contains(iSchedulingRule)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        if (this == iSchedulingRule) {
            return true;
        }
        if (iSchedulingRule instanceof MultiRule) {
            ISchedulingRule[] iSchedulingRuleArray = ((MultiRule)iSchedulingRule).getChildren();
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                int n2 = 0;
                while (n2 < this.rules.length) {
                    if (this.rules[n2].isConflicting(iSchedulingRuleArray[n])) {
                        return true;
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.rules.length) {
                if (this.rules[n].isConflicting(iSchedulingRule)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MultiRule[");
        int n = this.rules.length - 1;
        int n2 = 0;
        while (n2 < this.rules.length) {
            stringBuffer.append(this.rules[n2]);
            if (n2 != n) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

