/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

class WorkerPool {
    private static final int BEST_BEFORE = 60000;
    private static final int MIN_THREADS = 1;
    private int busyThreads = 0;
    protected final ClassLoader defaultContextLoader;
    private boolean isDaemon = false;
    private JobManager manager;
    private int numThreads = 0;
    private int sleepingThreads = 0;
    private Worker[] threads = new Worker[10];

    protected WorkerPool(JobManager jobManager) {
        this.manager = jobManager;
        this.defaultContextLoader = Thread.currentThread().getContextClassLoader();
    }

    private synchronized void add(Worker worker) {
        int n = this.threads.length;
        if (this.numThreads + 1 > n) {
            Worker[] workerArray = new Worker[2 * n];
            System.arraycopy(this.threads, 0, workerArray, 0, n);
            this.threads = workerArray;
        }
        this.threads[this.numThreads++] = worker;
    }

    private synchronized void decrementBusyThreads() {
        if (--this.busyThreads < 0) {
            if (JobManager.DEBUG) {
                Assert.isTrue((boolean)false, (String)Integer.toString(this.busyThreads));
            }
            this.busyThreads = 0;
        }
    }

    protected void endJob(InternalJob internalJob, IStatus iStatus) {
        try {
            if (internalJob.getRule() != null && !(internalJob instanceof ThreadJob)) {
                this.manager.getLockManager().removeLockCompletely(Thread.currentThread(), internalJob.getRule());
            }
            this.manager.endJob(internalJob, iStatus, true);
            this.manager.implicitJobs.endJob(internalJob);
        }
        finally {
            this.decrementBusyThreads();
        }
    }

    protected synchronized void endWorker(Worker worker) {
        if (this.remove(worker) && JobManager.DEBUG) {
            JobManager.debug("worker removed from pool: " + worker);
        }
    }

    private synchronized void incrementBusyThreads() {
        if (++this.busyThreads > this.numThreads) {
            if (JobManager.DEBUG) {
                Assert.isTrue((boolean)false, (String)(String.valueOf(Integer.toString(this.busyThreads)) + ',' + this.numThreads));
            }
            this.busyThreads = this.numThreads;
        }
    }

    protected synchronized void jobQueued() {
        if (this.sleepingThreads > 0) {
            this.notify();
            return;
        }
        if (this.busyThreads >= this.numThreads) {
            Worker worker = new Worker(this);
            worker.setDaemon(this.isDaemon);
            this.add(worker);
            if (JobManager.DEBUG) {
                JobManager.debug("worker added to pool: " + worker);
            }
            worker.start();
            return;
        }
    }

    private synchronized boolean remove(Worker worker) {
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] == worker) {
                System.arraycopy(this.threads, n + 1, this.threads, n, this.numThreads - n - 1);
                this.threads[--this.numThreads] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    void setDaemon(boolean bl) {
        this.isDaemon = bl;
    }

    protected synchronized void shutdown() {
        this.notifyAll();
    }

    private synchronized void sleep(long l) {
        ++this.sleepingThreads;
        --this.busyThreads;
        if (JobManager.DEBUG) {
            JobManager.debug("worker sleeping for: " + l + "ms");
        }
        try {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                if (JobManager.DEBUG) {
                    JobManager.debug("worker interrupted while waiting... :-|");
                }
                --this.sleepingThreads;
                ++this.busyThreads;
            }
        }
        finally {
            --this.sleepingThreads;
            ++this.busyThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InternalJob startJob(Worker worker) {
        Object object = this;
        synchronized (object) {
            if (!this.manager.isActive()) {
                this.endWorker(worker);
                return null;
            }
            this.incrementBusyThreads();
        }
        object = null;
        try {
            object = this.manager.startJob();
            long l = System.currentTimeMillis();
            while (this.manager.isActive() && object == null) {
                long l2 = this.manager.sleepHint();
                if (l2 > 0L) {
                    this.sleep(Math.min(l2, 60000L));
                }
                object = this.manager.startJob();
                WorkerPool workerPool = this;
                synchronized (workerPool) {
                    if (object == null && System.currentTimeMillis() - l > 60000L && this.numThreads - this.busyThreads > 1) {
                        this.endWorker(worker);
                        return null;
                    }
                }
                if (l2 > 0L || object != null) continue;
                this.sleep(50L);
            }
            if (object == null) return object;
            if (((Job)object).getRule() != null && !(object instanceof ThreadJob)) {
                this.manager.getLockManager().addLockThread(Thread.currentThread(), ((Job)object).getRule());
            }
            if (this.manager.sleepHint() > 0L) return object;
            this.jobQueued();
            return object;
        }
        finally {
            if (object == null) {
                this.decrementBusyThreads();
            }
        }
    }
}

