/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ThreadJob
extends Job {
    protected boolean acquireRule = false;
    boolean isBlocked = false;
    protected boolean isRunning = false;
    private RuntimeException lastPush = null;
    protected Job realJob;
    private ISchedulingRule[] ruleStack;
    private int top;
    boolean isWaiting;

    ThreadJob(ISchedulingRule iSchedulingRule) {
        super("Implicit Job");
        this.setSystem(true);
        this.internalSetPriority(10);
        this.ruleStack = new ISchedulingRule[2];
        this.top = -1;
        this.internalSetRule(iSchedulingRule);
    }

    boolean isResumingAfterYield() {
        return false;
    }

    private void illegalPop(ISchedulingRule iSchedulingRule) {
        StringBuffer stringBuffer = new StringBuffer("Attempted to endRule: ");
        stringBuffer.append(iSchedulingRule);
        if (this.top >= 0 && this.top < this.ruleStack.length) {
            stringBuffer.append(", does not match most recent begin: ");
            stringBuffer.append(this.ruleStack[this.top]);
        } else if (this.top < 0) {
            stringBuffer.append(", but there was no matching beginRule");
        } else {
            stringBuffer.append(", but the rule stack was out of bounds: " + this.top);
        }
        stringBuffer.append(".  See log for trace information if rule tracing is enabled.");
        String string = stringBuffer.toString();
        if (JobManager.DEBUG || JobManager.DEBUG_BEGIN_END) {
            System.out.println(string);
            RuntimeException runtimeException = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
            Status status = new Status(4, "org.eclipse.core.jobs", 1, string, (Throwable)runtimeException);
            RuntimeLog.log((IStatus)status);
        }
        Assert.isLegal((boolean)false, (String)string);
    }

    private void illegalPush(ISchedulingRule iSchedulingRule, ISchedulingRule iSchedulingRule2) {
        StringBuffer stringBuffer = new StringBuffer("Attempted to beginRule: ");
        stringBuffer.append(iSchedulingRule);
        stringBuffer.append(", does not match outer scope rule: ");
        stringBuffer.append(iSchedulingRule2);
        String string = stringBuffer.toString();
        if (JobManager.DEBUG) {
            System.out.println(string);
            Status status = new Status(4, "org.eclipse.core.jobs", 1, string, (Throwable)new IllegalArgumentException());
            RuntimeLog.log((IStatus)status);
        }
        Assert.isLegal((boolean)false, (String)string);
    }

    private static boolean isCanceled(IProgressMonitor iProgressMonitor) {
        try {
            return iProgressMonitor.isCanceled();
        }
        catch (RuntimeException runtimeException) {
            Status status = new Status(4, "org.eclipse.core.jobs", 2, "ThreadJob.isCanceled", (Throwable)runtimeException);
            RuntimeLog.log((IStatus)status);
            return false;
        }
    }

    synchronized boolean isRunning() {
        return this.isRunning;
    }

    static ThreadJob joinRun(ThreadJob threadJob, IProgressMonitor iProgressMonitor) {
        if (ThreadJob.isCanceled(iProgressMonitor)) {
            throw new OperationCanceledException();
        }
        InternalJob internalJob = manager.findBlockingJob(threadJob);
        Thread thread = internalJob == null ? null : internalJob.getThread();
        try {
            if (manager.getLockManager().aboutToWait(thread)) {
                ThreadJob threadJob2 = threadJob;
                return threadJob2;
            }
            ThreadJob threadJob3 = ThreadJob.waitForRun(threadJob, iProgressMonitor, internalJob, thread);
            return threadJob3;
        }
        finally {
            manager.getLockManager().aboutToRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadJob waitForRun(ThreadJob threadJob, IProgressMonitor iProgressMonitor, InternalJob internalJob, Thread thread) {
        ThreadJob threadJob2;
        Thread thread2;
        boolean bl = manager.getLockManager().canBlock();
        ThreadJob threadJob3 = threadJob;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            ThreadJob.waitStart(threadJob, iProgressMonitor, internalJob);
            ThreadJob.manager.implicitJobs.addWaiting(threadJob);
            bl3 = true;
            if (bl) {
                manager.beginMonitoring(threadJob, iProgressMonitor);
            }
            thread2 = Thread.currentThread();
            while (true) {
                if (ThreadJob.isCanceled(iProgressMonitor)) {
                    throw new OperationCanceledException();
                }
                internalJob = manager.runNow(threadJob, true);
                if (internalJob != null) break block28;
                bl3 = false;
                threadJob2 = threadJob;
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                ThreadJob.waitEnd(threadJob, threadJob == threadJob3, iProgressMonitor);
                break;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
            ThreadJob.waitEnd(threadJob, threadJob == threadJob3, iProgressMonitor);
            if (threadJob == threadJob3 && bl3) {
                ThreadJob.manager.implicitJobs.removeWaiting(threadJob);
            }
            if (bl) {
                manager.endMonitoring(threadJob);
            }
            throw throwable;
        }
        {
            block30: {
                block29: {
                    block28: {
                        if (threadJob == threadJob3 && bl3) {
                            ThreadJob.manager.implicitJobs.removeWaiting(threadJob);
                        }
                        if (bl) {
                            manager.endMonitoring(threadJob);
                        }
                        return threadJob2;
                    }
                    Thread thread3 = thread = internalJob == null ? null : internalJob.getThread();
                    if (thread != thread2 || !(internalJob instanceof ThreadJob)) break block29;
                    threadJob3 = (ThreadJob)internalJob;
                    threadJob3.push(threadJob.getRule());
                    threadJob3.isBlocked = threadJob.isBlocked;
                    ThreadJob threadJob4 = threadJob3;
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                    ThreadJob.waitEnd(threadJob, threadJob == threadJob3, iProgressMonitor);
                    if (threadJob == threadJob3 && bl3) {
                        ThreadJob.manager.implicitJobs.removeWaiting(threadJob);
                    }
                    if (bl) {
                        manager.endMonitoring(threadJob);
                    }
                    return threadJob4;
                }
                if (!manager.getLockManager().aboutToWait(thread)) break block30;
                ThreadJob threadJob5 = threadJob;
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                ThreadJob.waitEnd(threadJob, threadJob == threadJob3, iProgressMonitor);
                if (threadJob == threadJob3 && bl3) {
                    ThreadJob.manager.implicitJobs.removeWaiting(threadJob);
                }
                if (bl) {
                    manager.endMonitoring(threadJob);
                }
                return threadJob5;
            }
            manager.getLockManager().addLockWaitThread(thread2, threadJob.getRule());
            Object object = internalJob.jobStateLock;
            synchronized (object) {
                try {
                    int n = internalJob.getState();
                    if (n == 4 && bl) {
                        internalJob.jobStateLock.wait();
                    } else if (n != 0) {
                        internalJob.jobStateLock.wait(250L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            manager.getLockManager().removeLockWaitThread(thread2, threadJob.getRule());
            continue;
        }
    }

    boolean pop(ISchedulingRule iSchedulingRule) {
        if (this.top < 0 || this.ruleStack[this.top] != iSchedulingRule) {
            this.illegalPop(iSchedulingRule);
        }
        this.ruleStack[this.top--] = null;
        return this.top < 0;
    }

    void push(ISchedulingRule iSchedulingRule) {
        ISchedulingRule iSchedulingRule2 = this.getRule();
        if (++this.top >= this.ruleStack.length) {
            ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.ruleStack.length * 2];
            System.arraycopy(this.ruleStack, 0, iSchedulingRuleArray, 0, this.ruleStack.length);
            this.ruleStack = iSchedulingRuleArray;
        }
        this.ruleStack[this.top] = iSchedulingRule;
        if (JobManager.DEBUG_BEGIN_END) {
            this.lastPush = (RuntimeException)new RuntimeException().fillInStackTrace();
        }
        if (iSchedulingRule2 != null && iSchedulingRule != null && !iSchedulingRule2.contains(iSchedulingRule)) {
            this.illegalPush(iSchedulingRule, iSchedulingRule2);
        }
    }

    boolean recycle() {
        if (this.getState() != 0) {
            return false;
        }
        this.isBlocked = false;
        this.isRunning = false;
        this.acquireRule = false;
        this.realJob = null;
        this.setRule(null);
        this.setThread(null);
        if (this.ruleStack.length != 2) {
            this.ruleStack = new ISchedulingRule[2];
        } else {
            this.ruleStack[1] = null;
            this.ruleStack[0] = null;
        }
        this.top = -1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor iProgressMonitor) {
        ThreadJob threadJob = this;
        synchronized (threadJob) {
            this.isRunning = true;
        }
        return ASYNC_FINISH;
    }

    void setRealJob(Job job) {
        this.realJob = job;
    }

    boolean shouldInterrupt() {
        return this.realJob == null ? true : !this.realJob.isSystem();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ThreadJob");
        stringBuffer.append('(').append(this.realJob).append(',').append(this.getRuleStack()).append(')');
        return stringBuffer.toString();
    }

    String getRuleStack() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = 0;
        while (n <= this.top && n < this.ruleStack.length) {
            stringBuffer.append(this.ruleStack[n]).append(',');
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static void waitEnd(ThreadJob threadJob, boolean bl, IProgressMonitor iProgressMonitor) {
        if (bl) {
            LockManager lockManager = manager.getLockManager();
            Thread thread = Thread.currentThread();
            if (threadJob.isRunning()) {
                lockManager.addLockThread(thread, threadJob.getRule());
                lockManager.resumeSuspendedLocks(thread);
            } else {
                lockManager.removeLockWaitThread(thread, threadJob.getRule());
            }
        }
        if (threadJob.isBlocked) {
            threadJob.isBlocked = false;
            manager.reportUnblocked(iProgressMonitor);
        }
    }

    private static void waitStart(ThreadJob threadJob, IProgressMonitor iProgressMonitor, InternalJob internalJob) {
        threadJob.isBlocked = true;
        manager.reportBlocked(iProgressMonitor, internalJob);
    }

    public boolean shouldSchedule() {
        return false;
    }
}

