/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ImplicitJobs {
    private ThreadJob jobCache = null;
    protected JobManager manager;
    private final Set suspendedRules = new HashSet(20);
    private final Map threadJobs = new HashMap(20);

    ImplicitJobs(JobManager jobManager) {
        this.manager = jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor, boolean bl) {
        Object object;
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Begin rule: " + iSchedulingRule);
        }
        Thread thread = Thread.currentThread();
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            threadJob = (ThreadJob)this.threadJobs.get(thread);
            if (threadJob != null) {
                threadJob.push(iSchedulingRule);
                return;
            }
            if (iSchedulingRule == null) {
                return;
            }
            object = this.manager.currentJob();
            if (object != null && ((Job)object).getRule() != null) {
                threadJob = this.newThreadJob(((Job)object).getRule());
            } else {
                threadJob = this.newThreadJob(iSchedulingRule);
                threadJob.acquireRule = true;
            }
            if (this.isSuspended(iSchedulingRule)) {
                threadJob.acquireRule = false;
            }
            threadJob.setRealJob((Job)object);
            threadJob.setThread(thread);
        }
        try {
            threadJob.push(iSchedulingRule);
            if (threadJob.acquireRule) {
                if (this.manager.runNow(threadJob, false) == null) {
                    this.manager.getLockManager().addLockThread(Thread.currentThread(), iSchedulingRule);
                } else {
                    threadJob = ThreadJob.joinRun(threadJob, iProgressMonitor);
                }
            }
        }
        catch (Throwable throwable) {
            object = this;
            synchronized (object) {
                this.threadJobs.put(thread, threadJob);
                if (bl) {
                    this.suspendedRules.add(iSchedulingRule);
                }
            }
            throw throwable;
        }
        object = this;
        synchronized (object) {
            this.threadJobs.put(thread, threadJob);
            if (bl) {
                this.suspendedRules.add(iSchedulingRule);
            }
        }
    }

    synchronized void end(ISchedulingRule iSchedulingRule, boolean bl) {
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("End rule: " + iSchedulingRule);
        }
        if ((threadJob = (ThreadJob)this.threadJobs.get(Thread.currentThread())) == null) {
            Assert.isLegal((iSchedulingRule == null ? 1 : 0) != 0, (String)("endRule without matching beginRule: " + iSchedulingRule));
        } else if (threadJob.pop(iSchedulingRule)) {
            this.endThreadJob(threadJob, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endJob(InternalJob internalJob) {
        Status status;
        Thread thread = Thread.currentThread();
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            ThreadJob threadJob = (ThreadJob)this.threadJobs.get(thread);
            if (threadJob == null) {
                if (internalJob.getRule() != null) {
                    this.notifyWaitingThreadJobs(internalJob);
                }
                return;
            }
            String string = "Worker thread ended job: " + internalJob + ", but still holds rule: " + threadJob;
            status = new Status(4, "org.eclipse.core.jobs", 1, string, null);
            this.endThreadJob(threadJob, false);
        }
        try {
            RuntimeLog.log((IStatus)status);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(status.getMessage());
        }
    }

    private void endThreadJob(ThreadJob threadJob, boolean bl) {
        Thread thread = Thread.currentThread();
        this.threadJobs.remove(thread);
        ISchedulingRule iSchedulingRule = threadJob.getRule();
        if (bl && iSchedulingRule != null) {
            this.suspendedRules.remove(iSchedulingRule);
        }
        if (threadJob.acquireRule) {
            this.manager.getLockManager().removeLockThread(thread, iSchedulingRule);
            this.notifyWaitingThreadJobs(threadJob);
        }
        if (threadJob.isRunning()) {
            this.manager.endJob(threadJob, Status.OK_STATUS, false);
        }
        this.recycle(threadJob);
    }

    private boolean isSuspended(ISchedulingRule iSchedulingRule) {
        if (this.suspendedRules.size() == 0) {
            return false;
        }
        Iterator iterator = this.suspendedRules.iterator();
        while (iterator.hasNext()) {
            if (!((ISchedulingRule)iterator.next()).contains(iSchedulingRule)) continue;
            return true;
        }
        return false;
    }

    private ThreadJob newThreadJob(ISchedulingRule iSchedulingRule) {
        if (this.jobCache != null) {
            ThreadJob threadJob = this.jobCache;
            threadJob.internalSetRule(iSchedulingRule);
            threadJob.isRunning = false;
            threadJob.acquireRule = false;
            threadJob.realJob = null;
            this.jobCache = null;
            return threadJob;
        }
        return new ThreadJob(iSchedulingRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyWaitingThreadJobs(InternalJob internalJob) {
        Object object = internalJob.jobStateLock;
        synchronized (object) {
            internalJob.jobStateLock.notifyAll();
        }
    }

    private void recycle(ThreadJob threadJob) {
        if (this.jobCache == null && threadJob.recycle()) {
            this.jobCache = threadJob;
        }
    }

    void resume(ISchedulingRule iSchedulingRule) {
        this.end(iSchedulingRule, true);
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Resume rule: " + iSchedulingRule);
        }
    }

    void suspend(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) {
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Suspend rule: " + iSchedulingRule);
        }
        this.begin(iSchedulingRule, iProgressMonitor, true);
    }

    synchronized void transfer(ISchedulingRule iSchedulingRule, Thread thread) {
        if (iSchedulingRule == null) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        if (thread2 == thread) {
            return;
        }
        ThreadJob threadJob = (ThreadJob)this.threadJobs.get(thread);
        Assert.isLegal((threadJob == null ? 1 : 0) != 0, (String)"Transfer rule to job that already owns a rule");
        ThreadJob threadJob2 = (ThreadJob)this.threadJobs.get(thread2);
        Assert.isNotNull((Object)threadJob2, (String)"transferRule without beginRule");
        Assert.isLegal((threadJob2.getRule() == iSchedulingRule ? 1 : 0) != 0, (String)("transferred rule " + iSchedulingRule + " does not match beginRule: " + threadJob2.getRule()));
        threadJob2.setThread(thread);
        this.threadJobs.remove(thread2);
        this.threadJobs.put(thread, threadJob2);
        if (threadJob2.acquireRule) {
            this.manager.getLockManager().removeLockThread(thread2, iSchedulingRule);
            this.manager.getLockManager().addLockThread(thread, iSchedulingRule);
        }
        this.notifyWaitingThreadJobs(threadJob2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeWaiting(ThreadJob threadJob) {
        Object object = threadJob.jobStateLock;
        synchronized (object) {
            threadJob.isWaiting = false;
            this.notifyWaitingThreadJobs(threadJob);
            threadJob.setWaitQueueStamp(-1L);
        }
        this.manager.dequeue(this.manager.waitingThreadJobs, threadJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addWaiting(ThreadJob threadJob) {
        Object object = threadJob.jobStateLock;
        synchronized (object) {
            threadJob.isWaiting = true;
            this.notifyWaitingThreadJobs(threadJob);
            threadJob.setWaitQueueStamp(this.manager.waitQueueCounter.increment());
        }
        this.manager.enqueue(this.manager.waitingThreadJobs, threadJob);
    }

    synchronized ThreadJob getThreadJob(Thread thread) {
        return (ThreadJob)this.threadJobs.get(thread);
    }
}

