/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.util.referencedobject.IUnresolvedReferencedObjectHandler;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.listtext.lta.util.referencedobject.UnresolvedReferencedObjectHandlerFactory;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class UnresolvedReferencedObjectsUtil {
    private static final IUnresolvedReferencedObjectHandler HANDLER = UnresolvedReferencedObjectHandlerFactory.getInstance();

    private UnresolvedReferencedObjectsUtil() {
    }

    static boolean isUnresolvedReferencedObjectsAcceptable(ReferringObject referringObject, int n, Collection<ReferencedSOP> collection, boolean bl) {
        if (HANDLER != null && bl) {
            String string = UnresolvedReferencedObjectsUtil.createErrorMessage(referringObject, n, collection);
            return HANDLER.isUnresolvedReferencedObjectsAcceptable(string, referringObject.getType(), n, collection);
        }
        return false;
    }

    private static String createErrorMessage(ReferringObject referringObject, int n, Collection<ReferencedSOP> collection) {
        String string;
        String string2;
        int n2 = collection.size();
        int n3 = n + n2;
        if (referringObject.getType() == ReferringObjectType.SESSION) {
            string2 = "UnresolvedReferencedObjects.ErrorMessage.Session.";
            string = UnresolvedReferencedObjectsUtil.getSessionName(referringObject.getObject());
        } else {
            string2 = "UnresolvedReferencedObjects.ErrorMessage.KeyObject.";
            string = UnresolvedReferencedObjectsUtil.getKeyObjectName(referringObject);
        }
        String string3 = n2 < n3 ? "Incomplete" : "Unloadable";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format(Messages.getString(String.valueOf(string2) + "Message1." + string3), string));
        stringBuilder.append("\n\n");
        stringBuilder.append(Messages.getString("UnresolvedReferencedObjects.ErrorMessage.Cause"));
        stringBuilder.append(": ");
        stringBuilder.append(MessageFormat.format(Messages.getString(String.valueOf(string2) + "Message2." + string3), n2, n3));
        stringBuilder.append('\n');
        stringBuilder.append(Messages.getString("UnresolvedReferencedObjects.ErrorMessage.CorrectiveAction"));
        return stringBuilder.toString();
    }

    private static String getSessionName(IObjectInfo iObjectInfo) {
        Attributes attributes = iObjectInfo.getDicomObjectMerged();
        return UnresolvedReferencedObjectsUtil.getObjectName(attributes.getString(528432), attributes.getDate(524320));
    }

    private static String getKeyObjectName(ReferringObject referringObject) {
        Attributes attributes = referringObject.getObject().getDicomObjectMerged();
        return UnresolvedReferencedObjectsUtil.getObjectName(referringObject.getType().getDescription(), attributes.getDate(524321));
    }

    private static String getObjectName(String string, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\'');
        stringBuilder.append(string);
        stringBuilder.append('\'');
        if (date != null) {
            stringBuilder.append(' ');
            stringBuilder.append(Messages.getString("UnresolvedReferencedObjects.ErrorMessage.from"));
            stringBuilder.append(' ');
            stringBuilder.append(DateTimeUtils.date2String((Date)date));
        }
        return stringBuilder.toString();
    }
}

