/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.util.referencedobject.IObjectReference;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObject;
import com.agfa.pacs.tools.CompareUtils;

public class ReferencedObject
implements IObjectReference {
    private ReferringObject referringObject;
    private IObjectInfo object;
    private Integer frameNumber;

    public ReferencedObject(ReferringObject referringObject, IObjectInfo iObjectInfo, Integer n) {
        this.object = iObjectInfo;
        this.referringObject = referringObject;
        this.frameNumber = UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.Multiframe) ? n : null;
    }

    public ReferencedObject(ReferringObject referringObject, IObjectInfo iObjectInfo) {
        this(referringObject, iObjectInfo, null);
    }

    @Override
    public IObjectInfo getObject() {
        return this.object;
    }

    public Integer getFrameNumber() {
        return this.frameNumber;
    }

    public ReferringObject getReferringObject() {
        return this.referringObject;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ReferencedObject)) {
            return false;
        }
        ReferencedObject referencedObject = (ReferencedObject)object;
        return CompareUtils.equals((Object)this.referringObject, (Object)referencedObject.referringObject) && this.object.equalsKey((IDataInfo)referencedObject.object) && CompareUtils.equals((Object)this.frameNumber, (Object)referencedObject.frameNumber);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + CompareUtils.hashCode((Object)this.referringObject);
        n = 37 * n + CompareUtils.hashCode((Object)this.object.getKey());
        n = 37 * n + CompareUtils.hashCode((Object)this.frameNumber);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.object.getSOPInstanceUID());
        if (this.frameNumber != null) {
            stringBuilder.append("_");
            stringBuilder.append(this.frameNumber);
        }
        return stringBuilder.toString();
    }
}

