/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.primitives;

import com.agfa.pacs.listtext.lta.util.primitives.IntCollection;
import com.agfa.pacs.listtext.lta.util.primitives.IntList;
import com.agfa.pacs.listtext.lta.util.primitives.RandomAccessIntList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ArrayIntList
extends RandomAccessIntList
implements IntList,
Serializable {
    private transient int[] _data = null;
    private int _size = 0;

    public ArrayIntList() {
        this(8);
    }

    public ArrayIntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new int[n];
        this._size = 0;
    }

    public ArrayIntList(IntCollection intCollection) {
        this(intCollection.size());
        this.addAll(intCollection);
    }

    @Override
    public int get(int n) {
        this.checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int removeElementAt(int n) {
        this.checkRange(n);
        this.incrModCount();
        int n2 = this._data[n];
        int n3 = this._size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n3);
        }
        --this._size;
        return n2;
    }

    @Override
    public int set(int n, int n2) {
        this.checkRange(n);
        this.incrModCount();
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    @Override
    public void add(int n, int n2) {
        this.checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n3 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n3);
        this._data[n] = n2;
        ++this._size;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            int[] nArray = this._data;
            this._data = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            int[] nArray = this._data;
            this._data = new int[this._size];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeInt(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new int[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readInt();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

