/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.logging.ALogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TestScriptUtil {
    private static final ALogger log = ALogger.getLogger(TestScriptUtil.class);
    private static final String IMAGE_FORMAT = "png";
    private static final int IMAGE_TYPE = 2;

    static boolean compareImagesInt(BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3, String string, int n) {
        log.debug("Comparing two images: " + string);
        if (bufferedImage == null && bufferedImage2 == null) {
            return true;
        }
        if (bufferedImage == null) {
            TestScriptUtil.createErrorImage("Reference image missing", bufferedImage3);
            return false;
        }
        if (bufferedImage2 == null) {
            TestScriptUtil.createErrorImage("Result image missing", bufferedImage3);
            return false;
        }
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferInt)) {
            log.warn("Wrong comparison");
            return false;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        dataBuffer = bufferedImage2.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferInt)) {
            log.warn("Wrong comparison");
            return false;
        }
        DataBufferInt dataBufferInt2 = (DataBufferInt)dataBuffer;
        int[] nArray = null;
        if (bufferedImage3 != null) {
            DataBufferInt dataBufferInt3 = (DataBufferInt)bufferedImage3.getRaster().getDataBuffer();
            nArray = dataBufferInt3.getData();
        }
        int[] nArray2 = dataBufferInt.getData();
        int[] nArray3 = dataBufferInt2.getData();
        int n2 = dataBufferInt.getData().length;
        if (dataBufferInt2.getData().length != n2) {
            String string2 = "Not the same length";
            log.warn(string2);
            TestScriptUtil.createErrorImage(string2, bufferedImage3);
            return false;
        }
        if (nArray != null && nArray.length != n2) {
            log.warn("Internal length error");
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (nArray2[n4] != nArray3[n4]) {
                if (nArray == null && ++n3 > n) {
                    return false;
                }
                if (nArray != null) {
                    nArray[n4] = nArray2[n4] ^ nArray3[n4] | 0xFF000000;
                }
            }
            ++n4;
        }
        return n3 <= n;
    }

    public static void writeImage(BufferedImage bufferedImage, String string) {
        File file = new File(String.valueOf(string) + "." + IMAGE_FORMAT);
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            log.warn("Creating directory failed: " + file.getParent());
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_FORMAT, file);
        }
        catch (IOException iOException) {
            log.error("Could not store image:" + string);
        }
    }

    static BufferedImage readImage(String string) {
        File file = new File(String.valueOf(string) + "." + IMAGE_FORMAT);
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (IOException iOException) {
            log.error("Could not read image:" + string, (Throwable)iOException);
            return null;
        }
    }

    public static BufferedImage createErrorImage(String string, BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setFont(graphics2D.getFont().deriveFont(50));
        graphics2D.drawString(string, 0, 50);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean writeImageDifference(BufferedImage bufferedImage, String string, BufferedImage bufferedImage2, String string2, int n) {
        BufferedImage bufferedImage3;
        BufferedImage bufferedImage4 = null;
        bufferedImage4 = bufferedImage != null ? new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2) : new BufferedImage(350, 100, 2);
        boolean bl = TestScriptUtil.compareImagesInt(bufferedImage, bufferedImage2, bufferedImage4, string2, n);
        if (bl) {
            return true;
        }
        if (string != null && (bufferedImage3 = TestScriptUtil.readImage(string)) != null && TestScriptUtil.compareImagesInt(bufferedImage3, bufferedImage2, null, null, n)) {
            log.debug("Alternate reference images matches result image.");
            return true;
        }
        log.warn("Difference in images:" + string2);
        TestScriptUtil.writeImage(bufferedImage4, string2);
        return false;
    }
}

