/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.hw.IRetrieveListener;
import com.agfa.pacs.data.shared.instanceinfo.Availability;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeUtilities;
import com.agfa.pacs.data.shared.util.WaitCancelable;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import com.agfa.pacs.listtext.lta.util.DicomMoveUtils;
import com.agfa.pacs.listtext.lta.util.job.JobControl;
import com.agfa.pacs.logging.ALogger;
import java.util.Collections;
import java.util.List;

public class RetrieveUtils {
    private static final ALogger log = ALogger.getLogger(RetrieveUtils.class);

    public static void getNearlineStudy(IStudyInfo iStudyInfo, IRetrieveListener iRetrieveListener) {
        if (iStudyInfo.getSource().getIdentifier() instanceof IDicomNode) {
            IDicomNode iDicomNode = (IDicomNode)iStudyInfo.getSource().getIdentifier();
            ProgressStateModel progressStateModel = ProgressManagerFactory.getManager().createAndAddProgress();
            List<IStudyInfo> list = Collections.singletonList(iStudyInfo);
            progressStateModel.setProgressTitle("Get Nearling");
            progressStateModel.setDetailedMessage(JobControl.createDetailedInformation("Get Nearline", "", list));
            String string = iStudyInfo.getAttributes().getString(524372, null);
            IDicomNode iDicomNode2 = DataInfoNodeUtilities.resolveAET((String)string);
            if (iDicomNode2 == null) {
                log.info("Central archive unknown,sending by loop");
                iDicomNode2 = iDicomNode;
            } else {
                log.info("Central archive known,sending from him");
            }
            try {
                WaitCancelable waitCancelable = DicomMoveUtils.moveInstances(iDicomNode2, iDicomNode.getCalledAET(), list, progressStateModel);
                new RetrieveListener(waitCancelable, iRetrieveListener, iStudyInfo, progressStateModel).start();
            }
            catch (DicomException dicomException) {
                log.error("Dicom exception", (Throwable)dicomException);
                iRetrieveListener.studyRetrieved(iStudyInfo.getKey(), iStudyInfo, IDicomDataListener.Status.Failed);
            }
        }
    }

    private static class RetrieveListener
    extends Thread {
        private WaitCancelable wc;
        private IRetrieveListener listener;
        private IStudyInfo study;
        private ProgressState ps;

        public RetrieveListener(WaitCancelable waitCancelable, IRetrieveListener iRetrieveListener, IStudyInfo iStudyInfo, ProgressState progressState) {
            this.wc = waitCancelable;
            this.listener = iRetrieveListener;
            this.study = iStudyInfo;
            this.ps = progressState;
            this.setPriority(1);
            this.setDaemon(true);
            this.setName("Get Nearline");
        }

        @Override
        public void run() {
            this.wc.waitUntilFinished();
            boolean bl = this.ps.getProgressState() == JobState.FINISHED;
            IStudyInfo iStudyInfo = (IStudyInfo)this.study.copy(false);
            if (bl) {
                iStudyInfo.setAvailability(Availability.ONLINE);
            }
            this.listener.studyRetrieved(this.study.getKey(), iStudyInfo, bl ? IDicomDataListener.Status.Success : IDicomDataListener.Status.Failed);
        }
    }
}

