/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ItemPointer;

public class ProcedureCodeUtil {
    private static final String codeDesignator = ConfigurationProviderFactory.getBaseConfig().getString("listtext.code_designator");

    public static Code getProcedureCode(IStudyInfo iStudyInfo) {
        IDataInfo iDataInfo;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("KO", "SR", "PR"));
        Attributes attributes = null;
        if (!iStudyInfo.childrenAvailable()) {
            DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, ISeriesInfo.class);
        }
        Iterator iterator = iStudyInfo.children().iterator();
        while (attributes == null && iterator.hasNext()) {
            iDataInfo = (IDataInfo)iterator.next();
            if (hashSet.contains(iDataInfo.getAttributes().getString(524384, ""))) continue;
            attributes = iDataInfo.getAttributes();
        }
        if (attributes == null) {
            return null;
        }
        iDataInfo = null;
        if ((attributes = attributes.getNestedDataset(new ItemPointer[]{new ItemPointer(4194933, 0)})) == null) {
            return null;
        }
        if (codeDesignator != null) {
            if (attributes.contains(0x400008) && (iDataInfo = Code.create((Attributes)attributes, (int)0x400008)) != null && !codeDesignator.equals(iDataInfo.getCodingSchemeDesignator())) {
                iDataInfo = null;
            }
            if (iDataInfo == null && attributes.contains(3280996) && (iDataInfo = Code.create((Attributes)attributes, (int)3280996)) != null && !codeDesignator.equals(iDataInfo.getCodingSchemeDesignator())) {
                iDataInfo = null;
            }
            if (iDataInfo == null && attributes.contains(4236146) && (iDataInfo = Code.create((Attributes)attributes, (int)4236146)) != null && !codeDesignator.equals(iDataInfo.getCodingSchemeDesignator())) {
                iDataInfo = null;
            }
        }
        return iDataInfo;
    }

    public static String getProcedureCodeValue(IStudyInfo iStudyInfo) {
        Code code = ProcedureCodeUtil.getProcedureCode(iStudyInfo);
        if (code != null) {
            return code.getCodeValue();
        }
        return null;
    }
}

