/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.search;

import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.listtext.lta.search.SearchThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SearchHandler<T extends IDataInfoSource>
implements ISearchHandler<T> {
    private List<T> dataInfoSources = new ArrayList<T>();

    @Override
    public void addDataInfoSource(T t) {
        if (!this.dataInfoSources.contains(t)) {
            this.dataInfoSources.add(t);
        }
    }

    @Override
    public void removeDataInfoSource(T t) {
        this.dataInfoSources.remove(t);
    }

    @Override
    public void removeAllDataInfoSources() {
        this.dataInfoSources.clear();
    }

    @Override
    public List<T> getDataInfoSources() {
        return this.dataInfoSources;
    }

    @Override
    public Cancelable search(IFilter iFilter, SearchHandlerListener searchHandlerListener, boolean bl) {
        SearchThread searchThread = new SearchThread(this, this.dataInfoSources, iFilter, searchHandlerListener, this.getName());
        if (bl) {
            searchThread.start();
        } else {
            searchThread.run();
        }
        return searchThread;
    }

    @Override
    public Cancelable search(IFilter iFilter, SearchHandlerListener searchHandlerListener) {
        return this.search(iFilter, searchHandlerListener, true);
    }

    private String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dataInfoSources.isEmpty()) {
            return stringBuilder.toString();
        }
        Iterator<T> iterator = this.dataInfoSources.iterator();
        IDataInfoSource iDataInfoSource = (IDataInfoSource)iterator.next();
        stringBuilder.append(iDataInfoSource);
        while (iterator.hasNext()) {
            iDataInfoSource = (IDataInfoSource)iterator.next();
            stringBuilder.append(", ").append(iDataInfoSource.toString());
        }
        return stringBuilder.toString();
    }

    public List<FilterTag> getCommonSearchFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList arrayList = null;
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.addAll(iDataInfoSource.getSearchTags());
                continue;
            }
            arrayList.retainAll(iDataInfoSource.getSearchTags());
        }
        return arrayList;
    }

    public List<FilterTag> getAllSearchFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList<FilterTag> arrayList = new ArrayList<FilterTag>();
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources) {
            List list = iDataInfoSource.getSearchTags();
            for (FilterTag filterTag : list) {
                if (arrayList.contains(filterTag)) continue;
                arrayList.add(filterTag);
            }
        }
        return arrayList;
    }

    public List<FilterTag> getCommonResultFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList arrayList = null;
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.addAll(iDataInfoSource.getResultTags());
                continue;
            }
            arrayList.retainAll(iDataInfoSource.getResultTags());
        }
        return arrayList;
    }

    public List<FilterTag> getAllResultFilterTags() {
        if (this.dataInfoSources.isEmpty()) {
            return null;
        }
        ArrayList<FilterTag> arrayList = new ArrayList<FilterTag>();
        for (IDataInfoSource iDataInfoSource : this.dataInfoSources) {
            List list = iDataInfoSource.getResultTags();
            for (FilterTag filterTag : list) {
                if (arrayList.contains(filterTag)) continue;
                arrayList.add(filterTag);
            }
        }
        return arrayList;
    }
}

