/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.search;

import com.agfa.integration.ObjectID;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.DataInfoNodeUtilities;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.dicomworklists.mwl.DicomMWLCFindSCU;
import com.agfa.pacs.listtext.lta.datafinder.AlternativeSearchResult;
import com.agfa.pacs.listtext.lta.datafinder.IDataFinder;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchThread;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class SearchDataFinder
implements IDataFinder {
    private static final ALogger log = ALogger.getLogger(SearchDataFinder.class);
    public static final String DATA_FINDER_TYPE = "SEARCH";
    private boolean searchForRisStudies = false;
    private boolean alternativeMWLQuery = true;
    private String mwlQueryNode = null;
    private String accNrPattern = null;
    private String accNrReplacement = null;

    public SearchDataFinder() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("listtext.service");
        this.searchForRisStudies = iConfigurationProvider.getBoolean("enableRISStudyUIDMapping");
        this.alternativeMWLQuery = iConfigurationProvider.getBoolean("alternativeMWLQuery");
        this.mwlQueryNode = iConfigurationProvider.getString("alternativeMWLQueryDataNode");
        if (this.mwlQueryNode != null && this.mwlQueryNode.length() == 0) {
            this.mwlQueryNode = null;
        }
        if (this.alternativeMWLQuery) {
            this.accNrPattern = iConfigurationProvider.getString("MWLQuery.pattern");
            this.accNrReplacement = iConfigurationProvider.getString("MWLQuery.replacement");
            log.info("Accession Nr Extraction configured:" + this.accNrPattern + " to " + this.accNrReplacement);
        }
    }

    @Override
    public String getType() {
        return DATA_FINDER_TYPE;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public List<IStudyInfo> findStudies(String string, String string2, String string3, String string4, boolean bl) {
        return this.findStudiesInt(string, string2, string3, string4, bl, false);
    }

    private List<IStudyInfo> findStudiesInt(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        Object object;
        if (string3 == null && string4 == null) {
            return null;
        }
        if (bl2 && !this.searchForRisStudies) {
            return null;
        }
        AdvancedFilter advancedFilter = new AdvancedFilter("Search for study");
        if (string != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string}));
        }
        if (string2 != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        if (string3 != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string3}));
        }
        if (string4 != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524368);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string4}));
        }
        object = this.getSearchNodes(bl);
        RISStudyFilter rISStudyFilter = new RISStudyFilter(string, string3);
        IDataInfoNode iDataInfoNode = Base.getMasterDataNode();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object2;
            IDataInfoSource iDataInfoSource = (IDataInfoSource)iterator.next();
            boolean bl3 = false;
            if (bl2 && this.searchForRisStudies) {
                if (string3 == null || !((String)(object2 = iDataInfoSource.getIdentifier().getType())).equals("MGLIB") && !((String)object2).equals("AGFADICOMWADO")) continue;
                bl3 = true;
            }
            object2 = new SearchHandler<IDataInfoSource>();
            ((SearchHandler)object2).addDataInfoSource(iDataInfoSource);
            Cancelable cancelable = ((SearchHandler)object2).search((IFilter)(bl3 ? rISStudyFilter : advancedFilter), null, false);
            if (cancelable instanceof SearchThread) {
                IRootInfo iRootInfo = ((SearchThread)cancelable).getResult();
                if (iRootInfo == null) continue;
                if (iDataInfoSource == iDataInfoNode) {
                    this.handleMPIOverRIS((IDataInfo)iRootInfo, iDataInfoNode);
                }
                List list = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IStudyInfo.class);
                for (IStudyInfo iStudyInfo : list) {
                    boolean bl4;
                    boolean bl5 = string3 != null ? string3.equals(iStudyInfo.getStudyUID()) : true;
                    boolean bl6 = bl4 = string4 != null ? string4.equals(iStudyInfo.getAttributes().getString(524368, null)) : true;
                    if (!bl3 && !bl5 || !bl4) continue;
                    return list;
                }
                continue;
            }
            cancelable.cancel();
        }
        return null;
    }

    private void handleMPIOverRIS(IDataInfo iDataInfo, IDataInfoNode iDataInfoNode) {
        List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IPatientInfo.class);
        for (IPatientInfo iPatientInfo : list) {
            Attributes attributes = iPatientInfo.getAttributes();
            IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(attributes.getString(0x100020, null), attributes.getString(0x100021, null));
            List list2 = DataInfoUtilities.getLevel((IDataInfo)FilterHelper.performSyncSearch(iPersistantFilter, (IDataInfoSource)iDataInfoNode), IPatientInfo.class);
            if (list2.size() == 1) {
                IPatientInfo iPatientInfo2 = (IPatientInfo)list2.get(0);
                if (CompareUtils.equals((Object)iPatientInfo2.getAttributes().getString(0x100020, null), (Object)attributes.getString(0x100020, null)) && CompareUtils.equals((Object)iPatientInfo2.getAttributes().getString(0x100021, null), (Object)attributes.getString(0x100021, null))) {
                    Sequence sequence = iPatientInfo2.getAttributes().getSequence(0x101002);
                    attributes.setValue(0x101002, VR.SQ, (Object)sequence);
                    continue;
                }
                log.warn("Incorrect patient returned from MPI");
                continue;
            }
            log.warn("Multiple patient returned from MPI");
        }
    }

    private String extractAccessionNr(String string) throws IllegalArgumentException {
        if (!string.startsWith("1.2.40.0.13")) {
            throw new IllegalArgumentException("Not supported prefix");
        }
        String[] stringArray = string.split("\\.");
        String string2 = stringArray[stringArray.length - 3];
        if (string2.length() < 6) {
            log.warn("Found unsupported accessionNR");
            throw new IllegalArgumentException("Not supported studyUID");
        }
        return string2.replaceAll(this.accNrPattern, this.accNrReplacement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AlternativeSearchResult searchByMWL(ObjectID[] objectIDArray, boolean bl) {
        Object object;
        String string = null;
        String string2 = null;
        try {
            ObjectID[] objectIDArray2 = objectIDArray;
            int n = objectIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = objectIDArray2[n2];
                if (object.isFullStudy() && object.getStudyUID() != null) {
                    if (object.getAccessionNr() != null && object.getPatientID() != null) {
                        log.info("Fully qualified object, MWL Search unnecessary");
                        return null;
                    }
                    string2 = this.extractAccessionNr(object.getStudyUID());
                    if (string == null) {
                        string = string2;
                    }
                    if (!string.equals(string2)) {
                        log.warn("Found different accessionNr in one RIS message");
                        return null;
                    }
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Found unsupported study UID type");
            return null;
        }
        if (string == null) {
            log.error("Found unsupported accessionNR");
            return null;
        }
        object = this.searchForPatientID(string, this.getSearchNodes(bl));
        if (object.isEmpty()) {
            log.warn("No patient ID entry found in MWL");
            return null;
        }
        if (object.size() > 1) {
            log.warn("Multiple patient ID entries found in MWL");
        }
        ObjectID objectID = ObjectID.forPatientAccesion((String)((String)object.iterator().next()), (String)string);
        return new AlternativeSearchResult(objectID, null);
    }

    @Override
    public AlternativeSearchResult findAlternativeSearchObject(ObjectID[] objectIDArray, boolean bl) {
        if (!this.alternativeMWLQuery && !this.searchForRisStudies) {
            return null;
        }
        AlternativeSearchResult alternativeSearchResult = null;
        if (this.searchForRisStudies) {
            ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
            ObjectID[] objectIDArray2 = objectIDArray;
            int n = objectIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectID objectID = objectIDArray2[n2];
                List<IStudyInfo> list = this.findStudiesInt(objectID.getPatientID(), objectID.getIssuerOfPatientID(), objectID.getStudyUID(), objectID.getAccessionNr(), bl, true);
                if (list != null) {
                    arrayList.addAll(list);
                }
                ++n2;
            }
            if (!arrayList.isEmpty()) {
                alternativeSearchResult = new AlternativeSearchResult(null, arrayList);
            }
        }
        if (alternativeSearchResult == null && this.alternativeMWLQuery) {
            alternativeSearchResult = this.searchByMWL(objectIDArray, bl);
        }
        return alternativeSearchResult;
    }

    private Collection<String> searchForPatientID(String string, Collection<IDataInfoNode> collection) {
        Attributes attributes = new Attributes();
        attributes.setString(524368, VR.SH, string);
        attributes.setNull(0x100020, VR.LO);
        HashSet<String> hashSet = new HashSet<String>();
        for (IDataInfoNode iDataInfoNode : collection) {
            if (!iDataInfoNode.getIdentifier().getType().equals("AGFADICOMWADO") || this.mwlQueryNode != null && !iDataInfoNode.getName().equals(this.mwlQueryNode)) continue;
            DicomMWLCFindSCU dicomMWLCFindSCU = null;
            try {
                try {
                    if (iDataInfoNode.getIdentifier() instanceof IDicomNode) {
                        SimpleDicomNode simpleDicomNode = new SimpleDicomNode((IDicomNode)iDataInfoNode.getIdentifier());
                        simpleDicomNode.setCalledAET(String.valueOf(simpleDicomNode.getCalledAET()) + "RIS");
                        dicomMWLCFindSCU = new DicomMWLCFindSCU((IDicomNode)simpleDicomNode);
                        dicomMWLCFindSCU.connect();
                        List list = dicomMWLCFindSCU.cFind(attributes);
                        for (Attributes attributes2 : list) {
                            String string2 = attributes2.getString(524368);
                            if (string2 == null || string2.length() == 0 || !attributes2.containsValue(0x100020)) continue;
                            hashSet.add(attributes2.getString(0x100020));
                        }
                    }
                }
                catch (Exception exception) {
                    log.error("Dicom Exception", (Throwable)exception);
                    try {
                        if (dicomMWLCFindSCU == null || !dicomMWLCFindSCU.isConnected()) continue;
                        dicomMWLCFindSCU.close();
                    }
                    catch (DicomException dicomException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (dicomMWLCFindSCU != null && dicomMWLCFindSCU.isConnected()) {
                        dicomMWLCFindSCU.close();
                    }
                }
                catch (DicomException dicomException) {}
                throw throwable;
            }
            try {
                if (dicomMWLCFindSCU == null || !dicomMWLCFindSCU.isConnected()) continue;
                dicomMWLCFindSCU.close();
            }
            catch (DicomException dicomException) {}
        }
        return hashSet;
    }

    private Collection<IDataInfoNode> getSearchNodes(boolean bl) {
        return DataInfoNodeUtilities.getSearchNodes(Base.getDataNodesForServices(), (boolean)bl);
    }

    private static class RISStudyFilter
    implements IFilter {
        private String studyUID;
        private String patientID;

        public RISStudyFilter(String string, String string2) {
            this.patientID = string;
            this.studyUID = string2;
        }

        public Level getLeafLevel() {
            return Level.Series;
        }

        public Level getRootLevel() {
            if (this.studyUID != null) {
                return Level.Study;
            }
            return Level.Patient;
        }

        public String getName() {
            return "Search for study using RIS study instance UID";
        }

        public Attributes getAsDicomObject() {
            return this.getLevel(Level.Series).get(0);
        }

        public Level getMinLevel() {
            return Level.Series;
        }

        public List<Attributes> getLevel(Level level) {
            Attributes attributes = new Attributes();
            if (Level.Patient.equals((Object)level)) {
                if (this.patientID != null) {
                    attributes.setString(0x100020, VR.LO, this.patientID);
                }
            } else if (Level.Series.equals((Object)level)) {
                Attributes attributes2 = new Attributes();
                attributes2.setString(0x401001, VR.SH, "*");
                attributes2.setString(0x20000D, VR.UI, this.studyUID);
                attributes.newSequence(4194933, 1).add(attributes2);
            }
            return Collections.singletonList(attributes);
        }

        public RISStudyFilter cloneFilter() {
            return new RISStudyFilter(this.patientID, this.studyUID);
        }

        public <T> T getModifierValue(FilterModifiers.IFilterModifier<T> iFilterModifier) {
            return null;
        }

        public <T> void putModifierValue(FilterModifiers.IFilterModifier<T> iFilterModifier, T t) {
        }
    }
}

