/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.progress;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.data.shared.util.CancelableCollector;
import com.agfa.pacs.tools.IDisposable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.text.WordUtils;
import org.dcm4che3.audit.AuditMessage;

public class ProgressStateModel
implements ProgressState,
CancelableCollector {
    public static final String ELLIPSIS = "...";
    protected JobState state = JobState.CREATED;
    public static final String CANCELABLE_CHANGED = "CANCELABLE_CHANGED";
    public static final String PROGRESS_STATE_CHANGED = "PROGRESS_STATE_CHANGED";
    public static final String PROGRESS_MESSAGE_CHANGED = "PROGRESS_MESSAGE_CHANGED";
    public static final String PROGRESS_DETAIL_MESSAGE_CHANGED = "PROGRESS_DETAIL_MESSAGE_CHANGED";
    public static final String MODEL_CHANGED = "MODEL_CHANGED";
    public static final String PROGRESS_VALUE_CHANGED = "PROGRESS_VALUE_CHANGED";
    public static final String PROGRESS_VALUE_INDETERMINATION_FLAG_CHANGED = "PROGRESS_VALUE_INDETERMINATION_FLAG_CHANGED";
    public static final String DESCRIPTION_VISIBILITY_CHANGED = "DESCRIPTION_VISIBILITY_CHANGED";
    public static final String PROGRESS_TITLE_CHANGED = "PROGRESS_TITLE_CHANGED";
    private static final int MAX_LINE_LENGTH = 80;
    private static final String HTML_PREFIX = "<html>";
    protected boolean canceled = false;
    private boolean cancelPossible = true;
    private double progressValue = 0.0;
    protected String progressTitle = "";
    protected String progressMsg = "";
    protected String detailMsg = null;
    private boolean indeterminate = false;
    private Vector<Cancelable> toCancelJobs = new Vector();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public boolean isCancelPossible() {
        return this.cancelPossible;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRetired() {
        return this.state == JobState.RETIRED;
    }

    public JobState getProgressState() {
        return this.state;
    }

    public String getProgressTitle() {
        return this.progressTitle;
    }

    public String getProgressMessage() {
        return this.progressMsg;
    }

    public String getDetailMessage() {
        return this.detailMsg;
    }

    public double getProgressValue() {
        return this.progressValue;
    }

    public void setCancelable(boolean bl) {
        boolean bl2 = this.cancelPossible;
        this.cancelPossible = bl;
        this.changeSupport.firePropertyChange(CANCELABLE_CHANGED, (Object)bl2, (Object)this.cancelPossible);
    }

    public void setProgress(float f) {
        double d;
        if (this.state == JobState.CREATED) {
            this.state = JobState.STARTED;
        }
        if ((d = Math.max(0.0, Math.min(1.0, (double)f))) != this.progressValue) {
            double d2 = this.progressValue;
            this.progressValue = d;
            this.changeSupport.firePropertyChange(PROGRESS_VALUE_CHANGED, d2, d);
        }
    }

    public boolean isProgressValueIndeterminate() {
        return this.indeterminate;
    }

    public void setProgressValueIndeterminate(boolean bl) {
        if (this.indeterminate != bl) {
            this.indeterminate = bl;
            this.changeSupport.firePropertyChange(PROGRESS_VALUE_INDETERMINATION_FLAG_CHANGED, !bl, bl);
        }
    }

    public void setProgressTitle(String string) {
        if (!this.progressTitle.equals(string)) {
            String string2 = this.progressTitle;
            this.progressTitle = string != null ? string : "";
            this.changeSupport.firePropertyChange(PROGRESS_TITLE_CHANGED, string2, this.progressTitle);
        }
    }

    public void setStateMessage(String string) {
        if (!this.progressMsg.equals(string)) {
            if (this.state == JobState.FAILED) {
                return;
            }
            String string2 = this.progressMsg;
            if (string == null) {
                string = "";
            }
            if (string.length() > 20) {
                this.progressMsg = String.valueOf(string.substring(0, 20)) + ELLIPSIS;
                this.setDetailedMessage(this.formatMessage(string));
            } else {
                this.progressMsg = string;
            }
            this.changeSupport.firePropertyChange(PROGRESS_MESSAGE_CHANGED, string2, this.progressMsg);
        }
    }

    private String formatMessage(String string) {
        if (string == null || string.isEmpty() || string.startsWith(HTML_PREFIX)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HTML_PREFIX);
        stringBuilder.append(WordUtils.wrap((String)string, (int)80, (String)"<br />", (boolean)false));
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public void setDetailedMessage(String string) {
        if (this.detailMsg == null || !this.detailMsg.equals(string)) {
            if (this.state == JobState.FAILED) {
                return;
            }
            String string2 = this.detailMsg;
            this.detailMsg = string;
            this.changeSupport.firePropertyChange(PROGRESS_DETAIL_MESSAGE_CHANGED, string2, string);
        }
    }

    public void setState(JobState jobState) {
        JobState jobState2 = this.state;
        if (this.canceled) {
            return;
        }
        if (this.state == JobState.FAILED) {
            if (jobState == JobState.CANCELLED) {
                this.canceled = true;
                this.cancelJobs();
                this.changeSupport.firePropertyChange(PROGRESS_STATE_CHANGED, null, JobState.FAILED);
            }
            return;
        }
        if (jobState == JobState.CANCELLED) {
            this.state = JobState.FINISHED;
            this.canceled = true;
            this.cancelJobs();
        }
        if (jobState == JobState.STARTED) {
            this.state = jobState;
            this.setProgress(0.0f);
        } else if (jobState == JobState.FINISHED) {
            this.state = jobState;
            this.setProgress(1.0f);
            this.toCancelJobs.clear();
        } else if (jobState == JobState.RETIRED) {
            this.state = jobState;
            this.setProgress(1.0f);
            this.toCancelJobs.clear();
        } else {
            this.state = jobState;
        }
        if (jobState2 != this.state) {
            this.changeSupport.firePropertyChange(PROGRESS_STATE_CHANGED, jobState2, this.state);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addAuditMessage(AuditMessage auditMessage) {
        this.changeSupport.addPropertyChangeListener(new AuditMessageListener(auditMessage));
    }

    public void storeStudyUsageRegistration(Map<String, WeakReference<IDisposable>> map) {
        this.changeSupport.addPropertyChangeListener(new StudyUsageListener(map));
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void everythingDone(boolean bl) {
        if (bl) {
            this.setState(JobState.RETIRED);
        }
    }

    public Collection<Cancelable> getCancelables() {
        return this.toCancelJobs;
    }

    public void addCancelable(Cancelable cancelable) {
        this.toCancelJobs.add(cancelable);
    }

    public void cancelAll() {
        this.setState(JobState.CANCELLED);
    }

    private void cancelJobs() {
        ArrayList<Cancelable> arrayList = new ArrayList<Cancelable>(this.toCancelJobs);
        Collections.reverse(arrayList);
        for (Cancelable cancelable : arrayList) {
            cancelable.cancel();
        }
        this.toCancelJobs.clear();
    }

    private static class AuditMessageListener
    extends FinishListener {
        private AuditMessage message;

        public AuditMessageListener(AuditMessage auditMessage) {
            this.message = auditMessage;
        }

        @Override
        protected void finished(boolean bl) {
            if (bl) {
                Audit.getInstance().logAuditMessage(this.message, "8");
            } else {
                Audit.getInstance().logAuditMessage(this.message, "0");
            }
            this.message = null;
        }
    }

    private static abstract class FinishListener
    implements PropertyChangeListener {
        private boolean finished = false;

        private FinishListener() {
        }

        protected abstract void finished(boolean var1);

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ProgressStateModel.PROGRESS_STATE_CHANGED) && !this.finished) {
                JobState jobState = (JobState)propertyChangeEvent.getNewValue();
                if (jobState == JobState.FAILED) {
                    this.finished = true;
                    this.finished(true);
                } else if (jobState == JobState.FINISHED) {
                    this.finished = true;
                    this.finished(false);
                }
            }
        }
    }

    private static class StudyUsageListener
    extends FinishListener {
        private Map<String, WeakReference<IDisposable>> studyKeys;

        public StudyUsageListener(Map<String, WeakReference<IDisposable>> map) {
            this.studyKeys = map;
        }

        @Override
        protected void finished(boolean bl) {
            IDicomCache iDicomCache = DicomCacheFactory.getInstance().getDicomCache();
            iDicomCache.unregisterStudyUsage(this.studyKeys);
            this.studyKeys = null;
        }
    }
}

