/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.priors;

import com.agfa.pacs.base.util.PatientMergeUtilities;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.priors.IPriorsHook;
import com.agfa.pacs.listtext.lta.priors.IRelevancyListener;
import com.agfa.pacs.listtext.lta.search.ISearchHandler;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.search.SearchHandlerListener;
import com.agfa.pacs.listtext.lta.util.SendError;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class AbstractPriorsHook
implements IPriorsHook {
    private List<String> notSearchedDataNodeTypes = new ArrayList<String>();

    public AbstractPriorsHook() {
        this.notSearchedDataNodeTypes.add("GPWL");
        this.notSearchedDataNodeTypes.add("DICOMFILE");
        this.notSearchedDataNodeTypes.add("DICOMDIR");
        this.notSearchedDataNodeTypes.add("IMPAXEE");
        this.notSearchedDataNodeTypes.add("DICOMCACHE");
    }

    @Override
    public Cancelable startAnotherSearch(List<IStudyInfo> list, List<IRelevancyListener> list2, IDataInfoNode iDataInfoNode) {
        List list3 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        IPatientInfo iPatientInfo = (IPatientInfo)list3.get(0);
        IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(iPatientInfo);
        iPersistantFilter.setMinLevel(Level.Study);
        SearchHandler<IDataInfoNode> searchHandler = new SearchHandler<IDataInfoNode>();
        if (iDataInfoNode != null) {
            searchHandler.addDataInfoSource(iDataInfoNode);
        } else {
            for (IDataInfoNode object2 : Base.getDataInfoNodes()) {
                String string = object2.getType();
                if (this.notSearchedDataNodeTypes.contains(string)) continue;
                searchHandler.addDataInfoSource(object2);
            }
        }
        PriorSearchHandler priorSearchHandler = new PriorSearchHandler(list, list.get(0).getPatient(), list2, false);
        Cancelable cancelable = searchHandler.search(iPersistantFilter, priorSearchHandler);
        priorSearchHandler.setCancelSearch(cancelable);
        return priorSearchHandler;
    }

    @Override
    public Cancelable startMPISearch(IStudyInfo iStudyInfo, List<IRelevancyListener> list, IDataInfoNode iDataInfoNode) {
        Object object;
        List list2 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, IPatientInfo.class);
        IPatientInfo iPatientInfo = (IPatientInfo)list2.get(0);
        String string = iPatientInfo.getAttributes().getString(0x100020, null);
        String string2 = iPatientInfo.getAttributes().getString(0x100021, null);
        AdvancedFilter advancedFilter = new AdvancedFilter("MPI");
        if (string != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string}));
        }
        if (string2 != null) {
            object = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, (FilterEntryCriterion)object, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        advancedFilter.setMinLevel(Level.Study);
        object = new SearchHandler();
        ((SearchHandler)object).addDataInfoSource(iDataInfoNode);
        PriorSearchHandler priorSearchHandler = new PriorSearchHandler(Collections.singletonList(iStudyInfo), iStudyInfo.getPatient(), list, true);
        Cancelable cancelable = ((SearchHandler)object).search(advancedFilter, priorSearchHandler);
        priorSearchHandler.setCancelSearch(cancelable);
        return priorSearchHandler;
    }

    private ArchiveType getArchiveType(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource.getIdentifier().getType().equals("DICOMPS")) {
            return ArchiveType.NotSearchable;
        }
        if (iDataInfoSource.getIdentifier().getType().equals("DICOMCACHE")) {
            return ArchiveType.NotSearchable;
        }
        String string = iDataInfoSource.getIdentifier().getPropertiesOwner().properties().getProperty("closeImmediately");
        if (string != null && Boolean.parseBoolean(string)) {
            return ArchiveType.Dicom;
        }
        return ArchiveType.Agfa;
    }

    @Override
    public Cancelable findWholePatient(IPatientInfo iPatientInfo, List<IRelevancyListener> list) {
        IDataInfoSource iDataInfoSource = iPatientInfo.getSource();
        ArchiveType archiveType = this.getArchiveType(iDataInfoSource);
        IPersistantFilter iPersistantFilter = FilterUtilities.getEverythingForPatient(iPatientInfo);
        if (archiveType == ArchiveType.Agfa) {
            iPersistantFilter.setMinLevel(Level.Series);
        }
        SearchHandler<Object> searchHandler = new SearchHandler<Object>();
        searchHandler.addDataInfoSource(iDataInfoSource);
        for (IDataInfoNode object2 : this.getAdditionalNodes()) {
            searchHandler.addDataInfoSource(object2);
        }
        PriorSearchHandler priorSearchHandler = new PriorSearchHandler(iPatientInfo, list);
        Cancelable cancelable = searchHandler.search(iPersistantFilter, priorSearchHandler);
        priorSearchHandler.setCancelSearch(cancelable);
        return priorSearchHandler;
    }

    @Override
    public Cancelable startSearch(List<IStudyInfo> list, List<IRelevancyListener> list2) {
        for (IRelevancyListener object2 : list2) {
            object2.studiesLoaded(list);
        }
        List list3 = DataInfoUtilities.getLevel(list, IPatientInfo.class);
        IPatientInfo iPatientInfo = (IPatientInfo)list3.get(0);
        IDataInfoSource iDataInfoSource = iPatientInfo.getSource();
        ArchiveType archiveType = this.getArchiveType(iDataInfoSource);
        if (archiveType != ArchiveType.NotSearchable) {
            IPersistantFilter iRelevancyListener = FilterUtilities.getEverythingForPatient(iPatientInfo);
            if (archiveType == ArchiveType.Agfa) {
                iRelevancyListener.setMinLevel(Level.Series);
            }
            SearchHandler<Object> searchHandler = new SearchHandler<Object>();
            searchHandler.addDataInfoSource(iDataInfoSource);
            for (IDataInfoNode linkedList : this.getAdditionalNodes()) {
                if (linkedList == iDataInfoSource) continue;
                searchHandler.addDataInfoSource(linkedList);
            }
            PriorSearchHandler priorSearchHandler = new PriorSearchHandler(list, list.get(0).getPatient(), list2, false);
            Cancelable cancelable = searchHandler.search(iRelevancyListener, priorSearchHandler);
            priorSearchHandler.setCancelSearch(cancelable);
            return priorSearchHandler;
        }
        for (IRelevancyListener iRelevancyListener : list2) {
            LinkedList<IStudyInfo> linkedList = new LinkedList<IStudyInfo>(list);
            iRelevancyListener.studiesFound(iPatientInfo.getKey(), linkedList);
            iRelevancyListener.relevantFound(iPatientInfo.getKey(), list.get(0).getStudyUID(), Collections.EMPTY_LIST);
            iRelevancyListener.searchFinished(iPatientInfo.getKey(), list.get(0).getStudyUID(), false);
        }
        return null;
    }

    private List<IDataInfoNode> getAdditionalNodes() {
        if (this.isSearchInAllNodes()) {
            return Base.getDataInfoNodes();
        }
        IDataInfoNode iDataInfoNode = this.getAdditionalSearchNode();
        if (iDataInfoNode == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(iDataInfoNode);
    }

    protected abstract boolean isSearchInAllNodes();

    protected abstract IDataInfoNode getAdditionalSearchNode();

    private List<IStudyInfo> removeAll(List<IStudyInfo> list, List<IStudyInfo> list2) {
        IStudyInfo iStudyInfo2;
        HashSet<String> hashSet = new HashSet<String>(list2.size());
        for (IStudyInfo iStudyInfo2 : list2) {
            hashSet.add(iStudyInfo2.getKey());
        }
        iStudyInfo2 = list.listIterator();
        while (iStudyInfo2.hasNext()) {
            if (!hashSet.contains(((IStudyInfo)iStudyInfo2.next()).getKey())) continue;
            iStudyInfo2.remove();
        }
        return list;
    }

    protected abstract List<IStudyInfo> getRelevantPriors(List<IStudyInfo> var1, IStudyInfo var2);

    private static enum ArchiveType {
        Agfa,
        Dicom,
        NotSearchable;

    }

    private class PriorSearchHandler
    implements SearchHandlerListener,
    Cancelable {
        private List<IRelevancyListener> listeners;
        private String mainStudyKey;
        private String patientKey;
        private String issuerOfPatientID = null;
        private List<IStudyInfo> baseStudies;
        private Cancelable searchCancel = null;
        private boolean isCanceled = false;
        private boolean coercePatientName = false;
        private IPatientInfo patient = null;
        private boolean evaluateRelevancy = true;

        public PriorSearchHandler(List<IStudyInfo> list, IPatientInfo iPatientInfo, List<IRelevancyListener> list2, boolean bl) {
            this.mainStudyKey = list.isEmpty() ? null : list.get(0).getKey();
            this.patientKey = iPatientInfo.getKey();
            this.issuerOfPatientID = iPatientInfo.getString(0x100021);
            if (bl) {
                this.patient = iPatientInfo;
            }
            this.coercePatientName = bl;
            this.baseStudies = list;
            this.listeners = list2;
        }

        public PriorSearchHandler(IPatientInfo iPatientInfo, List<IRelevancyListener> list) {
            this(Collections.emptyList(), iPatientInfo, list, false);
            this.evaluateRelevancy = false;
        }

        void setCancelSearch(Cancelable cancelable) {
            this.searchCancel = cancelable;
        }

        public void cancel() {
            this.isCanceled = true;
            if (this.searchCancel != null) {
                this.searchCancel.cancel();
            }
            this.searchCancel = null;
            for (IRelevancyListener iRelevancyListener : this.listeners) {
                iRelevancyListener.searchFinished(this.patientKey, this.mainStudyKey, true);
            }
        }

        @Override
        public void searchStarted(ISearchHandler<?> iSearchHandler, ISearchThread iSearchThread) {
        }

        @Override
        public void searchFinished(ISearchHandler<?> iSearchHandler, ISearchThread iSearchThread) {
            List list = this.getWholePatient(iSearchThread);
            if (this.evaluateRelevancy) {
                list = AbstractPriorsHook.this.removeAll(list, this.baseStudies);
                IStudyInfo iStudyInfo = this.getMainStudy();
                List<IStudyInfo> list2 = Collections.emptyList();
                if (iStudyInfo != null) {
                    list2 = AbstractPriorsHook.this.getRelevantPriors(list, this.baseStudies.get(0));
                }
                if (!this.isCanceled) {
                    for (IRelevancyListener iRelevancyListener : this.listeners) {
                        iRelevancyListener.relevantFound(this.patientKey, this.mainStudyKey, list2);
                    }
                    this.searchCancel = null;
                    for (IRelevancyListener iRelevancyListener : this.listeners) {
                        iRelevancyListener.searchFinished(this.patientKey, this.mainStudyKey, false);
                    }
                }
            }
            this.searchCancel = null;
        }

        @Override
        public void searchSuccess(ISearchHandler<?> iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, IDataInfo iDataInfo) {
            if (!this.coercePatientName) {
                List list = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IPatientInfo.class);
                for (IPatientInfo iPatientInfo : list) {
                    if (CompareUtils.equals((Object)iPatientInfo.getString(0x100021), (Object)this.issuerOfPatientID)) continue;
                    iDataInfo.removeChild((IDataInfo)iPatientInfo);
                }
            }
            new Sender(iDataInfo).start();
        }

        @Override
        public void searchFailure(ISearchHandler<?> iSearchHandler, ISearchThread iSearchThread, IDataInfoSource iDataInfoSource, Throwable throwable) {
            if (Base.getMasterDataNode() != null) {
                SendError.sendPixManagerError(throwable);
            }
        }

        private List<IStudyInfo> getWholePatient(ISearchThread iSearchThread) {
            IRootInfo iRootInfo = iSearchThread.getResult();
            if (iRootInfo == null) {
                return Collections.emptyList();
            }
            List list = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IPatientInfo.class);
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            List list2 = DataInfoUtilities.getLevel((Collection)list, IStudyInfo.class);
            return new Vector<IStudyInfo>(list2);
        }

        private IStudyInfo getMainStudy() {
            if (this.baseStudies.isEmpty()) {
                return null;
            }
            return this.baseStudies.get(0);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getString("AbstractPriorsHook.SearchingIn"));
            stringBuilder.append(' ');
            if (AbstractPriorsHook.this.isSearchInAllNodes()) {
                stringBuilder.append(Messages.getString("AbstractPriorsHook.AllNodes"));
            } else {
                IStudyInfo iStudyInfo = this.getMainStudy();
                if (iStudyInfo != null) {
                    stringBuilder.append(iStudyInfo.getSource().getIdentifier().getName());
                }
                if (AbstractPriorsHook.this.getAdditionalSearchNode() != null) {
                    stringBuilder.append(' ');
                    stringBuilder.append(Messages.getString("AbstractPriorsHook.and"));
                    stringBuilder.append(' ');
                    stringBuilder.append(AbstractPriorsHook.this.getAdditionalSearchNode().getName());
                }
            }
            return stringBuilder.toString();
        }

        public boolean isRunning() {
            return this.searchCancel != null;
        }

        private class Sender
        extends Thread {
            private IDataInfo root;

            public Sender(IDataInfo iDataInfo) {
                this.root = iDataInfo;
            }

            @Override
            public void run() {
                List list = DataInfoUtilities.getLevel((IDataInfo)this.root, IStudyInfo.class);
                if (PriorSearchHandler.this.coercePatientName) {
                    PatientMergeUtilities.addMPIStudiesToPatient((IPatientInfo)PriorSearchHandler.this.patient, (List)list);
                }
                for (IRelevancyListener iRelevancyListener : PriorSearchHandler.this.listeners) {
                    ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>(list);
                    iRelevancyListener.studiesFound(PriorSearchHandler.this.patientKey, arrayList);
                }
            }
        }
    }
}

