/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter.advanced;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.listtext.lta.filter.FilterSelectionSets;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IFilterEntryType;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSetItem;
import com.agfa.pacs.listtext.lta.filter.advanced.ClientSideFilter;
import com.agfa.pacs.logging.ALogger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.DateUtils;

public class ClientSideFactory {
    private static final ALogger log = ALogger.getLogger(ClientSideFactory.class);

    public static ClientSideFilter getFilter(IFilterEntryType iFilterEntryType, String[] stringArray, int n, VR vR, FilterModifiers filterModifiers) {
        if (stringArray == null || stringArray.length == 1 && stringArray[0].equals("*") || stringArray.length == 0 && !iFilterEntryType.getCode().equals("today") && !iFilterEntryType.getCode().equals("previous_scheduled_date")) {
            return null;
        }
        int n2 = vR.code();
        try {
            if (iFilterEntryType.getCode().equals("starts_with")) {
                return new StartsWith(stringArray);
            }
            if (iFilterEntryType.getCode().equals("starts_with_ignore_case")) {
                if (vR == VR.PN) {
                    return new EqualsIgnoreCasePersonName(stringArray);
                }
                return new StartsWithIgnoreCase(stringArray);
            }
            if (iFilterEntryType.getCode().equals("end_with")) {
                return new EndsWith(stringArray);
            }
            if (iFilterEntryType.getCode().equals("end_with_ignore_case")) {
                return new EndsWithIgnoreCase(stringArray);
            }
            if (iFilterEntryType.getCode().equals("contains")) {
                return new Contains(stringArray);
            }
            if (iFilterEntryType.getCode().equals("contains_ignore_case")) {
                return new ContainsIgnoreCase(stringArray);
            }
            if (iFilterEntryType.getCode().equals("not_contains")) {
                return new NotContains(stringArray);
            }
            if (iFilterEntryType.getCode().equals("equals")) {
                if (n == 524385) {
                    return new MultiEqualsIgnoreCase(stringArray);
                }
                if (n2 == VR.DT.code() || n2 == VR.TM.code() || n2 == VR.DA.code()) {
                    return new DateEquals(stringArray);
                }
                if (stringArray.length == 1) {
                    return new Equals(stringArray);
                }
                return new MultiMatchEquals(stringArray);
            }
            if (iFilterEntryType.getCode().equals("equalsIgnoreCase")) {
                if (n == 524385) {
                    return new MultiEqualsIgnoreCase(stringArray);
                }
                if (vR == VR.PN) {
                    return new EqualsIgnoreCasePersonName(stringArray);
                }
                if (vR == VR.DA) {
                    return new EqualsDate(stringArray);
                }
                return new EqualsIgnoreCase(stringArray);
            }
            if (iFilterEntryType.getCode().equals("not_equals")) {
                if (n == 524385) {
                    return new MultiNotEquals(stringArray);
                }
                if (n2 == VR.DT.code() || n2 == VR.TM.code() || n2 == VR.DA.code()) {
                    return new DateNotEquals(stringArray);
                }
                return new NotEquals(stringArray);
            }
            if (iFilterEntryType.getCode().equals("not_equalsIgnoreCase")) {
                return new NotEqualsIgnoreCase(stringArray);
            }
            if (iFilterEntryType.getCode().equals("dicom_status_equals")) {
                return new DicomStatusEquals(stringArray);
            }
            if (iFilterEntryType.getCode().equals("dicom_status_equals_not")) {
                return new DicomStatusEqualsNot(stringArray);
            }
            if (iFilterEntryType.getCode().equals("multi_equals_ignore_case")) {
                return new MultiEqualsIgnoreCase(stringArray);
            }
            if (iFilterEntryType.getCode().equals("multi_not_equals")) {
                return new MultiNotEquals(stringArray);
            }
            if (iFilterEntryType.getCode().equals("range")) {
                return new Range(stringArray, n2);
            }
            if (iFilterEntryType.getCode().equals("date_time_range")) {
                return new DateTimeRange(stringArray);
            }
            if (iFilterEntryType.getCode().equals("yesterday_today_time")) {
                return new YesterdayTodayTime(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("yesterday_time")) {
                return new YesterdayTime(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("today_time")) {
                return new TodayTime(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("today")) {
                return new Today(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("previous_scheduled_date")) {
                return new UntilLastDemo(filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("named")) {
                return new Named(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("not_named")) {
                return new NotNamed(stringArray);
            }
            if (iFilterEntryType.getCode().equals("days_old")) {
                return new DaysOld(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("min_years_old")) {
                return new LessThenYearsOld(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("max_years_old")) {
                return new MoreThenYearsOld(stringArray, filterModifiers);
            }
            if (iFilterEntryType.getCode().equals("name_start_with_letters")) {
                return new NameStartsWithLetters(stringArray);
            }
            if (iFilterEntryType.getCode().equals("req_service_not_contains")) {
                return new RequestinServiceNotContains(stringArray);
            }
            if (iFilterEntryType.getCode().equals("req_physician_not_named")) {
                return new RequestinPhysicianNotContains(stringArray);
            }
        }
        catch (Exception exception) {
            log.error("Error", (Throwable)exception);
            return null;
        }
        log.error("Type not found " + iFilterEntryType.getCode());
        return null;
    }

    private static class Contains
    implements ClientSideFilter {
        private String s;

        public Contains(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "contains";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).contains(this.s);
        }
    }

    private static class ContainsIgnoreCase
    implements ClientSideFilter {
        private String s;

        public ContainsIgnoreCase(String[] stringArray) {
            this.s = stringArray[0].toUpperCase(Locale.getDefault());
        }

        @Override
        public String getCode() {
            return "contains_ignore_case";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).contains(this.s);
        }
    }

    private static class DateEquals
    implements ClientSideFilter {
        private Date d;

        public DateEquals(String[] stringArray) {
            this.d = DateUtils.parseDA(null, (String)stringArray[0], (boolean)false);
        }

        @Override
        public String getCode() {
            return "date_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((Date)object).equals(this.d);
        }
    }

    private static class DateNotEquals
    implements ClientSideFilter {
        private Date d;

        public DateNotEquals(String[] stringArray) {
            this.d = DateUtils.parseDA(null, (String)stringArray[0], (boolean)false);
        }

        @Override
        public String getCode() {
            return "date_not_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return !((Date)object).equals(this.d);
        }
    }

    private static class DateTimeRange
    implements ClientSideFilter {
        private Date start;
        private Date finish;

        public DateTimeRange(String[] stringArray) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Not enough arguments");
            }
            this.start = DateUtils.parseDT(null, (String)stringArray[0], (boolean)false, (DatePrecision)new DatePrecision());
            this.finish = DateUtils.parseDT(null, (String)stringArray[1], (boolean)false, (DatePrecision)new DatePrecision());
        }

        @Override
        public String getCode() {
            return "date_time_range";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            Date date = (Date)object;
            return date.after(this.start) && date.before(this.finish);
        }
    }

    private static class DaysOld
    implements ClientSideFilter {
        private Date date;

        public DaysOld(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            Integer n = stringArray == null || stringArray.length == 0 ? Integer.valueOf(0) : Integer.parseInt(stringArray[0]);
            ((Calendar)gregorianCalendar).add(5, -n.intValue());
            this.date = gregorianCalendar.getTime();
        }

        @Override
        public String getCode() {
            return "days_old";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return this.date.before((Date)object);
        }
    }

    private static class DicomStatusEquals
    implements ClientSideFilter {
        private String item = null;
        private boolean searchForUnread = false;

        public DicomStatusEquals(String[] stringArray) {
            this.item = stringArray[0];
            if (FilterSelectionSets.StudyStatusSelectionSet.UNREPORTED_ITEM.isMyCode(this.item)) {
                this.searchForUnread = true;
            }
        }

        @Override
        public String getCode() {
            return "dicom_status_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            if (object == null) {
                return true;
            }
            return !this.searchForUnread || object.equals("COMPLETED");
        }
    }

    private static class DicomStatusEqualsNot
    implements ClientSideFilter {
        private IFilterSelectionSetItem item;

        public DicomStatusEqualsNot(String[] stringArray) {
            IFilterSelectionSetItem[] iFilterSelectionSetItemArray;
            IFilterSelectionSetItem[] iFilterSelectionSetItemArray2 = iFilterSelectionSetItemArray = new FilterSelectionSets.StudyStatusSelectionSet().getSelectionItems();
            int n = iFilterSelectionSetItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFilterSelectionSetItem iFilterSelectionSetItem = iFilterSelectionSetItemArray2[n2];
                if (iFilterSelectionSetItem.getValue().equals(stringArray[0])) {
                    this.item = iFilterSelectionSetItem;
                }
                ++n2;
            }
        }

        @Override
        public String getCode() {
            return "dicom_status_equals_not";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            if (this.item == null) {
                return true;
            }
            return !this.item.isMyCode(object);
        }
    }

    private static class EndsWith
    implements ClientSideFilter {
        private String s;

        public EndsWith(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "end_with";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).endsWith(this.s);
        }
    }

    private static class EndsWithIgnoreCase
    implements ClientSideFilter {
        private String s;

        public EndsWithIgnoreCase(String[] stringArray) {
            this.s = stringArray[0].toUpperCase(Locale.getDefault());
        }

        @Override
        public String getCode() {
            return "end_with_ignore_case";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).endsWith(this.s);
        }
    }

    private static class Equals
    implements ClientSideFilter {
        private String s;

        public Equals(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).equals(this.s);
        }
    }

    private static class EqualsDate
    implements ClientSideFilter {
        private Date date;

        public EqualsDate(String[] stringArray) {
            String string = stringArray[0];
            this.date = new Date(Integer.parseInt(string.substring(0, 4)) - 1900, Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)));
        }

        @Override
        public String getCode() {
            return "equalsIgnoreCase";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((Date)object).equals(this.date);
        }
    }

    private static class EqualsIgnoreCase
    implements ClientSideFilter {
        private String s;

        public EqualsIgnoreCase(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "equalsIgnoreCase";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).equalsIgnoreCase(this.s);
        }
    }

    private static class EqualsIgnoreCasePersonName
    implements ClientSideFilter {
        private Attributes filter = new Attributes(1);

        public EqualsIgnoreCasePersonName(String[] stringArray) {
            this.filter.setString(0x100010, VR.PN, stringArray[0]);
        }

        @Override
        public String getCode() {
            return "equalsIgnoreCase";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            Attributes attributes = new Attributes(1);
            attributes.setString(0x100010, VR.PN, (String)object);
            return attributes.matches(this.filter, true, false);
        }
    }

    private static class LessThenYearsOld
    implements ClientSideFilter {
        private Date date;

        public LessThenYearsOld(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            Integer n = stringArray == null || stringArray.length == 0 ? Integer.valueOf(0) : Integer.parseInt(stringArray[0]);
            ((Calendar)gregorianCalendar).add(1, -n.intValue());
            this.date = gregorianCalendar.getTime();
        }

        @Override
        public String getCode() {
            return "max_years_old";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return this.date.before((Date)object);
        }
    }

    private static class MoreThenYearsOld
    implements ClientSideFilter {
        private Date date;

        public MoreThenYearsOld(String[] stringArray, FilterModifiers filterModifiers) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            Integer n = stringArray == null || stringArray.length == 0 ? Integer.valueOf(0) : Integer.parseInt(stringArray[0]);
            ((Calendar)gregorianCalendar).add(1, -n.intValue());
            this.date = gregorianCalendar.getTime();
        }

        @Override
        public String getCode() {
            return "min_years_old";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return this.date.after((Date)object);
        }
    }

    private static class MultiEqualsIgnoreCase
    implements ClientSideFilter {
        private String s;

        public MultiEqualsIgnoreCase(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "multi_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            if (object instanceof String[]) {
                String[] stringArray;
                String[] stringArray2 = stringArray = (String[])object;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    if (string.equalsIgnoreCase(this.s)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (object instanceof String) {
                String string = (String)object;
                return string.equalsIgnoreCase(this.s);
            }
            return false;
        }
    }

    private static class MultiMatchEquals
    implements ClientSideFilter {
        private String[] s;

        public MultiMatchEquals(String[] stringArray) {
            this.s = stringArray;
        }

        @Override
        public String getCode() {
            return "multi_match_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            if (object instanceof String[]) {
                String[] stringArray;
                String[] stringArray2 = stringArray = (String[])object;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    String[] stringArray3 = this.s;
                    int n3 = this.s.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2 = stringArray3[n4];
                        if (string2.equals(string)) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return false;
            }
            if (object instanceof String) {
                String string = (String)object;
                String[] stringArray = this.s;
                int n = this.s.length;
                int n5 = 0;
                while (n5 < n) {
                    String string3 = stringArray[n5];
                    if (string3.equals(string)) {
                        return true;
                    }
                    ++n5;
                }
            }
            return false;
        }
    }

    private static class MultiNotEquals
    implements ClientSideFilter {
        private String s;

        public MultiNotEquals(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "multi_not_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            String[] stringArray;
            String[] stringArray2 = stringArray = (String[])object;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (string.equalsIgnoreCase(this.s)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    private static class NDayTime
    implements ClientSideFilter {
        private Date start;
        private Date finish;

        private NDayTime() {
        }

        public void init(String[] stringArray, FilterModifiers filterModifiers, int n, int n2) {
            Date date;
            Date date2 = date = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (date == null) {
                date = new Date();
            }
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(DateUtils.parseTM(null, (String)stringArray[0], (boolean)false, (DatePrecision)new DatePrecision()));
            Calendar calendar2 = GregorianCalendar.getInstance();
            calendar2.setTime(date);
            if (n != 0) {
                calendar2.add(6, -n);
            }
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, 0);
            this.start = calendar2.getTime();
            calendar.setTime(DateUtils.parseTM(null, (String)stringArray[1], (boolean)false, (DatePrecision)new DatePrecision()));
            calendar2.setTime(date);
            if (n != 0) {
                calendar2.add(6, -n2);
            }
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, 59);
            this.finish = calendar2.getTime();
        }

        @Override
        public String getCode() {
            return "nday_time";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            Date date = (Date)object;
            return date.after(this.start) && date.before(this.finish);
        }
    }

    private static class NameStartsWithLetters
    implements ClientSideFilter {
        private String[] letters;

        public NameStartsWithLetters(String[] stringArray) {
            this.letters = stringArray;
        }

        @Override
        public boolean filteredOnClient(Object object) {
            String string;
            try {
                string = ((String)object).substring(0, 1);
            }
            catch (Exception exception) {
                return true;
            }
            String[] stringArray = this.letters;
            int n = this.letters.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2.equalsIgnoreCase(string)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public String getCode() {
            return "name_start_with_letters";
        }
    }

    private static class Named
    implements ClientSideFilter {
        protected Pattern pat;
        private static final String[][] conversions = new String[][]{{"\u00c4", "\u00c4|AE"}, {"\u00d6", "\u00d6|OE"}, {"\u00dc", "\u00dc|UE"}, {"\u00df", "\u00df|SS|SZ"}};

        public Named(String[] stringArray, FilterModifiers filterModifiers) {
            Boolean bl;
            String[] stringArray2 = new String[Math.max(stringArray.length, 2)];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = stringArray.length > n ? stringArray[n] : "*";
                ++n;
            }
            if (stringArray2[1] == null) {
                stringArray2[1] = "";
            }
            if (stringArray2[0].length() != 0 && !stringArray2[0].endsWith("*")) {
                stringArray2[0] = String.valueOf(stringArray2[0]) + "*";
            }
            if (stringArray2[1].length() != 0 && !stringArray2[1].endsWith("*")) {
                stringArray2[1] = String.valueOf(stringArray2[1]) + "*";
            }
            if (stringArray2[0].length() == 0) {
                stringArray2[0] = "*";
            }
            if (stringArray2[1].length() == 0) {
                stringArray2[1] = "*";
            }
            if (stringArray2[1].equals("*")) {
                stringArray2[1] = null;
            }
            String string = stringArray2[1] == null ? stringArray2[0] : String.valueOf(stringArray[0]) + "\\^" + stringArray2[1];
            string = string.toUpperCase(Locale.getDefault());
            string = string.replace("*", ".*");
            Boolean bl2 = filterModifiers != null ? (Boolean)filterModifiers.getModifierValue(FilterModifiers.SemanticPNMatchingRequested) : null;
            Boolean bl3 = filterModifiers != null ? (Boolean)filterModifiers.getModifierValue(FilterModifiers.SemanticPNMatchingNegotiated) : null;
            Boolean bl4 = bl = filterModifiers != null ? (Boolean)filterModifiers.getModifierValue(FilterUtilities.SemanticPNMatchingRequestedSystemOverride) : null;
            if (ConfigUtilities.isGerman() && (bl3 == null || Boolean.FALSE.equals(bl3)) && (bl2 != null && Boolean.TRUE.equals(bl2) || bl2 != null && Boolean.FALSE.equals(bl2) && bl != null && Boolean.TRUE.equals(bl))) {
                String[][] stringArray3 = conversions;
                int n2 = conversions.length;
                int n3 = 0;
                while (n3 < n2) {
                    String[] stringArray4 = stringArray3[n3];
                    if (string.contains(stringArray4[0])) {
                        string = string.replace(stringArray4[0], "(" + stringArray4[1] + ")");
                    }
                    ++n3;
                }
            }
            this.pat = Pattern.compile(string);
        }

        @Override
        public String getCode() {
            return "named";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return this.pat.matcher(((String)object).toUpperCase(Locale.getDefault())).matches();
        }
    }

    private static class NotContains
    implements ClientSideFilter {
        private String s;

        public NotContains(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "not_contains";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            if (object instanceof String) {
                return !this.contains(new String[]{(String)object}, this.s);
            }
            if (object instanceof String[]) {
                return !this.contains((String[])object, this.s);
            }
            return false;
        }

        private boolean contains(String[] stringArray, String string) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2;
                String string3 = stringArray2[n2];
                String string4 = string3 != null ? string3.toUpperCase(Locale.getDefault()) : null;
                String string5 = string2 = string != null ? string.toUpperCase(Locale.getDefault()) : null;
                if (string4 != null && string2 != null && string4.contains(string2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    private static class NotEquals
    implements ClientSideFilter {
        private String s;

        public NotEquals(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "not_equals";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return !((String)object).equals(this.s);
        }
    }

    private static class NotEqualsIgnoreCase
    implements ClientSideFilter {
        private String s;

        public NotEqualsIgnoreCase(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "not_equalsIgnoreCase";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return !((String)object).equalsIgnoreCase(this.s);
        }
    }

    private static class NotNamed
    implements ClientSideFilter {
        Pattern pat;

        public NotNamed(String[] stringArray) {
            String[] stringArray2 = new String[Math.max(stringArray.length, 2)];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = stringArray.length > n ? stringArray[n] : "*";
                ++n;
            }
            if (stringArray2[0].length() != 0 && !stringArray2[0].endsWith("*")) {
                stringArray2[0] = String.valueOf(stringArray2[0]) + "*";
            }
            if (stringArray2[1].length() != 0 && !stringArray2[1].endsWith("*")) {
                stringArray2[1] = String.valueOf(stringArray2[1]) + "*";
            }
            if (stringArray2[0].length() == 0) {
                stringArray2[0] = "*";
            }
            if (stringArray2[1].length() == 0) {
                stringArray2[1] = "*";
            }
            String string = stringArray2[0];
            if (!stringArray2[1].equals("*")) {
                string = String.valueOf(string) + "\\^" + stringArray2[1];
            }
            string = string.toUpperCase(Locale.getDefault());
            string = string.replace("*", ".*");
            this.pat = Pattern.compile(string);
        }

        @Override
        public String getCode() {
            return "not_named";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return !this.pat.matcher(((String)object).toUpperCase(Locale.getDefault())).matches();
        }
    }

    private static class Range
    implements ClientSideFilter {
        private Date start;
        private Date finish;

        public Range(String[] stringArray, int n) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Not enough arguments");
            }
            this.start = VR.TM.code() == n ? DateUtils.parseTM(null, (String)stringArray[0], (boolean)false, (DatePrecision)new DatePrecision()) : DateUtils.parseDA(null, (String)stringArray[0], (boolean)false);
            Date date = this.finish = VR.TM.code() == n ? DateUtils.parseTM(null, (String)stringArray[1], (boolean)false, (DatePrecision)new DatePrecision()) : DateUtils.parseDA(null, (String)stringArray[1], (boolean)false);
            if (this.finish.before(this.start)) {
                Date date2 = this.start;
                this.start = this.finish;
                this.finish = date2;
            }
        }

        @Override
        public String getCode() {
            return "range";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            Date date = (Date)object;
            return date.after(this.start) && date.before(this.finish);
        }
    }

    private static class RequestinPhysicianNotContains
    extends NotContains {
        public RequestinPhysicianNotContains(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public String getCode() {
            return "req_physician_not_named";
        }
    }

    private static class RequestinServiceNotContains
    extends NotContains {
        public RequestinServiceNotContains(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public String getCode() {
            return "req_service_not_contains";
        }
    }

    private static class StartsWith
    implements ClientSideFilter {
        private String s;

        public StartsWith(String[] stringArray) {
            this.s = stringArray[0];
        }

        @Override
        public String getCode() {
            return "starts_with";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).startsWith(this.s);
        }
    }

    private static class StartsWithIgnoreCase
    implements ClientSideFilter {
        private String s;

        public StartsWithIgnoreCase(String[] stringArray) {
            this.s = stringArray[0].toUpperCase(Locale.getDefault());
        }

        @Override
        public String getCode() {
            return "starts_with_ignore_case";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((String)object).startsWith(this.s);
        }
    }

    private static class Today
    implements ClientSideFilter {
        private Date today;

        public Today(String[] stringArray, FilterModifiers filterModifiers) {
            Date date = this.today = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (this.today == null) {
                this.today = new Date();
            }
        }

        @Override
        public String getCode() {
            return "today";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            return ((Date)object).equals(this.today);
        }
    }

    private static class TodayTime
    extends NDayTime {
        public TodayTime(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Not enough arguments");
            }
            this.init(stringArray, filterModifiers, 0, 0);
        }

        @Override
        public String getCode() {
            return "today_time";
        }
    }

    private static class UntilLastDemo
    implements ClientSideFilter {
        private Date today;
        private Date datePreviousDemo;

        public UntilLastDemo(FilterModifiers filterModifiers) {
            Date date = this.datePreviousDemo = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.PreviousDemoDate) : null;
            if (this.datePreviousDemo == null) {
                this.datePreviousDemo = new Date();
            }
            Date date2 = this.today = filterModifiers != null ? (Date)filterModifiers.getModifierValue(FilterUtilities.ReferenceDate) : null;
            if (this.today == null) {
                this.today = new Date();
            }
        }

        @Override
        public String getCode() {
            return "previous_scheduled_date";
        }

        @Override
        public boolean filteredOnClient(Object object) {
            Date date = (Date)object;
            return date.after(this.datePreviousDemo) && date.before(this.today);
        }
    }

    private static class YesterdayTime
    extends NDayTime {
        public YesterdayTime(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Not enough arguments");
            }
            this.init(stringArray, filterModifiers, 1, 1);
        }

        @Override
        public String getCode() {
            return "yesterday_time";
        }
    }

    private static class YesterdayTodayTime
    extends NDayTime {
        public YesterdayTodayTime(String[] stringArray, FilterModifiers filterModifiers) {
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("Not enough arguments");
            }
            this.init(stringArray, filterModifiers, 1, 0);
        }

        @Override
        public String getCode() {
            return "yesterday_today_time";
        }
    }
}

