/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter.advanced;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.ClientSideFactory;
import com.agfa.pacs.listtext.lta.filter.advanced.ClientSideFilter;
import com.agfa.pacs.listtext.lta.filter.advanced.IAdvancedFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.IClientSideFilterEntryType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.VR;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvancedFilterEntry
implements IAdvancedFilterEntry {
    private List<ISimpleFilterEntry> searchEntries = new ArrayList<ISimpleFilterEntry>();
    private List<ClientSideFilter> clientFilter = new ArrayList<ClientSideFilter>();
    private int intvr;
    private FilterModifiers modifiers;

    public AdvancedFilterEntry() {
    }

    public AdvancedFilterEntry(ISimpleFilterEntry iSimpleFilterEntry) {
        this();
        this.searchEntries.add(iSimpleFilterEntry);
    }

    @Override
    public void save(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            iConfigurationProvider.setString("type", this.getCode());
            if (this.searchEntries.size() == 1) {
                this.searchEntries.get(0).save(iConfigurationProvider);
            } else {
                IConfigurationList iConfigurationList = iConfigurationProvider.createList("sub_entries");
                for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                    IConfigurationProvider iConfigurationProvider2 = iConfigurationList.appendItem();
                    iSimpleFilterEntry.save(iConfigurationProvider2);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public void init(IConfigurationProvider iConfigurationProvider) throws IOException {
        if (iConfigurationProvider == null) {
            throw new IOException("Configuration Provider is null!");
        }
        try {
            if (!iConfigurationProvider.exists("sub_entries")) {
                SimpleFilterEntry simpleFilterEntry = new SimpleFilterEntry();
                simpleFilterEntry.init(iConfigurationProvider);
                this.searchEntries.add(simpleFilterEntry);
            } else {
                IConfigurationList iConfigurationList = iConfigurationProvider.getList("sub_entries");
                for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
                    SimpleFilterEntry simpleFilterEntry = new SimpleFilterEntry();
                    simpleFilterEntry.init(iConfigurationProvider2);
                    this.searchEntries.add(simpleFilterEntry);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public String saveToXML() throws IOException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<advancedEntry ");
            stringBuilder.append("type=\"");
            stringBuilder.append(this.getCode());
            stringBuilder.append("\">");
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                stringBuilder.append(iSimpleFilterEntry.saveToXML());
            }
            stringBuilder.append("</advancedEntry>");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public void initFromXML(Node node) throws IOException {
        try {
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                this.searchEntries = new ArrayList<ISimpleFilterEntry>(nodeList.getLength());
                int n = 0;
                while (n < nodeList.getLength()) {
                    SimpleFilterEntry simpleFilterEntry = new SimpleFilterEntry();
                    simpleFilterEntry.initFromXML(nodeList.item(n));
                    this.searchEntries.add(simpleFilterEntry);
                    ++n;
                }
            } else {
                this.searchEntries = Collections.emptyList();
            }
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    @Override
    public IAdvancedFilterEntry clone() {
        AdvancedFilterEntry advancedFilterEntry = new AdvancedFilterEntry();
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            advancedFilterEntry.searchEntries.add((SimpleFilterEntry)iSimpleFilterEntry.clone());
        }
        return advancedFilterEntry;
    }

    @Override
    public List<ISimpleFilterEntry> getEntries() {
        return this.searchEntries;
    }

    @Override
    public boolean isPerformingOnClient(boolean bl, boolean bl2) {
        if (this.searchEntries.size() == 0) {
            return false;
        }
        if (this.searchEntries.size() > 1) {
            if (!bl) {
                return true;
            }
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                if (!(iSimpleFilterEntry.getType() instanceof IClientSideFilterEntryType)) continue;
                return true;
            }
            return false;
        }
        ISimpleFilterEntry iSimpleFilterEntry = this.searchEntries.get(0);
        return iSimpleFilterEntry.getType() instanceof IClientSideFilterEntryType;
    }

    @Override
    public Level getLevel() {
        if (this.searchEntries.size() >= 1) {
            return this.searchEntries.get(0).getLevel();
        }
        return Level.Patient;
    }

    @Override
    public void modifyDataset(Attributes attributes, FilterModifiers filterModifiers) {
        if (this.searchEntries.size() == 1) {
            ISimpleFilterEntry iSimpleFilterEntry = this.searchEntries.get(0);
            if (iSimpleFilterEntry.getType() instanceof IClientSideFilterEntryType) {
                ((IClientSideFilterEntryType)iSimpleFilterEntry.getType()).modifyDataset(iSimpleFilterEntry, attributes, filterModifiers);
            } else if (this.isEnabled()) {
                iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes, filterModifiers);
            }
        }
    }

    @Override
    public List<Attributes> modifyDatasets(List<Attributes> list, FilterModifiers filterModifiers) {
        if (this.searchEntries.size() == 1) {
            ISimpleFilterEntry iSimpleFilterEntry = this.searchEntries.get(0);
            if (iSimpleFilterEntry.getType() instanceof IClientSideFilterEntryType) {
                for (Attributes attributes : list) {
                    ((IClientSideFilterEntryType)iSimpleFilterEntry.getType()).modifyDataset(iSimpleFilterEntry, attributes, filterModifiers);
                }
            } else if (this.isEnabled()) {
                for (Attributes attributes : list) {
                    iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes, filterModifiers);
                }
            }
            return list;
        }
        if (this.isORMatchSupported(filterModifiers)) {
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                for (Attributes attributes : list) {
                    iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes, filterModifiers);
                }
            }
            return list;
        }
        for (ISimpleFilterEntry object2 : this.searchEntries) {
            if (!(object2.getType() instanceof IClientSideFilterEntryType)) continue;
            return list;
        }
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (Attributes attributes : list) {
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                Attributes attributes2 = new Attributes(attributes);
                iSimpleFilterEntry.getType().modifyDataset(iSimpleFilterEntry, attributes2, filterModifiers);
                arrayList.add(attributes2);
            }
        }
        return arrayList;
    }

    @Override
    public boolean isModified() {
        for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
            if (!iSimpleFilterEntry.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        if (this.searchEntries != null) {
            for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                if (!iSimpleFilterEntry.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean prepareClientSideFiltering(FilterModifiers filterModifiers) {
        ISimpleFilterEntry iSimpleFilterEntry2;
        ClientSideFilter clientSideFilter = null;
        this.clientFilter.clear();
        for (ISimpleFilterEntry iSimpleFilterEntry2 : this.searchEntries) {
            try {
                clientSideFilter = ClientSideFactory.getFilter(iSimpleFilterEntry2.getType(), iSimpleFilterEntry2.getSearchStrings(), iSimpleFilterEntry2.getCriterion().getTag(), iSimpleFilterEntry2.getCriterion().getVR(), filterModifiers);
                if (clientSideFilter == null) continue;
                this.clientFilter.add(clientSideFilter);
            }
            catch (Exception exception) {}
        }
        iSimpleFilterEntry2 = this.searchEntries.get(0).getCriterion().getVR();
        this.intvr = iSimpleFilterEntry2.code();
        this.modifiers = filterModifiers;
        return !this.clientFilter.isEmpty();
    }

    private boolean evaluateNoMatchForNoValue(FilterModifiers filterModifiers) {
        Boolean bl;
        Boolean bl2 = bl = filterModifiers != null ? (Boolean)filterModifiers.getModifierValue(FilterUtilities.NoMatchForNoValue) : null;
        if (bl == null) {
            return true;
        }
        return bl == false;
    }

    @Override
    public boolean filteredOnClient(IDataInfo iDataInfo) {
        Integer n = this.getTag();
        if (n == 524385) {
            return this.filterOnModalitiesInStudy(iDataInfo, n);
        }
        if (n == 524336) {
            return this.filterOnStudyTime(iDataInfo);
        }
        if (n == 3276810) {
            return this.filterOnStudyStatusID(iDataInfo, n);
        }
        if (n == 3280946) {
            return this.filterOnRequestingPhysician(iDataInfo);
        }
        if (n == 3280947) {
            return this.filterOnRequestingService(iDataInfo);
        }
        if (this.intvr == VR.DA.code() || this.intvr == VR.DT.code() || this.intvr == VR.TM.code()) {
            return this.filterOnDateTime(iDataInfo, n);
        }
        String string = iDataInfo.getAttributes().getString(n.intValue(), null);
        while (string == null && iDataInfo.getTreeParent() != null) {
            iDataInfo = iDataInfo.getTreeParent();
            string = iDataInfo.getAttributes().getString(n.intValue(), null);
        }
        if (string == null) {
            return this.evaluateNoMatchForNoValue(this.modifiers);
        }
        for (ClientSideFilter clientSideFilter : this.clientFilter) {
            if (!clientSideFilter.filteredOnClient(string)) continue;
            return true;
        }
        return false;
    }

    private boolean filterOnDateTime(IDataInfo iDataInfo, Integer n) {
        Date date = iDataInfo.getAttributes().getDate(n.intValue());
        while (date == null && iDataInfo.getTreeParent() != null) {
            iDataInfo = iDataInfo.getTreeParent();
            date = iDataInfo.getAttributes().getDate(n.intValue());
        }
        if (date == null) {
            return this.evaluateNoMatchForNoValue(this.modifiers);
        }
        for (ClientSideFilter clientSideFilter : this.clientFilter) {
            if (!clientSideFilter.filteredOnClient(date)) continue;
            return true;
        }
        return false;
    }

    private boolean filterOnRequestingService(IDataInfo iDataInfo) {
        IDataInfo iDataInfo2 = iDataInfo;
        while (iDataInfo2 != null) {
            String string;
            Attributes attributes = iDataInfo.getAttributes().getNestedDataset(new ItemPointer[]{new ItemPointer(4194933, 0)});
            if (attributes != null && (string = attributes.getString(3280947, null)) != null) {
                for (ClientSideFilter clientSideFilter : this.clientFilter) {
                    if (!clientSideFilter.filteredOnClient(string)) continue;
                    return true;
                }
            }
            iDataInfo2 = iDataInfo2.getTreeParent();
        }
        return this.evaluateNoMatchForNoValue(this.modifiers);
    }

    private boolean filterOnRequestingPhysician(IDataInfo iDataInfo) {
        IDataInfo iDataInfo2 = iDataInfo;
        while (iDataInfo2 != null) {
            String string;
            Attributes attributes = iDataInfo.getAttributes().getNestedDataset(new ItemPointer[]{new ItemPointer(4194933, 0)});
            if (attributes != null && (string = attributes.getString(3280946, null)) != null) {
                for (ClientSideFilter clientSideFilter : this.clientFilter) {
                    if (!clientSideFilter.filteredOnClient(string)) continue;
                    return true;
                }
            }
            iDataInfo2 = iDataInfo2.getTreeParent();
        }
        return this.evaluateNoMatchForNoValue(this.modifiers);
    }

    private boolean filterOnStudyStatusID(IDataInfo iDataInfo, Integer n) {
        String string = iDataInfo.getAttributes().getString(n.intValue(), null);
        while (string == null && iDataInfo.getTreeParent() != null) {
            if ((iDataInfo = iDataInfo.getTreeParent()) instanceof IPatientInfo) break;
            string = iDataInfo.getAttributes().getString(n.intValue(), null);
        }
        for (ClientSideFilter clientSideFilter : this.clientFilter) {
            if (!clientSideFilter.filteredOnClient(string)) continue;
            return true;
        }
        return false;
    }

    private boolean filterOnStudyTime(IDataInfo iDataInfo) {
        Date date = iDataInfo.getAttributes().getDate(2251937253163056L);
        while (date == null && iDataInfo.getTreeParent() != null) {
            if ((iDataInfo = iDataInfo.getTreeParent()) instanceof IPatientInfo) break;
            date = iDataInfo.getAttributes().getDate(2251937253163056L);
        }
        if (date == null) {
            return this.evaluateNoMatchForNoValue(this.modifiers);
        }
        for (ClientSideFilter clientSideFilter : this.clientFilter) {
            if (!clientSideFilter.filteredOnClient(date)) continue;
            return true;
        }
        return false;
    }

    private boolean filterOnModalitiesInStudy(IDataInfo iDataInfo, Integer n) {
        String[] stringArray = iDataInfo.getAttributes().getStrings(n.intValue());
        while (stringArray == null && iDataInfo.getTreeParent() != null) {
            if ((iDataInfo = iDataInfo.getTreeParent()) instanceof IPatientInfo) break;
            stringArray = iDataInfo.getAttributes().getStrings(n.intValue());
        }
        if (stringArray == null) {
            return this.evaluateNoMatchForNoValue(this.modifiers);
        }
        for (ClientSideFilter clientSideFilter : this.clientFilter) {
            if (!clientSideFilter.filteredOnClient(stringArray)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISimpleFilterEntry addNewSubEntry() {
        ISimpleFilterEntry iSimpleFilterEntry = (ISimpleFilterEntry)this.searchEntries.get(0).clone();
        this.searchEntries.add(iSimpleFilterEntry);
        return iSimpleFilterEntry;
    }

    @Override
    public void removeSubEntry(ISimpleFilterEntry iSimpleFilterEntry) {
        if (iSimpleFilterEntry != null && this.searchEntries.contains(iSimpleFilterEntry)) {
            this.searchEntries.remove(iSimpleFilterEntry);
        }
    }

    @Override
    public Integer getTag() {
        if (this.searchEntries != null && !this.searchEntries.isEmpty()) {
            return this.searchEntries.get(0).getCriterion().getTag();
        }
        return null;
    }

    @Override
    public String getCode() {
        return "basic";
    }

    private boolean isORMatchSupported(FilterModifiers filterModifiers) {
        Boolean bl = (Boolean)filterModifiers.getModifierValue(FilterUtilities.OrMatchesSupported);
        if (bl != null && Boolean.TRUE.equals(bl)) {
            boolean bl2 = false;
            block3: for (ISimpleFilterEntry iSimpleFilterEntry : this.searchEntries) {
                if (iSimpleFilterEntry == null || iSimpleFilterEntry.getType() == null || !iSimpleFilterEntry.getType().supportsORMatch()) {
                    bl2 = true;
                    break;
                }
                int n = iSimpleFilterEntry.getCriterion().getTag();
                switch (n) {
                    case 524368: 
                    case 524384: 
                    case 524385: 
                    case 0x100020: 
                    case 0x100040: 
                    case 1572885: 
                    case 0x200010: 
                    case 0x200011: 
                    case 2097171: 
                    case 0x200060: 
                    case 3276810: 
                    case 3280947: 
                    case 4390932: {
                        boolean bl3 = false;
                        String[] stringArray = iSimpleFilterEntry.getSearchStrings();
                        if (stringArray != null) {
                            String[] stringArray2 = stringArray;
                            int n2 = stringArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String string = stringArray2[n3];
                                if (string.contains("*") || string.contains("?")) {
                                    bl3 = true;
                                    break;
                                }
                                ++n3;
                            }
                        }
                        if (!bl3) continue block3;
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                if (bl2) break;
            }
            return !bl2;
        }
        return false;
    }

    public String toString() {
        return this.searchEntries.toString();
    }
}

