/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter.advanced;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.IPatientHierarchy;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.filter.IFilterListener;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedEntryRegistry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.IAdvancedFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.IAdvancedFilterListener;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.dcm4che3.data.Attributes;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvancedFilter
implements IPersistantFilter,
Cloneable {
    private static final ALogger log = ALogger.getLogger(AdvancedFilter.class);
    private String name = null;
    private List<IAdvancedFilterEntry> searchEntries = new Vector<IAdvancedFilterEntry>();
    private List<IFilterListener> listener = new ArrayList<IFilterListener>();
    private FilterModifiers modifiers;
    private Level minLevel = null;
    private boolean modified;

    public AdvancedFilter() {
        this("Filter Name");
        this.modifiers = this.createDefaultModifiers();
    }

    public AdvancedFilter(String string) {
        this.name = string;
        this.modified = false;
        this.modifiers = this.createDefaultModifiers();
    }

    public AdvancedFilter(List<IAdvancedFilterEntry> list) {
        this();
        if (list != null) {
            this.searchEntries.addAll(list);
        }
    }

    public AdvancedFilter(AdvancedFilter advancedFilter) {
        this(advancedFilter.getName());
        this.minLevel = advancedFilter.minLevel;
        if (advancedFilter.modifiers != null) {
            this.modifiers = advancedFilter.modifiers.copy();
        }
        if (advancedFilter.searchEntries != null) {
            for (IAdvancedFilterEntry iAdvancedFilterEntry : advancedFilter.searchEntries) {
                IAdvancedFilterEntry iAdvancedFilterEntry2 = iAdvancedFilterEntry.clone();
                if (!iAdvancedFilterEntry2.isEnabled()) continue;
                this.searchEntries.add(iAdvancedFilterEntry2);
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.modified || this.entriesModified();
    }

    @Override
    public void setMinLevel(Level level) {
        this.minLevel = level;
        this.modified = true;
    }

    public <T> T getModifierValue(FilterModifiers.IFilterModifier<T> iFilterModifier) {
        return (T)this.modifiers.getModifierValue(iFilterModifier);
    }

    public <T> void putModifierValue(FilterModifiers.IFilterModifier<T> iFilterModifier, T t) {
        this.modifiers.putModifierValue(iFilterModifier, t);
    }

    public FilterModifiers getModifiers() {
        return this.modifiers;
    }

    public List<IAdvancedFilterEntry> getEntries() {
        return this.searchEntries;
    }

    public void addEntry(IAdvancedFilterEntry iAdvancedFilterEntry) {
        if (iAdvancedFilterEntry != null && !this.searchEntries.contains(iAdvancedFilterEntry)) {
            this.searchEntries.add(iAdvancedFilterEntry);
            this.modified = true;
            this.fireSearchEntryAdded(iAdvancedFilterEntry);
        }
    }

    public void addEntry(SimpleFilterEntry simpleFilterEntry) {
        if (simpleFilterEntry != null) {
            AdvancedFilterEntry advancedFilterEntry = new AdvancedFilterEntry(simpleFilterEntry);
            this.searchEntries.add(advancedFilterEntry);
            this.modified = true;
            this.fireSearchEntryAdded(advancedFilterEntry);
        }
    }

    public void removeEntry(IAdvancedFilterEntry iAdvancedFilterEntry) {
        if (this.searchEntries.contains(iAdvancedFilterEntry)) {
            this.searchEntries.remove(iAdvancedFilterEntry);
            this.modified = true;
            this.fireSearchEntryRemoved(iAdvancedFilterEntry);
        }
    }

    @Override
    public void removeAllEntries() {
        this.searchEntries.clear();
        this.modified = true;
        this.fireAllSearchEntriesRemoved();
    }

    @Override
    public AdvancedFilter cloneFilter() {
        AdvancedFilter advancedFilter = new AdvancedFilter(this);
        return advancedFilter;
    }

    private void removeElementFromTree(IDataInfo iDataInfo) {
        if (iDataInfo.getTreeParent() == null) {
            return;
        }
        IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
        iDataInfo2.removeChild(iDataInfo);
        if (iDataInfo2.children().size() == 0) {
            this.removeElementFromTree(iDataInfo2);
        }
    }

    private Class<? extends IDataInfo> getDataInfoClassForLevel(Level level) {
        switch (level) {
            case Patient: {
                return IPatientInfo.class;
            }
            case Study: {
                return IStudyInfo.class;
            }
            case Series: {
                return ISeriesInfo.class;
            }
            case Object: {
                return IObjectInfo.class;
            }
        }
        return IPatientInfo.class;
    }

    @Override
    public IRootInfo filterOnClient(IRootInfo iRootInfo, boolean bl, boolean bl2) {
        IAdvancedFilterEntry iAdvancedFilterEntry2;
        ArrayList<IAdvancedFilterEntry> arrayList = new ArrayList<IAdvancedFilterEntry>();
        Boolean bl3 = (Boolean)this.getModifierValue(FilterModifiers.SemanticPNMatchingNegotiated);
        for (IAdvancedFilterEntry iAdvancedFilterEntry2 : this.searchEntries) {
            if (!iAdvancedFilterEntry2.isEnabled() || !bl && !iAdvancedFilterEntry2.isPerformingOnClient(bl2, bl3 != null && Boolean.TRUE.equals(bl3)) || !iAdvancedFilterEntry2.prepareClientSideFiltering(this.modifiers)) continue;
            arrayList.add(iAdvancedFilterEntry2);
        }
        if (arrayList.isEmpty()) {
            return iRootInfo;
        }
        iAdvancedFilterEntry2 = this.getLeafLevel();
        Level level = this.getMinLevel();
        if (level != null) {
            List list = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, this.getDataInfoClassForLevel(level));
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                IDataInfo iDataInfo = (IDataInfo)listIterator.next();
                ListIterator listIterator2 = DataInfoUtilities.getLevel((IDataInfo)iDataInfo, this.getDataInfoClassForLevel((Level)iAdvancedFilterEntry2)).listIterator();
                boolean bl4 = false;
                while (listIterator2.hasNext()) {
                    IDataInfo iDataInfo2 = (IDataInfo)listIterator2.next();
                    boolean bl5 = false;
                    for (IAdvancedFilterEntry iAdvancedFilterEntry3 : arrayList) {
                        if (iAdvancedFilterEntry3.filteredOnClient(iDataInfo2)) continue;
                        bl5 = true;
                        break;
                    }
                    if (bl5) continue;
                    bl4 = true;
                    break;
                }
                if (bl4) continue;
                this.removeElementFromTree(iDataInfo);
            }
        } else {
            List list = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, this.getDataInfoClassForLevel((Level)iAdvancedFilterEntry2));
            ListIterator listIterator = list.listIterator();
            block4: while (listIterator.hasNext()) {
                IDataInfo iDataInfo = (IDataInfo)listIterator.next();
                for (IAdvancedFilterEntry iAdvancedFilterEntry4 : arrayList) {
                    if (iAdvancedFilterEntry4.filteredOnClient(iDataInfo)) continue;
                    this.removeElementFromTree(iDataInfo);
                    continue block4;
                }
            }
        }
        return iRootInfo;
    }

    @Override
    public void save(IConfigurationProvider iConfigurationProvider) throws IOException {
        this.saveXML(iConfigurationProvider);
    }

    @Override
    public void init(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            boolean bl = iConfigurationProvider.exists("advancedFilterXML");
            if (bl) {
                this.initXML(iConfigurationProvider);
            } else {
                this.initLegacy(iConfigurationProvider);
            }
            this.modified = false;
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    public Level getLeafLevel() {
        if (this.hasNoEnabledEntries()) {
            return Level.Patient;
        }
        Level level = Level.Patient;
        for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
            Level level2 = iAdvancedFilterEntry.getLevel();
            if (!iAdvancedFilterEntry.isEnabled() || level2 == null || level2.getLevel() <= level.getLevel()) continue;
            level = iAdvancedFilterEntry.getLevel();
        }
        if (this.minLevel != null && level == Level.Patient && this.minLevel != Level.Patient) {
            return this.minLevel;
        }
        return level;
    }

    private boolean hasNoEnabledEntries() {
        if (this.searchEntries.isEmpty()) {
            return true;
        }
        for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
            if (!iAdvancedFilterEntry.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public Level getRootLevel() {
        if (this.hasNoEnabledEntries()) {
            return Level.Patient;
        }
        Level level = Level.Object;
        for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
            Level level2 = iAdvancedFilterEntry.getLevel();
            if (!iAdvancedFilterEntry.isEnabled() || level2 == null || level2.getLevel() >= level.getLevel()) continue;
            level = iAdvancedFilterEntry.getLevel();
        }
        return level;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        Attributes attributes = new Attributes();
        Boolean bl = (Boolean)this.getModifierValue(FilterModifiers.SemanticPNMatchingRequested);
        try {
            this.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, false);
            for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
                if (!iAdvancedFilterEntry.isEnabled()) continue;
                iAdvancedFilterEntry.modifyDataset(attributes, this.modifiers);
            }
        }
        finally {
            this.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, bl);
        }
        if (attributes.isEmpty()) {
            for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
                if (!iAdvancedFilterEntry.isEnabled() || !iAdvancedFilterEntry.isPerformingOnClient(false, false)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Attributes getAsDicomObject() {
        Attributes attributes = new Attributes();
        for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
            iAdvancedFilterEntry.modifyDataset(attributes, this.modifiers);
        }
        if (attributes.isEmpty()) {
            FilterUtilities.putValue((Object)"*", 0x100010, attributes);
        }
        return attributes;
    }

    public List<Attributes> getLevel(Level level) {
        List<Attributes> list = new ArrayList<Attributes>();
        list.add(new Attributes());
        for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
            if (!iAdvancedFilterEntry.isEnabled() || iAdvancedFilterEntry.getLevel() != level) continue;
            list = iAdvancedFilterEntry.modifyDatasets(list, this.modifiers);
        }
        return list;
    }

    public Level getMinLevel() {
        return this.minLevel;
    }

    @Override
    public String getFilterName() {
        return this.name;
    }

    @Override
    public void setFilterName(String string) {
        this.name = string;
        this.modified = true;
    }

    @Override
    public void addFilterListener(IFilterListener iFilterListener) {
        this.listener.add(iFilterListener);
    }

    @Override
    public void removeFilterListener(IFilterListener iFilterListener) {
        this.listener.remove(iFilterListener);
    }

    @Override
    public String toXML() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<advancedFilter ");
        stringBuilder.append("filter_name=\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\" filter_type=\"A\" filter_minimum_level=\"");
        stringBuilder.append(this.minLevel != null ? this.minLevel.getLevel() : -1);
        stringBuilder.append("\"");
        Boolean bl = (Boolean)this.getModifierValue(FilterModifiers.SemanticPNMatchingRequested);
        if (bl != null) {
            stringBuilder.append(" semantic-PN-matching-requested=\"");
            stringBuilder.append(bl.toString());
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        if (this.searchEntries != null) {
            for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
                if (!this.shouldSaveEntry(iAdvancedFilterEntry)) continue;
                try {
                    stringBuilder.append(iAdvancedFilterEntry.saveToXML());
                }
                catch (Exception exception) {
                    log.error("Storing advanced filter entry failed - Skipped!", (Throwable)exception);
                }
            }
        }
        stringBuilder.append("</advancedFilter>");
        return stringBuilder.toString();
    }

    private FilterModifiers createDefaultModifiers() {
        FilterModifiers filterModifiers = new FilterModifiers();
        try {
            filterModifiers.putModifierValue(FilterUtilities.NoMatchForNoValue, (Object)ConfigurationProviderFactory.getConfig().getBoolean("listtext.search.noMatchForNoValue"));
            filterModifiers.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, (Object)ConfigurationProviderFactory.getConfig().getBoolean("listtext.search.semanticPNMatchingEnabledByDefault"));
        }
        catch (Exception exception) {
            log.error("Initializing default filter modifiers failed!", (Throwable)exception);
        }
        return filterModifiers;
    }

    private boolean shouldSaveEntry(IAdvancedFilterEntry iAdvancedFilterEntry) {
        List<ISimpleFilterEntry> list;
        if (iAdvancedFilterEntry != null && (list = iAdvancedFilterEntry.getEntries()) != null && !list.isEmpty()) {
            for (ISimpleFilterEntry iSimpleFilterEntry : list) {
                String[] stringArray = iSimpleFilterEntry.getSearchStrings();
                if (stringArray == null && (iSimpleFilterEntry.getType().getCode().equalsIgnoreCase("today") || iSimpleFilterEntry.getType().getCode().equalsIgnoreCase("previous_scheduled_date"))) {
                    return true;
                }
                if (stringArray == null || stringArray.length <= 0) continue;
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    if (string != null && string.length() > 0) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private boolean entriesModified() {
        if (this.searchEntries != null) {
            for (IAdvancedFilterEntry iAdvancedFilterEntry : this.searchEntries) {
                if (!iAdvancedFilterEntry.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    private void fireSearchEntryAdded(IAdvancedFilterEntry iAdvancedFilterEntry) {
        for (IFilterListener iFilterListener : this.listener) {
            iFilterListener.searchEntriesChanged(this);
            if (!(iFilterListener instanceof IAdvancedFilterListener)) continue;
            ((IAdvancedFilterListener)iFilterListener).entryAdded(this, iAdvancedFilterEntry);
        }
    }

    private void fireSearchEntryRemoved(IAdvancedFilterEntry iAdvancedFilterEntry) {
        for (IFilterListener iFilterListener : this.listener) {
            iFilterListener.searchEntriesChanged(this);
            if (!(iFilterListener instanceof IAdvancedFilterListener)) continue;
            ((IAdvancedFilterListener)iFilterListener).entryRemoved(this, iAdvancedFilterEntry);
        }
    }

    private void fireAllSearchEntriesRemoved() {
        for (IFilterListener iFilterListener : this.listener) {
            iFilterListener.allSearchEntriesRemoved(this);
        }
    }

    private void saveXML(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iConfigurationProvider, (String)"advancedFilterXML", (String)this.toXML());
            this.modified = false;
        }
        catch (Exception exception) {
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    public void initXML(Node node) throws Exception {
        Node node2 = node instanceof Document ? ((Document)node).getDocumentElement() : node;
        NamedNodeMap namedNodeMap = node2.getAttributes();
        String string = namedNodeMap.getNamedItem("filter_name").getNodeValue();
        String string2 = namedNodeMap.getNamedItem("filter_minimum_level").getNodeValue();
        String string3 = namedNodeMap.getNamedItem("semantic-PN-matching-requested") != null ? namedNodeMap.getNamedItem("semantic-PN-matching-requested").getNodeValue() : null;
        int n = Integer.valueOf(string2);
        this.setFilterName(string);
        if (n >= Level.Patient.ordinal() && n <= Level.Object.ordinal()) {
            this.setMinLevel(Level.get((IPatientHierarchy)Level.get((int)n)));
        }
        if (string3 != null) {
            this.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, Boolean.valueOf(string3));
        }
        this.removeAllEntries();
        NodeList nodeList = node2.getChildNodes();
        if (nodeList != null) {
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                try {
                    Node node3 = nodeList.item(n2);
                    String string4 = node3.getAttributes().getNamedItem("type").getNodeValue();
                    IAdvancedFilterEntry iAdvancedFilterEntry = AdvancedEntryRegistry.getInstance().getNewEntry(string4);
                    iAdvancedFilterEntry.initFromXML(node3);
                    this.addEntry(iAdvancedFilterEntry);
                }
                catch (Exception exception) {
                    log.error("Reading/Creating filter entry failed. Skipped!", (Throwable)exception);
                }
                ++n2;
            }
        }
        this.modified = false;
    }

    private void initXML(IConfigurationProvider iConfigurationProvider) throws IOException {
        try {
            this.initXML(ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)"advancedFilterXML"));
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    private void initLegacy(IConfigurationProvider iConfigurationProvider) throws IOException {
        if (iConfigurationProvider == null) {
            throw new IOException("Configuration Provider is null!");
        }
        try {
            int n;
            String string = iConfigurationProvider.getString("filter_name");
            Level level = null;
            if (iConfigurationProvider.exists("filter_minimum_level") && (n = (int)iConfigurationProvider.getLong("filter_minimum_level")) >= Level.Patient.ordinal() && n <= Level.Object.ordinal()) {
                level = Level.get((IPatientHierarchy)Level.get((int)n));
            }
            ArrayList<IAdvancedFilterEntry> arrayList = new ArrayList<IAdvancedFilterEntry>();
            IConfigurationList iConfigurationList = iConfigurationProvider.getList("filter_entries");
            for (IConfigurationProvider object : iConfigurationList) {
                String string2 = object.getString("type");
                IAdvancedFilterEntry iAdvancedFilterEntry = AdvancedEntryRegistry.getInstance().getNewEntry(string2);
                iAdvancedFilterEntry.init(object);
                arrayList.add(iAdvancedFilterEntry);
            }
            this.setFilterName(string);
            this.setMinLevel(level);
            this.removeAllEntries();
            for (IAdvancedFilterEntry iAdvancedFilterEntry : arrayList) {
                this.addEntry(iAdvancedFilterEntry);
            }
            this.modified = false;
        }
        catch (Exception exception) {
            log.error(null, (Throwable)exception);
            IOException iOException = (IOException)new IOException(exception.getMessage()).initCause(exception);
            throw iOException;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" '");
        stringBuilder.append(this.name);
        stringBuilder.append("': ");
        stringBuilder.append(this.searchEntries);
        return stringBuilder.toString();
    }
}

